/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.listbox;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.listbox.ListBoxBase;
import com.vaadin.flow.data.selection.MultiSelect;
import com.vaadin.flow.data.selection.MultiSelectionEvent;
import com.vaadin.flow.data.selection.MultiSelectionListener;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class MultiSelectListBox<T>
extends ListBoxBase<MultiSelectListBox<T>, T, Set<T>>
implements MultiSelect<MultiSelectListBox<T>, T> {
    public MultiSelectListBox() {
        super("selectedValues", JsonArray.class, Collections.emptySet(), MultiSelectListBox::presentationToModel, MultiSelectListBox::modelToPresentation);
        this.getElement().setProperty("multiple", true);
    }

    private static <T> Set<T> presentationToModel(MultiSelectListBox<T> listBox, JsonArray presentation) {
        Set modelValue = IntStream.range(0, presentation.length()).map(i -> (int)presentation.getNumber(i)).mapToObj(index -> listBox.getItems().get(index)).collect(Collectors.toSet());
        return Collections.unmodifiableSet(modelValue);
    }

    private static <T> JsonArray modelToPresentation(MultiSelectListBox<T> listBox, Set<T> model) {
        JsonArray array = Json.createArray();
        model.stream().map(listBox.getItems()::indexOf).forEach(index -> array.set(array.length(), (double)index.intValue()));
        return array;
    }

    public void setValue(Set<T> value) {
        Objects.requireNonNull(value, "Cannot set a null value to multi select list box. Use the clear-method to reset the component's value to an empty set.");
        super.setValue(value);
    }

    public void updateSelection(Set<T> addedItems, Set<T> removedItems) {
        HashSet<T> value = new HashSet<T>((Collection)this.getValue());
        value.addAll(addedItems);
        value.removeAll(removedItems);
        this.setValue(value);
    }

    public Set<T> getSelectedItems() {
        return (Set)this.getValue();
    }

    public Registration addSelectionListener(MultiSelectionListener<MultiSelectListBox<T>, T> listener) {
        return this.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> listener.selectionChange(new MultiSelectionEvent((Component)this, (HasValue)this, (Set)event.getOldValue(), event.isFromClient())));
    }
}

