/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.grid;

import com.vaadin.flow.component.grid.AbstractColumn;
import com.vaadin.flow.component.grid.ColumnGroup;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.dom.Element;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

class ColumnGroupHelpers {
    ColumnGroupHelpers() {
    }

    public static List<AbstractColumn<?>> wrapInSeparateColumnGroups(Collection<AbstractColumn<?>> cols, Grid<?> grid) {
        return cols.stream().map(col -> ColumnGroupHelpers.wrapSingleColumn(col, grid)).collect(Collectors.toList());
    }

    public static ColumnGroup wrapInColumnGroup(Grid<?> grid, AbstractColumn<?> ... columns) {
        ColumnGroup group = ColumnGroupHelpers.wrapSingleColumn(columns[0], grid);
        for (int i = 1; i < columns.length; ++i) {
            group.getElement().appendChild(new Element[]{columns[i].getElement()});
        }
        return group;
    }

    public static ColumnGroup wrapInColumnGroup(Grid<?> grid, List<AbstractColumn<?>> columns) {
        return ColumnGroupHelpers.wrapInColumnGroup(grid, columns.toArray(new AbstractColumn[columns.size()]));
    }

    private static ColumnGroup wrapSingleColumn(AbstractColumn<?> column, Grid<?> grid) {
        Element parent = column.getElement().getParent();
        int index = parent.indexOfChild(column.getElement());
        column.getElement().removeFromParent();
        ColumnGroup group = new ColumnGroup(grid, column);
        parent.insertChild(index, new Element[]{group.getElement()});
        return group;
    }
}

