/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver.util;

import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.server.frontend.FrontendTools;
import com.vaadin.flow.server.frontend.FrontendToolsSettings;
import com.vaadin.flow.server.frontend.FrontendUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLauncher {
    private static File bundleTempFile;

    private BrowserLauncher() {
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(BrowserLauncher.class);
    }

    private static int runNodeCommands(String script) throws InterruptedException, IOException {
        FrontendToolsSettings settings = new FrontendToolsSettings("", (SerializableSupplier & Serializable)() -> FrontendUtils.getVaadinHomeDirectory().getAbsolutePath());
        FrontendTools tools = new FrontendTools(settings);
        String node = tools.getNodeExecutable();
        ArrayList<String> command = new ArrayList<String>();
        command.add(node);
        command.add("-e");
        command.add(script);
        ProcessBuilder builder = FrontendUtils.createProcessBuilder(command);
        return builder.start().waitFor();
    }

    private static File getBundleFile() {
        if (bundleTempFile != null) {
            return bundleTempFile;
        }
        try {
            bundleTempFile = File.createTempFile("vaadin-dev-server-bundle", "js");
            bundleTempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(bundleTempFile);){
                IOUtils.copyLarge((InputStream)BrowserLauncher.class.getResourceAsStream("/vaadin-dev-server-node-bundle.js"), (OutputStream)out);
            }
            return bundleTempFile;
        }
        catch (Exception e) {
            BrowserLauncher.getLogger().error("Unable to create temp file for bundle", (Throwable)e);
            return null;
        }
    }

    public static void launch(String location) {
        BrowserLauncher.launch(location, "Unable to open " + location + " in a browser");
    }

    public static void launch(String location, String alternativeText) {
        try {
            File bundleFile = BrowserLauncher.getBundleFile();
            if (bundleFile == null) {
                return;
            }
            String bundleFilePath = bundleFile.getAbsolutePath().replace("\\", "/");
            String cmd = String.format("const open = require('%s').open;open('%s');", bundleFilePath, location.replace("'", "\\'"));
            BrowserLauncher.runNodeCommands(cmd);
        }
        catch (Exception e) {
            BrowserLauncher.getLogger().debug("Unable to launch browser", (Throwable)e);
            BrowserLauncher.getLogger().info(alternativeText);
        }
    }
}

