/*
 * Copyright 2011 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dom.client;

/**
 * Constant strings representing browser events.
 */
public class BrowserEvents {

  public static final String BLUR = "blur";
  public static final String CANPLAYTHROUGH = "canplaythrough";
  public static final String CHANGE = "change";
  public static final String CLICK = "click";
  public static final String CONTEXTMENU = "contextmenu";
  public static final String DBLCLICK = "dblclick";
  public static final String DRAG = "drag";
  public static final String DRAGEND = "dragend";
  public static final String DRAGENTER = "dragenter";
  public static final String DRAGLEAVE = "dragleave";
  public static final String DRAGOVER = "dragover";
  public static final String DRAGSTART = "dragstart";
  public static final String DROP = "drop";
  public static final String ENDED = "ended";
  public static final String ERROR = "error";
  public static final String FOCUS = "focus";
  public static final String FOCUSIN = "focusin";
  public static final String FOCUSOUT = "focusout";
  public static final String GESTURECHANGE = "gesturechange";
  public static final String GESTUREEND = "gestureend";
  public static final String GESTURESTART = "gesturestart";
  public static final String KEYDOWN = "keydown";
  public static final String KEYPRESS = "keypress";
  public static final String KEYUP = "keyup";
  public static final String LOAD = "load";
  public static final String LOSECAPTURE = "losecapture";
  public static final String MOUSEDOWN = "mousedown";
  public static final String MOUSEMOVE = "mousemove";
  public static final String MOUSEOUT = "mouseout";
  public static final String MOUSEOVER = "mouseover";
  public static final String MOUSEUP = "mouseup";
  public static final String MOUSEWHEEL = "mousewheel";
  public static final String PROGRESS = "progress";
  public static final String SCROLL = "scroll";
  public static final String TOUCHCANCEL = "touchcancel";
  public static final String TOUCHEND = "touchend";
  public static final String TOUCHMOVE = "touchmove";
  public static final String TOUCHSTART = "touchstart";
  public static final String MSPOINTERDOWN = "MSPointerDown";
  public static final String MSPOINTERMOVE = "MSPointerMove";
  public static final String MSPOINTEROUT = "MSPointerOut";
  public static final String MSPOINTEROVER = "MSPointerOver";
  public static final String MSPOINTERUP = "MSPointerUp";
  public static final String MSPOINTERCANCEL = "MSPointerCancel";

  // Prevents instantiation and subclassing.
  private BrowserEvents() {
  }
}
