/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.LoggerFactory;

public class Platform
implements Serializable {
    private static boolean versionErrorLogged = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<String> getVaadinVersion() {
        try (InputStream vaadinVersionsStream = Platform.class.getClassLoader().getResourceAsStream("vaadin-core-versions.json");){
            if (vaadinVersionsStream != null) {
                ObjectMapper m = new ObjectMapper();
                JsonNode vaadinVersions = m.readTree(vaadinVersionsStream);
                Optional<String> optional = Optional.of(vaadinVersions.get("platform").asText());
                return optional;
            }
            if (versionErrorLogged) return Optional.empty();
            versionErrorLogged = true;
            LoggerFactory.getLogger(Platform.class).info("Unable to determine version information. No vaadin-core-versions.json found");
            return Optional.empty();
        }
        catch (Exception e) {
            LoggerFactory.getLogger(Platform.class).error("Unable to determine version information", (Throwable)e);
        }
        return Optional.empty();
    }
}

