/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.templatemodel;

import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.templatemodel.AllowClientUpdates;
import com.vaadin.flow.templatemodel.BasicComplexModelType;
import com.vaadin.flow.templatemodel.BasicModelType;
import com.vaadin.flow.templatemodel.ClientUpdateMode;
import com.vaadin.flow.templatemodel.ComplexModelType;
import com.vaadin.flow.templatemodel.ConvertedModelType;
import com.vaadin.flow.templatemodel.Encode;
import com.vaadin.flow.templatemodel.Exclude;
import com.vaadin.flow.templatemodel.Include;
import com.vaadin.flow.templatemodel.InvalidTemplateModelException;
import com.vaadin.flow.templatemodel.ListModelType;
import com.vaadin.flow.templatemodel.ModelEncoder;
import com.vaadin.flow.templatemodel.ModelType;
import com.vaadin.flow.templatemodel.PathLookup;
import com.vaadin.flow.templatemodel.PropertyFilter;
import com.vaadin.flow.templatemodel.PropertyMapBuilder;
import com.vaadin.flow.templatemodel.TemplateModelProxyHandler;
import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

@Deprecated
public class BeanModelType<T>
implements ComplexModelType<T> {
    private final HashMap<String, BeanModelTypeProperty> properties;
    private final Class<T> proxyType;
    private static final ReflectionCache<Object, Map<String, Method>> beanPropertyCache = new ReflectionCache(BeanModelType::findBeanGetters);
    private static final Set<Class<?>> UNSUPPORTED_BOXED_TYPES = Collections.unmodifiableSet(Stream.of(Long.class, Float.class, Byte.class, Character.class, Short.class).collect(Collectors.toSet()));

    protected BeanModelType(Class<T> proxyType, Map<String, BeanModelTypeProperty> properties, boolean allowEmptyProperties) {
        assert (proxyType != null);
        assert (properties != null);
        if (!allowEmptyProperties && properties.isEmpty()) {
            throw new IllegalArgumentException(String.format("No properties are defined for the model bean type '%s'. Such bean is always represented by an empty object during server-client communication. It might be that you are trying to use some abstract super class which is not a bean instead of its direct bean subclass", proxyType.getCanonicalName()));
        }
        this.proxyType = proxyType;
        this.properties = new HashMap<String, BeanModelTypeProperty>(properties);
    }

    private BeanModelType(Class<T> javaType, PropertyFilter propertyFilter, PathLookup<ModelEncoder<?, ?>> converterLookup, PathLookup<ClientUpdateMode> clientUpdateLookup) {
        this(javaType, new PropertyMapBuilder(javaType, propertyFilter, converterLookup, clientUpdateLookup).getProperties(), false);
    }

    protected BeanModelType(Class<T> javaType, PropertyFilter propertyFilter, boolean allowEmptyProperties) {
        this(javaType, new PropertyMapBuilder(javaType, propertyFilter, PathLookup.empty(), PathLookup.empty()).getProperties(), allowEmptyProperties);
    }

    static ModelType getModelType(Type propertyType, PropertyFilter propertyFilter, String propertyName, Class<?> declaringClass, PathLookup<ModelEncoder<?, ?>> converterLookup, PathLookup<ClientUpdateMode> clientUpdateLookup) {
        if (propertyType instanceof Class) {
            Class propertyTypeClass = (Class)propertyType;
            if (BeanModelType.isBean(propertyTypeClass)) {
                return new BeanModelType(propertyTypeClass, propertyFilter, converterLookup, clientUpdateLookup);
            }
            Optional<ModelType> maybeBasicModelType = BasicModelType.get(propertyTypeClass);
            if (maybeBasicModelType.isPresent()) {
                return maybeBasicModelType.get();
            }
        } else if (ListModelType.isList(propertyType)) {
            return BeanModelType.getListModelType(propertyType, propertyFilter, propertyName, declaringClass, converterLookup, clientUpdateLookup);
        }
        throw new InvalidTemplateModelException(String.format("Type '%s' is not supported. Used in class '%s' with property named '%s'. %s. Use @%s annotation to convert the type to a supported type.", propertyType.toString(), declaringClass.getSimpleName(), propertyName, ModelType.getSupportedTypesString(), Encode.class.getSimpleName()));
    }

    static ModelType getConvertedModelType(Type propertyType, PropertyFilter propertyFilter, String propertyName, Class<?> declaringClass, PathLookup<ModelEncoder<?, ?>> converterLookup, PathLookup<ClientUpdateMode> clientUpdateLookup) {
        if (!(propertyType instanceof Class)) {
            throw new UnsupportedOperationException(String.format("Using converters with parameterized types is not currently supported.Used in class '%s' with property named '%s'", declaringClass.getSimpleName(), propertyName));
        }
        Optional<ModelEncoder<?, ?>> converterOptional = converterLookup.getItem(propertyFilter.getPrefix());
        if (!converterOptional.isPresent()) {
            throw new IllegalStateException("The ModelConverterProvider passed to getConvertedModelType is unable to provide a converter for the given PropertyFilter.");
        }
        ModelEncoder<?, ?> converter = converterOptional.get();
        if (!BeanModelType.isCompatible(converter.getDecodedType(), propertyType)) {
            throw new InvalidTemplateModelException(String.format("Converter '%s' is incompatible with the type '%s'.", converter.getClass().getName(), propertyType.getTypeName()));
        }
        if (BeanModelType.isBean(converter.getEncodedType())) {
            return new ConvertedModelType(new BeanModelType(converter.getEncodedType(), propertyFilter, converterLookup, clientUpdateLookup), converter);
        }
        Optional<ModelType> maybeBasicModelType = BasicModelType.get(converter.getEncodedType());
        if (maybeBasicModelType.isPresent()) {
            return new ConvertedModelType(maybeBasicModelType.get(), converter);
        }
        throw new InvalidTemplateModelException(String.format("Converter '%s' implements an unsupported model type. Used in class '%s' with property named '%s'. '%s'", converter.getClass().getName(), declaringClass.getSimpleName(), propertyName, ModelType.getSupportedTypesString()));
    }

    private static boolean isCompatible(Class<?> clazz, Type type) {
        if (clazz.equals(type)) {
            return true;
        }
        if (type instanceof Class) {
            return ReflectTools.convertPrimitiveType(clazz).equals(ReflectTools.convertPrimitiveType((Class)((Class)type)));
        }
        return false;
    }

    private static ModelType getListModelType(Type propertyType, PropertyFilter propertyFilter, String propertyName, Class<?> declaringClass, PathLookup<ModelEncoder<?, ?>> converterLookup, PathLookup<ClientUpdateMode> clientUpdateLookup) {
        assert (ListModelType.isList(propertyType));
        ParameterizedType pt = (ParameterizedType)propertyType;
        Type itemType = pt.getActualTypeArguments()[0];
        if (itemType instanceof ParameterizedType) {
            return new ListModelType((ComplexModelType)BeanModelType.getModelType(itemType, propertyFilter, propertyName, declaringClass, converterLookup, clientUpdateLookup));
        }
        if (BasicComplexModelType.isBasicType(itemType)) {
            return new ListModelType(BasicComplexModelType.get((Class)itemType).get());
        }
        if (BeanModelType.isBean(itemType)) {
            Class beansListItemType = (Class)itemType;
            return new ListModelType(new BeanModelType(beansListItemType, propertyFilter, converterLookup, clientUpdateLookup));
        }
        throw new InvalidTemplateModelException(String.format("Element type '%s' is not a valid Bean type. Used in class '%s' with property named '%s' with list type '%s'.", itemType.getTypeName(), declaringClass.getSimpleName(), propertyName, propertyType.getTypeName()));
    }

    public static boolean isBean(Type type) {
        if (!(type instanceof Class)) {
            return false;
        }
        Class cls = (Class)type;
        if (BasicModelType.get(cls).isPresent() || BeanModelType.isBoxedUnsupportedType(cls)) {
            return false;
        }
        if (cls.isPrimitive()) {
            return false;
        }
        return !cls.isArray();
    }

    public boolean hasProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public ModelType getPropertyType(String propertyName) {
        return this.getExistingProperty(propertyName).getType();
    }

    protected ClientUpdateMode getClientUpdateMode(BeanModelTypeProperty property) {
        ClientUpdateMode clientUpdateMode = property.getClientUpdateMode();
        if (clientUpdateMode == null) {
            return ClientUpdateMode.IF_TWO_WAY_BINDING;
        }
        return clientUpdateMode;
    }

    protected BeanModelTypeProperty getExistingProperty(String propertyName) {
        assert (this.hasProperty(propertyName));
        return this.properties.get(propertyName);
    }

    public T modelToApplication(Serializable modelValue) {
        if (modelValue == null) {
            return null;
        }
        if (modelValue instanceof StateNode) {
            return TemplateModelProxyHandler.createModelProxy((StateNode)modelValue, this);
        }
        if (modelValue instanceof JsonObject) {
            throw new IllegalArgumentException(String.format("The stored model value '%s' is a JSON object. It looks like you have receieved a plain JSON from the client side and try to use it as a model. Check your model definition. Client side objects cannot be converted automatically to model bean instances. Most likely you should use JsonValue type for your model property", modelValue));
        }
        throw new IllegalArgumentException(String.format("The stored model value '%s' type '%s' cannot be used as a type for a model property", modelValue, modelValue.getClass().getName()));
    }

    public Class<T> getProxyType() {
        return this.proxyType;
    }

    @Override
    public StateNode applicationToModel(Object applicationValue, PropertyFilter filter) {
        if (applicationValue == null) {
            return null;
        }
        StateNode node = new StateNode(Collections.singletonList(ElementPropertyMap.class), new Class[0]);
        this.importProperties(ElementPropertyMap.getModel((StateNode)node), applicationValue, filter);
        return node;
    }

    public void importProperties(ElementPropertyMap model, Object bean, PropertyFilter propertyFilter) {
        Class<?> beanClass = bean.getClass();
        assert (BeanModelType.isBean(beanClass));
        HashMap<String, Object> values = new HashMap<String, Object>();
        ((Map)beanPropertyCache.get(beanClass)).forEach((propertyName, getter) -> {
            if (!this.hasProperty((String)propertyName) || !propertyFilter.test((String)propertyName)) {
                return;
            }
            Type getterType = getter.getGenericReturnType();
            ModelType propertyType = this.getPropertyType((String)propertyName);
            if (!propertyType.accepts(getterType)) {
                throw new IllegalArgumentException(String.format("Expected type '%s' for property '%s' but imported type is '%s'", propertyType.getJavaType().getTypeName(), propertyName, getterType.getTypeName()));
            }
            try {
                Object value = getter.invoke(bean, new Object[0]);
                values.put((String)propertyName, value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot access bean property " + propertyName, e);
            }
        });
        values.forEach((name, value) -> {
            ModelType type = this.getPropertyType((String)name);
            model.setProperty(name, type.applicationToModel(value, new PropertyFilter(propertyFilter, (String)name)));
        });
    }

    public ModelType resolveType(String modelPath) {
        assert (modelPath != null);
        if (modelPath.isEmpty()) {
            return this;
        }
        String[] parts = modelPath.split("\\.", 2);
        String propertyName = parts[0];
        if (!this.hasProperty(propertyName)) {
            throw new IllegalArgumentException("No such property: " + propertyName);
        }
        ModelType propertyType = this.getPropertyType(propertyName);
        if (parts.length == 1) {
            return propertyType;
        }
        String subPath = parts[1];
        if (propertyType instanceof BeanModelType) {
            return ((BeanModelType)propertyType).resolveType(subPath);
        }
        throw new IllegalArgumentException(propertyName + " is not a bean");
    }

    @Override
    public <C> BeanModelType<C> cast(Class<C> proxyType) {
        if (this.getProxyType() != proxyType) {
            throw new IllegalArgumentException("Got " + proxyType + ", expected " + this.getProxyType());
        }
        return this;
    }

    public Stream<String> getPropertyNames() {
        return this.properties.keySet().stream();
    }

    @Override
    public boolean accepts(Type applicationType) {
        return BeanModelType.isBean(applicationType);
    }

    @Override
    public Type getJavaType() {
        return this.proxyType;
    }

    @Override
    public JsonValue toJson() {
        JsonObject json = Json.createObject();
        this.properties.forEach((name, property) -> json.put(name, property.getType().toJson()));
        return json;
    }

    @Override
    public void createInitialValue(StateNode node, String property) {
        this.createInitialValues(((ElementPropertyMap)node.getFeature(ElementPropertyMap.class)).resolveModelMap(property).getNode());
    }

    public void createInitialValues(StateNode node) {
        Predicate<Map.Entry> isFinal = entry -> Modifier.isFinal(((Method)entry.getValue()).getModifiers());
        Predicate<Map.Entry> isProperty = entry -> this.hasProperty((String)entry.getKey());
        StringBuilder builder = new StringBuilder();
        BeanModelType.findBeanGetters(this.getProxyType()).entrySet().stream().filter(isFinal).filter(isProperty).forEach(entry -> this.writeInvalidAccessor((Map.Entry<String, Method>)entry, builder, "getter"));
        BeanModelType.findBeanSetters(this.getProxyType()).entrySet().stream().filter(isFinal).filter(isProperty).forEach(entry -> this.writeInvalidAccessor((Map.Entry<String, Method>)entry, builder, "setter"));
        if (builder.length() > 0) {
            builder.insert(0, "Bean type '" + this.getProxyType() + "' cannot be used in the template model because it has accessors which cannot be proxied:\n");
            builder.append("Use @").append(Exclude.class.getSimpleName()).append(" or @").append(Include.class.getSimpleName()).append(" annotations to limit properties to use in the model so that all properties with final accessors are excluded from the model");
            throw new IllegalStateException(builder.toString());
        }
        this.properties.forEach((name, property) -> property.getType().createInitialValue(node, (String)name));
    }

    public Map<String, Boolean> getClientUpdateAllowedProperties(Set<String> twoWayBindingPaths) {
        HashMap<String, Boolean> allowedProperties = new HashMap<String, Boolean>();
        this.collectAllowedProperties("", allowedProperties, Collections.unmodifiableSet(twoWayBindingPaths));
        return allowedProperties;
    }

    private void writeInvalidAccessor(Map.Entry<String, Method> entry, StringBuilder builder, String accessorType) {
        builder.append("property '").append(entry.getKey()).append("' has final ").append(accessorType).append(" '").append(entry.getValue().getName()).append("'\n");
    }

    private static Map<String, Method> findBeanGetters(Class<?> beanType) {
        return ReflectTools.getGetterMethods(beanType).collect(Collectors.toMap(ReflectTools::getPropertyName, Function.identity(), (getter1, getter2) -> getter1));
    }

    private static Map<String, Method> findBeanSetters(Class<?> beanType) {
        return ReflectTools.getSetterMethods(beanType).collect(Collectors.toMap(ReflectTools::getPropertyName, Function.identity()));
    }

    private void collectAllowedProperties(String prefix, Map<String, Boolean> allowedProperties, Set<String> twoWayBindingPaths) {
        this.properties.forEach((name, property) -> {
            String fullName = prefix + name;
            BeanModelTypeProperty modelProperty = this.getExistingProperty((String)name);
            ClientUpdateMode clientUpdateMode = this.getClientUpdateMode(modelProperty);
            if (clientUpdateMode == ClientUpdateMode.ALLOW || clientUpdateMode == ClientUpdateMode.IF_TWO_WAY_BINDING && twoWayBindingPaths.contains(fullName)) {
                allowedProperties.put(fullName, modelProperty.hasGetter());
            }
            if (clientUpdateMode == ClientUpdateMode.DENY && modelProperty.hasGetter()) {
                LoggerFactory.getLogger(BeanModelType.class).debug("There is a getter for the property '{}' whose update from the client-side to the server-side is explicitly forbidden via @'{}' annotation value '{}'.", new Object[]{fullName, AllowClientUpdates.class.getSimpleName(), ClientUpdateMode.DENY});
            } else if (clientUpdateMode == ClientUpdateMode.IF_TWO_WAY_BINDING && !twoWayBindingPaths.contains(fullName) && modelProperty.hasGetter()) {
                LoggerFactory.getLogger(BeanModelType.class).debug("There is a getter for the property '{}' whose update from the client-side to the server-side is forbidden because the property is not atwo way binding property but it's required to be (implicitly if there is no '{}' annotation for this property or explicitly if it's value is '{}')", new Object[]{fullName, AllowClientUpdates.class.getSimpleName(), ClientUpdateMode.IF_TWO_WAY_BINDING});
            }
            ModelType propertyType = BeanModelType.unwrapTypes(property.getType());
            BeanModelType<?> beanType = null;
            if (propertyType instanceof BeanModelType) {
                beanType = (BeanModelType<?>)propertyType;
            } else if (propertyType instanceof ListModelType) {
                beanType = this.getListItemBeanModelType((ListModelType)propertyType);
            }
            if (beanType != null) {
                beanType.collectAllowedProperties(fullName + ".", allowedProperties, twoWayBindingPaths);
            }
        });
    }

    private BeanModelType<?> getListItemBeanModelType(ListModelType<?> type) {
        ComplexModelType<?> itemType = type.getItemType();
        if (itemType instanceof BeanModelType) {
            return (BeanModelType)itemType;
        }
        if (itemType instanceof ListModelType) {
            return this.getListItemBeanModelType((ListModelType)itemType);
        }
        return null;
    }

    private static ModelType unwrapTypes(ModelType type) {
        if (type instanceof ConvertedModelType) {
            return BeanModelType.unwrapTypes(((ConvertedModelType)type).getWrappedModelType());
        }
        return type;
    }

    private static boolean isBoxedUnsupportedType(Class<?> clazz) {
        return UNSUPPORTED_BOXED_TYPES.contains(clazz);
    }

    static class BeanModelTypeProperty
    implements Serializable {
        private final ModelType propretyType;
        private final ClientUpdateMode clientUpdateMode;
        private final boolean hasGetter;

        public BeanModelTypeProperty(ModelType propretyType, ClientUpdateMode clientUpdateMode, boolean hasGetter) {
            this.propretyType = propretyType;
            this.clientUpdateMode = clientUpdateMode;
            this.hasGetter = hasGetter;
        }

        public ModelType getType() {
            return this.propretyType;
        }

        public ClientUpdateMode getClientUpdateMode() {
            return this.clientUpdateMode;
        }

        boolean hasGetter() {
            return this.hasGetter;
        }
    }
}

