/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.polymertemplate.JsoupUtils;
import com.vaadin.flow.internal.StringUtil;
import com.vaadin.flow.server.VaadinService;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public final class BundleParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(BundleParser.class);
    private static final String SOURCE = "source";
    private static final String NAME = "name";
    private static final String CHUNKS = "chunks";
    private static final String MODULES = "modules";
    private static final Pattern POLYMER_TEMPLATE_PATTERN = Pattern.compile("get[\\s]*template\\(\\)[\\s]*\\{[\\s]*return[\\s]*html[\\s]*([\\`\\'\\\"])([\\s\\S]*)\\1;[\\s]*\\}");
    private static final Pattern NO_TEMPLATE_PATTERN = Pattern.compile("innerHTML[\\s]*=[\\s]*([\\`\\'\\\"])([\\s]*<dom-module\\s+[\\s\\S]*)\\1;");
    private static final Pattern HASH_PATTERN = Pattern.compile("\"hash\"\\s*:\\s*\"([^\"]+)\"\\s*,");
    private static final String TEMPLATE_TAG_NAME = "template";

    private BundleParser() {
    }

    public static String getHashFromStatistics(String fileContents) {
        Matcher matcher = HASH_PATTERN.matcher(fileContents);
        return matcher.find() ? matcher.group(1) : "" + fileContents.length();
    }

    public static JsonObject parseJsonStatistics(String fileContents) {
        return Json.parse((String)fileContents);
    }

    public static String getSourceFromStatistics(String fileName, JsonObject statistics, VaadinService service) {
        return BundleParser.getSourceFromObject(statistics, fileName, service);
    }

    public static Element parseTemplateElement(String name, JsonObject statisticsJson) {
        return BundleParser.parseTemplateElement(name, statisticsJson.getString(SOURCE));
    }

    public static Element parseTemplateElement(String fileName, String source) {
        Element template;
        Document templateDocument = null;
        String content = StringUtil.removeComments((String)source);
        Matcher templateMatcher = POLYMER_TEMPLATE_PATTERN.matcher(content);
        Matcher noTemplateMatcher = NO_TEMPLATE_PATTERN.matcher(content);
        if (templateMatcher.find() && templateMatcher.groupCount() == 2) {
            String group = templateMatcher.group(2);
            LOGGER.trace("Found regular Polymer 3 template content was {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
        } else {
            template = BundleParser.tryParsePolymer2(templateDocument, noTemplateMatcher);
            if (template != null) {
                return template;
            }
        }
        if (templateDocument == null) {
            LOGGER.warn("No polymer template data found in {} sources.", (Object)fileName);
            templateDocument = new Document("");
            templateDocument.appendChild((Node)templateDocument.createElement("body"));
        }
        template = templateDocument.createElement(TEMPLATE_TAG_NAME);
        Element body = templateDocument.body();
        templateDocument.body().children().stream().filter(node -> !node.equals((Object)body)).forEach(arg_0 -> ((Element)template).appendChild(arg_0));
        return template;
    }

    private static Element tryParsePolymer2(Document templateDocument, Matcher noTemplateMatcher) {
        while (noTemplateMatcher.find() && noTemplateMatcher.groupCount() == 2) {
            String group = noTemplateMatcher.group(2);
            LOGGER.trace("Found Polymer 2 style insertion as a Polymer 3 template content {}", (Object)group);
            templateDocument = Jsoup.parse((String)group);
            LOGGER.trace("The parsed template document was {}", (Object)templateDocument);
            Optional<Element> domModule = JsoupUtils.getDomModule((Element)templateDocument, null);
            if (!domModule.isPresent()) continue;
            JsoupUtils.removeCommentsRecursively((Node)domModule.get());
            Elements templates = domModule.get().getElementsByTag(TEMPLATE_TAG_NAME);
            if (templates.isEmpty()) continue;
            return (Element)templates.get(0);
        }
        return null;
    }

    private static String getSourceFromObject(JsonObject module, String fileName, VaadinService service) {
        String source = null;
        if (BundleParser.validKey(module, MODULES, JsonType.ARRAY)) {
            source = BundleParser.getSourceFromArray(module.getArray(MODULES), fileName, service);
        }
        if (source == null && BundleParser.validKey(module, CHUNKS, JsonType.ARRAY)) {
            source = BundleParser.getSourceFromArray(module.getArray(CHUNKS), fileName, service);
        }
        if (source == null && BundleParser.validKey(module, NAME, JsonType.STRING) && BundleParser.validKey(module, SOURCE, JsonType.STRING)) {
            String name = module.getString(NAME);
            String alternativeFileName = fileName.replaceFirst("^(\\./)frontend/", "$1").replaceFirst("^frontend://", ".");
            if (name.contains("@vaadin/flow-frontend/") || name.contains(service.getDeploymentConfiguration().getFlowResourcesFolder().replaceAll("\\\\", "/"))) {
                alternativeFileName = alternativeFileName.replaceFirst("\\./", "");
            }
            if ((name = name.replaceFirst("\\?.+$", "")).endsWith(fileName) || name.endsWith(alternativeFileName)) {
                source = module.getString(SOURCE);
            }
        }
        return source;
    }

    private static String getSourceFromArray(JsonArray objects, String fileName, VaadinService service) {
        String source = null;
        for (int i = 0; source == null && i < objects.length(); ++i) {
            if (!objects.get(i).getType().equals((Object)JsonType.OBJECT)) continue;
            source = BundleParser.getSourceFromObject((JsonObject)objects.get(i), fileName, service);
        }
        return source;
    }

    private static boolean validKey(JsonObject o, String k, JsonType t) {
        boolean validKey = o != null && o.hasKey(k) && o.get(k).getType().equals((Object)t);
        return validKey && (!t.equals((Object)JsonType.STRING) || !o.getString(k).isEmpty());
    }
}

