/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.interceptor;

import java.util.concurrent.ConcurrentLinkedQueue;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereInterceptorAdapter;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.util.Utils;

public class SessionCreationInterceptor
extends AtmosphereInterceptorAdapter {
    private final ConcurrentLinkedQueue<String> ids = new ConcurrentLinkedQueue();

    @Override
    public Action inspect(AtmosphereResource r) {
        if (Utils.webSocketMessage(r)) {
            return Action.CONTINUE;
        }
        if (r.session(false) == null && !this.ids.remove(r.uuid()) && r.getRequest().getMethod().equalsIgnoreCase("GET")) {
            r.session(true);
            this.ids.offer(r.uuid());
            return Action.CANCELLED;
        }
        return Action.CONTINUE;
    }
}

