/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.staticlists.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import com.urbanairship.api.staticlists.model.StaticListView;
import java.util.Optional;

public class StaticListListingResponse {
    private final boolean ok;
    private final ImmutableList<StaticListView> staticListViews;
    private final Optional<String> error;
    private final Optional<ErrorDetails> errorDetails;

    private StaticListListingResponse(Builder builder) {
        this.ok = builder.ok;
        this.staticListViews = builder.staticListObjects.build();
        this.error = Optional.ofNullable(builder.error);
        this.errorDetails = Optional.ofNullable(builder.errorDetails);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean getOk() {
        return this.ok;
    }

    public ImmutableList<StaticListView> getStaticListViews() {
        return this.staticListViews;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "StaticListListingResponse{ok=" + this.ok + ", staticListViews=" + this.staticListViews + ", error=" + this.error + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.staticListViews, this.error, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StaticListListingResponse other = (StaticListListingResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.staticListViews, other.staticListViews) && Objects.equal(this.error, other.error) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        private boolean ok;
        private ImmutableList.Builder<StaticListView> staticListObjects = ImmutableList.builder();
        private String error;
        private ErrorDetails errorDetails;

        public Builder setOk(boolean value) {
            this.ok = value;
            return this;
        }

        public Builder addStaticList(StaticListView staticListObject) {
            this.staticListObjects.add((Object)staticListObject);
            return this;
        }

        public Builder addAllStaticLists(Iterable<? extends StaticListView> staticListObjects) {
            this.staticListObjects.addAll(staticListObjects);
            return this;
        }

        public Builder setError(String error) {
            this.error = error;
            return this;
        }

        public Builder setErrorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public StaticListListingResponse build() {
            return new StaticListListingResponse(this);
        }
    }
}

