/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.segments.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class SegmentListingView {
    private final String displayName;
    private final String segmentId;
    private final long creationDate;
    private final long modificationDate;

    private SegmentListingView(String displayName, String segmentId, long creationDate, long modificationDate) {
        this.displayName = displayName;
        this.segmentId = segmentId;
        this.creationDate = creationDate;
        this.modificationDate = modificationDate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public String getSegmentId() {
        return this.segmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getModificationDate() {
        return this.modificationDate;
    }

    public String toString() {
        return "SegmentListView{displayName=" + this.displayName + ", segmentId=" + this.segmentId + ", creationDate=" + this.creationDate + ", modificationDate=" + this.modificationDate + "}";
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.displayName, this.segmentId, this.creationDate, this.modificationDate});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SegmentListingView other = (SegmentListingView)obj;
        return Objects.equal((Object)this.displayName, (Object)other.displayName) && Objects.equal((Object)this.segmentId, (Object)other.segmentId) && Objects.equal((Object)this.creationDate, (Object)other.creationDate) && Objects.equal((Object)this.modificationDate, (Object)other.modificationDate);
    }

    public static final class Builder {
        private String displayName = null;
        private String segmentId = null;
        private long creationDate = -1L;
        private long modificationDate = -1L;

        private Builder() {
        }

        public Builder setDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder setId(String segmentId) {
            this.segmentId = segmentId;
            return this;
        }

        public Builder setCreationDate(long creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder setModificationDate(long modificationDate) {
            this.modificationDate = modificationDate;
            return this;
        }

        public SegmentListingView build() {
            Preconditions.checkNotNull((Object)this.displayName);
            Preconditions.checkNotNull((Object)this.segmentId);
            Preconditions.checkArgument((this.creationDate > -1L ? 1 : 0) != 0);
            Preconditions.checkArgument((this.modificationDate > -1L ? 1 : 0) != 0);
            return new SegmentListingView(this.displayName, this.segmentId, this.creationDate, this.modificationDate);
        }
    }
}

