/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.schedule.model;

import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.schedule.model.Schedule;
import com.urbanairship.api.schedule.parse.TimeZones;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;

public final class ScheduleValidator {
    public void validate(Schedule schedule) throws APIParsingException {
        if (!schedule.getLocalTimePresent().booleanValue() && schedule.getScheduledTimestamp().isBefore((ReadableInstant)DateTime.now().minusSeconds(1))) {
            throw new APIParsingException(String.format("Cannot schedule for the past %s", schedule.getScheduledTimestamp().toString()));
        }
        if (schedule.getLocalTimePresent().booleanValue()) {
            for (String tz : TimeZones.KNOWN_TIMEZONE_IDS) {
                DateTimeZone timeZone = DateTimeZone.forID((String)tz);
                if (!schedule.getScheduledTimestamp().toDateTime(timeZone).isBefore((ReadableInstant)DateTime.now().minusSeconds(1))) continue;
                throw new APIParsingException(String.format("The local time provided must be in the future for at least one time zone %s", schedule.getScheduledTimestamp().toString()));
            }
        }
    }
}

