/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.wns;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.push.model.notification.wns.WNSAudioData;
import com.urbanairship.api.push.parse.notification.wns.WNSSoundDeserializer;
import java.io.IOException;

public class WNSAudioReader
implements JsonObjectReader<WNSAudioData> {
    private final WNSAudioData.Builder builder = WNSAudioData.newBuilder();

    public void readSound(JsonParser parser, DeserializationContext context) throws IOException {
        this.builder.setSound(WNSSoundDeserializer.INSTANCE.deserialize(parser, context));
    }

    public void readLoop(JsonParser parser) throws IOException {
        this.builder.setLoop(BooleanFieldDeserializer.INSTANCE.deserialize(parser, "loop"));
    }

    @Override
    public WNSAudioData validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException("Toast audio element must contain a valid src.");
        }
    }
}

