/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.web;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.urbanairship.api.common.parse.APIParsingException;
import com.urbanairship.api.common.parse.BooleanFieldDeserializer;
import com.urbanairship.api.common.parse.JsonObjectReader;
import com.urbanairship.api.common.parse.MapOfStringsDeserializer;
import com.urbanairship.api.common.parse.StringFieldDeserializer;
import com.urbanairship.api.push.model.PushExpiry;
import com.urbanairship.api.push.model.notification.actions.Actions;
import com.urbanairship.api.push.model.notification.web.Button;
import com.urbanairship.api.push.model.notification.web.WebDevicePayload;
import com.urbanairship.api.push.model.notification.web.WebIcon;
import com.urbanairship.api.push.model.notification.web.WebImage;
import com.urbanairship.api.push.model.notification.web.WebTemplate;
import java.io.IOException;
import java.util.List;

public class WebDevicePayloadReader
implements JsonObjectReader<WebDevicePayload> {
    private WebDevicePayload.Builder builder = WebDevicePayload.newBuilder();

    public void readAlert(JsonParser parser) throws IOException {
        this.builder.setAlert(StringFieldDeserializer.INSTANCE.deserialize(parser, "alert"));
    }

    public void readTitle(JsonParser parser) throws IOException {
        this.builder.setTitle(StringFieldDeserializer.INSTANCE.deserialize(parser, "title"));
    }

    public void readExtra(JsonParser parser) throws IOException {
        this.builder.addAllExtraEntries(MapOfStringsDeserializer.INSTANCE.deserialize(parser, "extra"));
    }

    public void readWebIcon(JsonParser parser) throws IOException {
        this.builder.setWebIcon((WebIcon)parser.readValueAs(WebIcon.class));
    }

    public void readRequireInteraction(JsonParser parser) throws IOException {
        this.builder.setRequireInteraction(BooleanFieldDeserializer.INSTANCE.deserialize(parser, "require_interaction"));
    }

    public void readActions(JsonParser parser) throws IOException {
        this.builder.setActions((Actions)parser.readValueAs(Actions.class));
    }

    public void readWebImage(JsonParser parser) throws IOException {
        this.builder.setWebImage((WebImage)parser.readValueAs(WebImage.class));
    }

    public void readExpiry(JsonParser parser) throws IOException {
        this.builder.setExpiry((PushExpiry)parser.readValueAs(PushExpiry.class));
    }

    public void readButtons(JsonParser parser) throws IOException {
        List buttons = (List)parser.readValueAs((TypeReference)new TypeReference<List<Button>>(){});
        this.builder.addAllButtons(buttons);
    }

    public void readTemplate(JsonParser parser) throws IOException {
        this.builder.setTemplate((WebTemplate)parser.readValueAs(WebTemplate.class));
    }

    @Override
    public WebDevicePayload validateAndBuild() throws IOException {
        try {
            return this.builder.build();
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage(), e);
        }
    }
}

