/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.parse.notification.ios;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.urbanairship.api.push.model.notification.ios.IOSLiveActivity;
import java.io.IOException;

public class IOSLiveActivitySerializer
extends JsonSerializer<IOSLiveActivity> {
    public void serialize(IOSLiveActivity content, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        jgen.writeStartObject();
        jgen.writeStringField("event", content.getIosLiveActivityEvent().getIosLiveActivityEvent());
        jgen.writeStringField("name", content.getName());
        if (content.getIosLiveActivityAlert().isPresent()) {
            jgen.writeObjectField("alert", content.getIosLiveActivityAlert());
        }
        if (!content.getContentState().get().isEmpty()) {
            jgen.writeObjectField("content_state", content.getContentState());
        }
        if (content.getDismissalDate().isPresent()) {
            jgen.writeNumberField("dismissal_date", content.getDismissalDate().get().intValue());
        }
        if (content.getPriority().isPresent()) {
            jgen.writeNumberField("priority", content.getPriority().get().intValue());
        }
        if (content.getRelevanceScore().isPresent()) {
            jgen.writeNumberField("relevance_score", content.getRelevanceScore().get().doubleValue());
        }
        if (content.getStaleDate().isPresent()) {
            jgen.writeNumberField("stale_date", content.getStaleDate().get().intValue());
        }
        if (content.getTimestamp().isPresent()) {
            jgen.writeNumberField("timestamp", content.getTimestamp().get().intValue());
        }
        if (content.getAttributesType().isPresent()) {
            jgen.writeStringField("attributes_type", content.getAttributesType().get());
        }
        if (!content.getAttributes().get().isEmpty()) {
            jgen.writeObjectField("attributes", content.getAttributes());
        }
        jgen.writeEndObject();
    }
}

