/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.wns;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.notification.wns.WNSAudioData;
import com.urbanairship.api.push.model.notification.wns.WNSBinding;
import java.util.Optional;

public class WNSToastData {
    private final WNSBinding binding;
    private final Optional<Duration> duration;
    private final Optional<WNSAudioData> audio;

    private WNSToastData(WNSBinding binding, Optional<Duration> duration, Optional<WNSAudioData> audio) {
        this.binding = binding;
        this.duration = duration;
        this.audio = audio;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public WNSBinding getBinding() {
        return this.binding;
    }

    public Optional<Duration> getDuration() {
        return this.duration;
    }

    public Optional<WNSAudioData> getAudio() {
        return this.audio;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WNSToastData that = (WNSToastData)o;
        return (this.binding == null ? that.binding == null : this.binding.equals(that.binding)) && (this.duration == null ? that.duration == null : this.duration.equals(that.duration)) && (this.audio == null ? that.audio == null : this.audio.equals(that.audio));
    }

    public int hashCode() {
        int result = this.binding != null ? this.binding.hashCode() : 0;
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        result = 31 * result + (this.audio != null ? this.audio.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private WNSBinding binding;
        private Duration duration;
        private WNSAudioData audio;

        private Builder() {
        }

        public Builder setBinding(WNSBinding value) {
            this.binding = value;
            return this;
        }

        public Builder setDuration(Duration value) {
            this.duration = value;
            return this;
        }

        public Builder setAudio(WNSAudioData value) {
            this.audio = value;
            return this;
        }

        public WNSToastData build() {
            Preconditions.checkArgument((this.binding != null ? 1 : 0) != 0, (Object)"toast must have a value for 'binding'");
            return new WNSToastData(this.binding, Optional.ofNullable(this.duration), Optional.ofNullable(this.audio));
        }
    }

    public static enum Duration {
        LONG,
        SHORT;


        public String getIdentifier() {
            return this.name().toLowerCase();
        }

        public static Duration get(String value) {
            for (Duration d : Duration.values()) {
                if (!value.equalsIgnoreCase(d.name())) continue;
                return d;
            }
            return null;
        }
    }
}

