/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.ios;

import com.urbanairship.api.push.model.PushModelObject;
import java.util.Objects;
import java.util.Optional;

public final class IOSLiveActivityAlert
extends PushModelObject {
    private final Optional<String> title;
    private final Optional<String> body;
    private final Optional<String> sound;

    private IOSLiveActivityAlert(Optional<String> title, Optional<String> body, Optional<String> sound) {
        this.title = title;
        this.body = body;
        this.sound = sound;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getTitle() {
        return this.title;
    }

    public Optional<String> getBody() {
        return this.body;
    }

    public Optional<String> getSound() {
        return this.sound;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IOSLiveActivityAlert that = (IOSLiveActivityAlert)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.body, that.body) && Objects.equals(this.sound, that.sound);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.body, this.sound);
    }

    public String toString() {
        return "IOSLiveActivityAlert{title=" + this.title + ", body=" + this.body + ", sound=" + this.sound + '}';
    }

    public static class Builder {
        private String title = null;
        private String body = null;
        private String sound = null;

        private Builder() {
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBody(String body) {
            this.body = body;
            return this;
        }

        public Builder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public IOSLiveActivityAlert build() {
            return new IOSLiveActivityAlert(Optional.ofNullable(this.title), Optional.ofNullable(this.body), Optional.ofNullable(this.sound));
        }
    }
}

