/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.push.model.notification.Interactive;
import java.util.List;
import java.util.Optional;

public class Wearable {
    private final Optional<String> backgroundImage;
    private final Optional<Interactive> interactive;
    private final Optional<ImmutableList<ImmutableMap<String, String>>> extraPages;

    public static Builder newBuilder() {
        return new Builder();
    }

    private Wearable(Builder builder) {
        this.backgroundImage = Optional.ofNullable(builder.backgroundImage);
        this.interactive = Optional.ofNullable(builder.interactive);
        this.extraPages = !builder.extraPages.build().isEmpty() ? Optional.of(builder.extraPages.build()) : Optional.empty();
    }

    public Optional<String> getBackgroundImage() {
        return this.backgroundImage;
    }

    public Optional<Interactive> getInteractive() {
        return this.interactive;
    }

    public Optional<ImmutableList<ImmutableMap<String, String>>> getExtraPages() {
        return this.extraPages;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Wearable that = (Wearable)obj;
        if (this.backgroundImage != null ? !this.backgroundImage.equals(that.backgroundImage) : that.backgroundImage != null) {
            return false;
        }
        if (this.interactive != null ? !this.interactive.equals(that.interactive) : that.interactive != null) {
            return false;
        }
        return !(this.extraPages != null ? !this.extraPages.equals(that.extraPages) : that.extraPages != null);
    }

    public int hashCode() {
        int result = this.backgroundImage != null ? this.backgroundImage.hashCode() : 0;
        result = 31 * result + (this.interactive != null ? this.interactive.hashCode() : 0);
        result = 31 * result + (this.extraPages != null ? this.extraPages.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Wearable{backgroundImage=" + this.backgroundImage + ", interactive=" + this.interactive + ", extraPages=" + this.extraPages + '}';
    }

    public static class Builder {
        private String backgroundImage = null;
        private Interactive interactive = null;
        private ImmutableList.Builder<ImmutableMap<String, String>> extraPages = ImmutableList.builder();
        private static final String TITLE = "title";
        private static final String ALERT = "alert";

        public Builder setBackgroundImage(String value) {
            this.backgroundImage = value;
            return this;
        }

        public Builder setInteractive(Interactive value) {
            this.interactive = value;
            return this;
        }

        public Builder addExtraPage(String title, String alert) {
            ImmutableMap page = ImmutableMap.builder().put((Object)TITLE, (Object)title).put((Object)ALERT, (Object)alert).build();
            this.extraPages.add((Object)page);
            return this;
        }

        public Builder addAllExtraPages(List<ImmutableMap<String, String>> extraPages) {
            this.extraPages.addAll(extraPages);
            return this;
        }

        public Wearable build() {
            Preconditions.checkArgument((this.backgroundImage != null || this.interactive != null || !this.extraPages.build().isEmpty() ? 1 : 0) != 0, (Object)"At least one of backgroundImage, interactive, or extraPages must not be null/empty.");
            return new Wearable(this);
        }
    }
}

