/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.android;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.android.AndroidFields;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class AndroidTemplate
extends PushModelObject {
    private final Optional<String> templateId;
    private final Optional<AndroidFields> androidFields;

    private AndroidTemplate(Builder builder) {
        this.templateId = Optional.ofNullable(builder.templateId);
        this.androidFields = Optional.ofNullable(builder.androidFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="template_id")
    public Optional<String> getTemplateId() {
        return this.templateId;
    }

    @JsonProperty(value="fields")
    public Optional<AndroidFields> getAndroidFields() {
        return this.androidFields;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidTemplate template = (AndroidTemplate)o;
        return Objects.equal(this.templateId, template.templateId) && Objects.equal(this.androidFields, template.androidFields);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.templateId, this.androidFields});
    }

    public String toString() {
        return "AndroidTemplate{templateId=" + this.templateId + ", androidFields=" + this.androidFields + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        String templateId = null;
        AndroidFields androidFields = null;

        @JsonProperty(value="template_id")
        public Builder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public Builder setFields(AndroidFields androidFields) {
            this.androidFields = androidFields;
            return this;
        }

        public AndroidTemplate build() {
            Preconditions.checkArgument((this.templateId == null || this.androidFields == null ? 1 : 0) != 0, (Object)"templateId and android fields cannot both be set.");
            return new AndroidTemplate(this);
        }
    }
}

