/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.adm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.google.common.base.Objects;
import com.urbanairship.api.push.model.PushModelObject;
import java.util.Optional;

@JsonDeserialize(builder=Builder.class)
public class ADMFields
extends PushModelObject {
    private final Optional<String> alert;
    private final Optional<String> icon;
    private final Optional<String> iconColor;
    private final Optional<String> summary;
    private final Optional<String> title;

    private ADMFields(Builder builder) {
        this.alert = Optional.ofNullable(builder.alert);
        this.icon = Optional.ofNullable(builder.icon);
        this.iconColor = Optional.ofNullable(builder.iconColor);
        this.summary = Optional.ofNullable(builder.summary);
        this.title = Optional.ofNullable(builder.title);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @JsonProperty(value="alert")
    public Optional<String> getAlert() {
        return this.alert;
    }

    @JsonProperty(value="icon")
    public Optional<String> getIcon() {
        return this.icon;
    }

    @JsonProperty(value="icon_color")
    public Optional<String> getIconColor() {
        return this.iconColor;
    }

    @JsonProperty(value="summary")
    public Optional<String> getSummary() {
        return this.summary;
    }

    @JsonProperty(value="title")
    public Optional<String> getTitle() {
        return this.title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ADMFields that = (ADMFields)o;
        return Objects.equal(this.alert, that.alert) && Objects.equal(this.icon, that.icon) && Objects.equal(this.iconColor, that.iconColor) && Objects.equal(this.summary, that.summary) && Objects.equal(this.title, that.title);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alert, this.icon, this.iconColor, this.summary, this.title});
    }

    public String toString() {
        return "AndroidFields{alert=" + this.alert + ", icon=" + this.icon + ", iconColor=" + this.iconColor + ", summary=" + this.summary + ", title=" + this.title + '}';
    }

    @JsonPOJOBuilder(withPrefix="set")
    public static class Builder {
        private String alert = null;
        private String icon = null;
        private String iconColor = null;
        private String summary = null;
        private String title = null;

        public Builder setAlert(String alert) {
            this.alert = alert;
            return this;
        }

        public Builder setIcon(String icon) {
            this.icon = icon;
            return this;
        }

        @JsonProperty(value="icon_color")
        public Builder setIconColor(String iconColor) {
            this.iconColor = iconColor;
            return this;
        }

        public Builder setSummary(String summary) {
            this.summary = summary;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public ADMFields build() {
            return new ADMFields(this);
        }
    }
}

