/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.notification.actions;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.Lists;
import com.google.common.collect.MutableClassToInstanceMap;
import com.google.common.collect.Sets;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.actions.Action;
import com.urbanairship.api.push.model.notification.actions.ActionNameRegistry;
import com.urbanairship.api.push.model.notification.actions.AddTagAction;
import com.urbanairship.api.push.model.notification.actions.AppDefinedAction;
import com.urbanairship.api.push.model.notification.actions.RemoveTagAction;
import com.urbanairship.api.push.model.notification.actions.ShareAction;
import com.urbanairship.api.push.model.notification.actions.TagActionData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;

public class Actions
extends PushModelObject {
    private final ClassToInstanceMap<Action> actions;

    private Actions(ClassToInstanceMap<Action> actions) {
        this.actions = ImmutableClassToInstanceMap.copyOf(actions);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return Actions.newBuilder().mergeFrom(this);
    }

    public Optional<AppDefinedAction> getAppDefined() {
        return Optional.ofNullable(this.actions.getInstance(AppDefinedAction.class));
    }

    public Optional<AddTagAction> getAddTags() {
        return Optional.ofNullable(this.actions.getInstance(AddTagAction.class));
    }

    public Optional<RemoveTagAction> getRemoveTags() {
        return Optional.ofNullable(this.actions.getInstance(RemoveTagAction.class));
    }

    public Optional<Action.OpenAction> getOpenAction() {
        return Optional.ofNullable(this.actions.getInstance(Action.OpenAction.class));
    }

    public Iterable<? extends Action> allActions() {
        return this.actions.values();
    }

    public String toString() {
        return "Actions{actions=" + this.actions + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actions});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Actions other = (Actions)obj;
        return Objects.equal(this.actions, other.actions);
    }

    public static class Builder {
        private ClassToInstanceMap<Action> actions = MutableClassToInstanceMap.create();

        public Builder mergeFrom(Actions other) {
            this.actions.putAll((Map)other.actions);
            return this;
        }

        public Builder addTags(AddTagAction addTags) {
            this.actions.put(AddTagAction.class, (Object)addTags);
            return this;
        }

        public Builder removeTags(RemoveTagAction removeTags) {
            this.actions.put(RemoveTagAction.class, (Object)removeTags);
            return this;
        }

        public Builder setOpen(Action.OpenAction open) {
            this.actions.put(Action.OpenAction.class, (Object)open);
            return this;
        }

        public Builder addAppDefined(AppDefinedAction appDefined) {
            this.actions.put(AppDefinedAction.class, (Object)appDefined);
            return this;
        }

        public Builder setShare(ShareAction shareAction) {
            this.actions.put(ShareAction.class, (Object)shareAction);
            return this;
        }

        public Actions build() {
            Preconditions.checkArgument((this.actions.size() != 0 ? 1 : 0) != 0, (Object)"'actions' must contain at least one action.");
            for (Class action : this.actions.keySet()) {
                Preconditions.checkNotNull((Object)this.actions.getInstance(action), (Object)(action.getName() + " cannot have a null entry in actions."));
            }
            if (this.actions.containsKey(AddTagAction.class) && this.actions.containsKey(RemoveTagAction.class)) {
                TagActionData addTagData = ((AddTagAction)this.actions.getInstance(AddTagAction.class)).getValue();
                TagActionData removeTagData = ((RemoveTagAction)this.actions.getInstance(RemoveTagAction.class)).getValue();
                HashSet added = addTagData.isSingle() ? Sets.newHashSet((Object[])new String[]{addTagData.getSingleTag()}) : addTagData.getTagSet();
                HashSet removed = removeTagData.isSingle() ? Sets.newHashSet((Object[])new String[]{removeTagData.getSingleTag()}) : removeTagData.getTagSet();
                for (String addedTag : added) {
                    Preconditions.checkArgument((!removed.contains(addedTag) ? 1 : 0) != 0, (Object)("The same tag cannot be specified in the 'add_tag' and 'remove'tag' actions at the same time: " + addedTag));
                }
            }
            if (this.actions.containsKey(AppDefinedAction.class) && this.actions.size() > 1) {
                ArrayList fieldNames = Lists.newArrayList((Iterator)((AppDefinedAction)this.actions.getInstance(AppDefinedAction.class)).getValue().fieldNames());
                for (Class key : this.actions.keySet()) {
                    if (key == AppDefinedAction.class) continue;
                    Action a = (Action)this.actions.getInstance(key);
                    String actionFieldName = ActionNameRegistry.INSTANCE.getFieldName(a.getActionType());
                    Preconditions.checkArgument((!fieldNames.contains(actionFieldName) ? 1 : 0) != 0, (Object)("app_defined field '" + actionFieldName + "' collides with top level action."));
                    String actionShortName = ActionNameRegistry.INSTANCE.getShortName(a.getActionType());
                    Preconditions.checkArgument((!fieldNames.contains(actionShortName) ? 1 : 0) != 0, (Object)("app_defined field '" + actionShortName + "' collides with top level action's 'short name'."));
                }
            }
            return new Actions(this.actions);
        }
    }
}

