/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.push.model.audience.location;

import com.google.common.base.Preconditions;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.audience.location.DateRange;
import com.urbanairship.api.push.model.audience.location.DateRangeUnit;
import com.urbanairship.api.push.model.audience.location.PresenceTimeframe;
import org.joda.time.DateTime;

public class AbsoluteDateRange
extends PushModelObject
implements DateRange {
    private final DateTime start;
    private final DateTime end;
    private final DateRangeUnit resolution;
    private final PresenceTimeframe timeframe;

    private AbsoluteDateRange(DateTime start, DateTime end, DateRangeUnit resolution, PresenceTimeframe timeframe) {
        this.start = start;
        this.end = end;
        this.resolution = resolution;
        this.timeframe = timeframe;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public DateTime getStart() {
        return this.start;
    }

    @Override
    public DateTime getEnd() {
        return this.end;
    }

    @Override
    public DateRangeUnit getResolution() {
        return this.resolution;
    }

    @Override
    public PresenceTimeframe getTimeframe() {
        return this.timeframe;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbsoluteDateRange that = (AbsoluteDateRange)o;
        if (this.start != null ? !this.start.equals((Object)that.start) : that.start != null) {
            return false;
        }
        if (this.end != null ? !this.end.equals((Object)that.end) : that.end != null) {
            return false;
        }
        if (this.resolution != null ? !this.resolution.equals((Object)that.resolution) : that.resolution != null) {
            return false;
        }
        return !(this.timeframe != null ? !this.timeframe.equals((Object)that.timeframe) : that.timeframe != null);
    }

    public int hashCode() {
        int result = this.start != null ? this.start.hashCode() : 0;
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.resolution != null ? this.resolution.hashCode() : 0);
        result = 31 * result + (this.timeframe != null ? this.timeframe.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AbsoluteDateRange{start='" + this.start + '\'' + ", end='" + this.end + '\'' + ", resolution='" + (Object)((Object)this.resolution) + '\'' + ", timeframe='" + (Object)((Object)this.timeframe) + '\'' + '}';
    }

    public static class Builder {
        private DateTime start;
        private DateTime end;
        private DateRangeUnit resolution;
        private PresenceTimeframe timeframe;

        private Builder() {
        }

        public Builder setStart(DateTime value) {
            this.start = value;
            return this;
        }

        public Builder setEnd(DateTime value) {
            this.end = value;
            return this;
        }

        public Builder setResolution(DateRangeUnit value) {
            this.resolution = value;
            return this;
        }

        public Builder setTimeframe(PresenceTimeframe value) {
            this.timeframe = value;
            return this;
        }

        public AbsoluteDateRange build() {
            Preconditions.checkNotNull((Object)this.start, (Object)"Missing value for 'start'");
            Preconditions.checkNotNull((Object)this.end, (Object)"Missing value for 'end'");
            Preconditions.checkNotNull((Object)this.end, (Object)"Missing date range resolution");
            return new AbsoluteDateRange(this.start, this.end, this.resolution, this.timeframe);
        }
    }
}

