/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.urbanairship.api.channel.model.ChannelView;
import java.util.Map;

public class NamedUserView {
    private final String namedUserId;
    private final ImmutableMap<String, ImmutableSet<String>> namedUserTags;
    private final ImmutableSet<ChannelView> channelViews;
    private final ImmutableMap<String, String> attributes;
    private final ImmutableMap<String, String> userAttributes;

    public static Builder newBuilder() {
        return new Builder();
    }

    private NamedUserView(String namedUserId, ImmutableMap<String, ImmutableSet<String>> namedUserTags, ImmutableSet<ChannelView> channelViews, ImmutableMap<String, String> attributes, ImmutableMap<String, String> userAttributes) {
        this.namedUserId = namedUserId;
        this.namedUserTags = namedUserTags;
        this.channelViews = channelViews;
        this.attributes = attributes;
        this.userAttributes = userAttributes;
    }

    public String getNamedUserId() {
        return this.namedUserId;
    }

    public ImmutableMap<String, ImmutableSet<String>> getNamedUserTags() {
        return this.namedUserTags;
    }

    public ImmutableSet<ChannelView> getChannelViews() {
        return this.channelViews;
    }

    public ImmutableMap<String, String> getAttributes() {
        return this.attributes;
    }

    public ImmutableMap<String, String> getUserAttributes() {
        return this.userAttributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedUserView that = (NamedUserView)o;
        return Objects.equal((Object)this.namedUserId, (Object)that.namedUserId) && Objects.equal(this.namedUserTags, that.namedUserTags) && Objects.equal(this.channelViews, that.channelViews) && Objects.equal(this.attributes, that.attributes) && Objects.equal(this.userAttributes, that.userAttributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.namedUserId, this.namedUserTags, this.channelViews, this.attributes, this.userAttributes});
    }

    public String toString() {
        return "NamedUserView{namedUserId='" + this.namedUserId + '\'' + ", namedUserTags=" + this.namedUserTags + ", channelViews=" + this.channelViews + ", attributes=" + this.attributes + ", userAttributes=" + this.userAttributes + '}';
    }

    public static final class Builder {
        private String namedUserId = null;
        private ImmutableMap<String, ImmutableSet<String>> namedUserTags = null;
        private ImmutableSet<ChannelView> channelViews = null;
        private ImmutableMap.Builder<String, String> attributes = ImmutableMap.builder();
        private ImmutableMap.Builder<String, String> userAttributes = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setNamedUserId(String namedUserId) {
            this.namedUserId = namedUserId;
            return this;
        }

        public Builder setNamedUserTags(ImmutableMap<String, ImmutableSet<String>> namedUserTags) {
            this.namedUserTags = namedUserTags;
            return this;
        }

        public Builder setChannelViews(ImmutableSet<ChannelView> channelViews) {
            this.channelViews = channelViews;
            return this;
        }

        public Builder addAllAttributes(Map<String, String> attributes) {
            for (String key : attributes.keySet()) {
                this.attributes.put((Object)key, (Object)String.valueOf(attributes.get(key)));
            }
            return this;
        }

        public Builder addAllUserAttributes(Map<String, String> userAttributes) {
            for (String key : userAttributes.keySet()) {
                this.userAttributes.put((Object)key, (Object)String.valueOf(userAttributes.get(key)));
            }
            return this;
        }

        public NamedUserView build() {
            ImmutableMap attributes = this.attributes.build();
            ImmutableMap userAttributes = this.userAttributes.build();
            return new NamedUserView(this.namedUserId, this.namedUserTags, this.channelViews, attributes, userAttributes);
        }
    }
}

