/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.common.model.ErrorDetails;
import java.util.Optional;

public class NamedUserUpdateResponse {
    private final boolean ok;
    private final Optional<String> error;
    private final Optional<ImmutableList<String>> attributeWarnings;
    private final Optional<ImmutableList<String>> tagWarnings;
    private final Optional<ErrorDetails> errorDetails;

    private NamedUserUpdateResponse(Builder builder) {
        this.ok = builder.ok;
        this.error = builder.error;
        this.attributeWarnings = builder.attributeWarnings;
        this.tagWarnings = builder.tagWarnings;
        this.errorDetails = builder.errorDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public boolean isOk() {
        return this.ok;
    }

    public Optional<String> getError() {
        return this.error;
    }

    public Optional<ImmutableList<String>> getAttributeWarnings() {
        return this.attributeWarnings;
    }

    public Optional<ImmutableList<String>> getTagWarnings() {
        return this.tagWarnings;
    }

    public Optional<ErrorDetails> getErrorDetails() {
        return this.errorDetails;
    }

    public String toString() {
        return "NamedUserUpdateResponse{ok=" + this.ok + ", error='" + this.error + '\'' + ", attributeWarnings=" + this.attributeWarnings + ", tagWarnings=" + this.tagWarnings + ", errorDetails=" + this.errorDetails + '}';
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.ok, this.error, this.attributeWarnings, this.tagWarnings, this.errorDetails});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NamedUserUpdateResponse other = (NamedUserUpdateResponse)obj;
        return Objects.equal((Object)this.ok, (Object)other.ok) && Objects.equal(this.error, other.error) && Objects.equal(this.attributeWarnings, other.attributeWarnings) && Objects.equal(this.tagWarnings, other.tagWarnings) && Objects.equal(this.errorDetails, other.errorDetails);
    }

    public static class Builder {
        boolean ok;
        Optional<String> error;
        Optional<ImmutableList<String>> attributeWarnings;
        Optional<ImmutableList<String>> tagWarnings;
        Optional<ErrorDetails> errorDetails;

        public Builder setOk(boolean ok) {
            this.ok = ok;
            return this;
        }

        public Builder setError(Optional<String> string) {
            this.error = string;
            return this;
        }

        public Builder setAttributeWarnings(Optional<ImmutableList<String>> attributeWarnings) {
            this.attributeWarnings = attributeWarnings;
            return this;
        }

        public Builder setTagWarnings(Optional<ImmutableList<String>> tagWarnings) {
            this.tagWarnings = tagWarnings;
            return this;
        }

        public Builder setErrorDetails(Optional<ErrorDetails> errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public NamedUserUpdateResponse build() {
            return new NamedUserUpdateResponse(this);
        }
    }
}

