/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.nameduser.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.urbanairship.api.channel.model.attributes.Attribute;
import com.urbanairship.api.nameduser.model.NamedUserModelObject;

public class NamedUserAttributePayload
extends NamedUserModelObject {
    private final ImmutableList<Attribute> attributes;

    private NamedUserAttributePayload(ImmutableList<Attribute> attributes) {
        this.attributes = attributes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public ImmutableList<Attribute> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedUserAttributePayload that = (NamedUserAttributePayload)o;
        return Objects.equal(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes});
    }

    public String toString() {
        return "NamedUserAttributePayload{attributes=" + this.attributes + '}';
    }

    public static class Builder {
        ImmutableList.Builder<Attribute> attributeBuilder = ImmutableList.builder();

        public Builder addAttribute(Attribute attribute) {
            this.attributeBuilder.add((Object)attribute);
            return this;
        }

        public NamedUserAttributePayload build() {
            ImmutableList attributes = this.attributeBuilder.build();
            Preconditions.checkArgument((attributes.size() > 0 ? 1 : 0) != 0, (Object)"At least one attribute must be set.");
            return new NamedUserAttributePayload(attributes);
        }
    }
}

