/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.experiments.model;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.urbanairship.api.experiments.model.VariantPushPayload;
import com.urbanairship.api.schedule.model.Schedule;
import java.util.Optional;

public class Variant {
    private Optional<String> name;
    private Optional<String> description;
    private Optional<Schedule> schedule;
    private final VariantPushPayload variantPushPayload;
    private Optional<Integer> weight;

    private Variant(Builder builder) {
        this.name = Optional.ofNullable(builder.name);
        this.description = Optional.ofNullable(builder.description);
        this.schedule = Optional.ofNullable(builder.schedule);
        this.variantPushPayload = builder.variantPushPayload;
        this.weight = Optional.ofNullable(builder.weight);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<String> getDescription() {
        return this.description;
    }

    public Optional<Schedule> getSchedule() {
        return this.schedule;
    }

    public VariantPushPayload getVariantPushPayload() {
        return this.variantPushPayload;
    }

    public Optional<Integer> getWeight() {
        return this.weight;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.schedule, this.variantPushPayload, this.weight});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Variant other = (Variant)obj;
        return Objects.equal(this.name, other.name) && Objects.equal(this.description, other.description) && Objects.equal(this.schedule, other.schedule) && Objects.equal((Object)this.variantPushPayload, (Object)other.variantPushPayload) && Objects.equal(this.weight, other.weight);
    }

    public String toString() {
        return "Variant{name=" + this.name + ", description=" + this.description + ", schedule=" + this.schedule + ", variantPushPayload=" + this.variantPushPayload + ", weight=" + this.weight + '}';
    }

    public static class Builder {
        private String name;
        private String description;
        private Schedule schedule;
        private VariantPushPayload variantPushPayload;
        private Integer weight;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setSchedule(Schedule schedule) {
            this.schedule = schedule;
            return this;
        }

        public Builder setPushPayload(VariantPushPayload variantPushPayload) {
            this.variantPushPayload = variantPushPayload;
            return this;
        }

        public Builder setWeight(Integer weight) {
            this.weight = weight;
            return this;
        }

        public Variant build() {
            Preconditions.checkNotNull((Object)this.variantPushPayload, (Object)"'variant_push_payload' must be provided.");
            return new Variant(this);
        }
    }
}

