/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.createandsend.model.notification;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.urbanairship.api.createandsend.model.audience.CreateAndSendAudience;
import com.urbanairship.api.push.model.Campaigns;
import com.urbanairship.api.push.model.PushModelObject;
import com.urbanairship.api.push.model.notification.Notification;
import java.util.Objects;
import java.util.Optional;

public class CreateAndSendPayload
extends PushModelObject {
    private final CreateAndSendAudience audience;
    private final Notification notification;
    private final Optional<Campaigns> campaigns;
    private final Optional<ImmutableMap<String, Object>> globalAttributes;

    private CreateAndSendPayload(CreateAndSendAudience audience, Notification notification, Optional<Campaigns> campaigns, Optional<ImmutableMap<String, Object>> globalAttributes) {
        this.audience = audience;
        this.notification = notification;
        this.campaigns = campaigns;
        this.globalAttributes = globalAttributes;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public CreateAndSendAudience getAudience() {
        return this.audience;
    }

    public Notification getNotification() {
        return this.notification;
    }

    public Optional<Campaigns> getCampaigns() {
        return this.campaigns;
    }

    public Optional<ImmutableMap<String, Object>> getGlobalAttributes() {
        return this.globalAttributes;
    }

    public String toString() {
        return "CreateAndSendPayload{audience=" + this.audience + ", notification=" + this.notification + ", campaigns=" + this.campaigns + ", globalAttributes=" + this.globalAttributes + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateAndSendPayload)) {
            return false;
        }
        CreateAndSendPayload that = (CreateAndSendPayload)o;
        return Objects.equals(this.getAudience(), that.getAudience()) && Objects.equals(this.getNotification(), that.getNotification()) && Objects.equals(this.getCampaigns(), that.getCampaigns()) && Objects.equals(this.getGlobalAttributes(), that.getGlobalAttributes());
    }

    public int hashCode() {
        return Objects.hash(this.getAudience(), this.getNotification(), this.getCampaigns(), this.getGlobalAttributes());
    }

    public static class Builder {
        private CreateAndSendAudience audience;
        private Notification notification;
        private Campaigns campaigns;
        private ImmutableMap.Builder<String, Object> globalAttributesBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setAudience(CreateAndSendAudience audience) {
            this.audience = audience;
            return this;
        }

        public Builder setNotification(Notification notification) {
            this.notification = notification;
            return this;
        }

        public Builder setCampaigns(Campaigns campaigns) {
            this.campaigns = campaigns;
            return this;
        }

        public Builder addGlobalAttributes(String k, Object o) {
            this.globalAttributesBuilder.put((Object)k, o);
            return this;
        }

        public CreateAndSendPayload build() {
            ImmutableMap globalAttributes = this.globalAttributesBuilder.build();
            Preconditions.checkNotNull((Object)this.notification, (Object)"Notification must be set.");
            Preconditions.checkNotNull((Object)this.audience, (Object)"Audience must be set.");
            return new CreateAndSendPayload(this.audience, this.notification, Optional.ofNullable(this.campaigns), Optional.ofNullable(globalAttributes));
        }
    }
}

