/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import com.urbanairship.api.client.AsyncRequestClient;
import com.urbanairship.api.client.OAuthCredentials;
import com.urbanairship.api.client.OAuthTokenFetcher;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestClient;
import com.urbanairship.api.client.Response;
import com.urbanairship.api.client.ResponseCallback;
import com.urbanairship.api.client.parse.OAuthTokenResponse;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrbanAirshipClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(UrbanAirshipClient.class);
    private final RequestClient client;
    private final Optional<String> baseUri;
    private final Optional<Boolean> useEuropeanSite;
    private final String key;
    private final Optional<String> secret;
    private final Optional<String> bearerToken;
    private final Optional<OAuthCredentials> oAuthCredentials;
    private final String userAgent;
    public static final String US_URI = "https://api.asnapius.com";
    public static final String EU_URI = "https://api.asnapieu.com";
    public static final String EU_OAUTH_URI = "https://oauth2.asnapieu.com";
    public static final String US_OAUTH_URI = "https://oauth2.asnapius.com";
    public final String oAuthBaseUri;
    private OAuthTokenResponse oAuthTokenResponse;

    private UrbanAirshipClient(Builder builder) {
        this.client = builder.client;
        this.key = builder.key;
        this.useEuropeanSite = builder.useEuropeanSite;
        this.secret = Optional.ofNullable(builder.secret);
        this.bearerToken = Optional.ofNullable(builder.bearerToken);
        this.oAuthCredentials = Optional.ofNullable(builder.oAuthCredentials);
        this.baseUri = builder.baseUri;
        this.oAuthBaseUri = builder.oAuthBaseUri;
        this.userAgent = this.getUserAgent(builder.key);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public <T> Future<Response> executeAsync(Request<T> request, ResponseCallback callback) {
        return this.client.executeAsync(request, callback, this.createHeaders(request));
    }

    public <T> Future<Response> executeAsync(Request<T> request) {
        return this.executeAsync(request, null);
    }

    public <T> Response execute(Request<T> request) throws IOException {
        return this.execute(request, null);
    }

    public <T> Response execute(Request<T> request, ResponseCallback callback) throws IOException {
        try {
            return this.executeAsync(request, callback).get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while retrieving response from future", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Failed to retrieve response from future", e);
        }
    }

    private Map<String, String> createHeaders(Request request) {
        String auth;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("User-Agent", this.userAgent);
        Map<String, String> requestHeaders = request.getRequestHeaders();
        if (requestHeaders != null) {
            headers.putAll(requestHeaders);
        }
        if (request.bearerTokenAuthRequired()) {
            Preconditions.checkArgument((boolean)this.bearerToken.isPresent(), (Object)("Bearer token required for request: " + request));
            auth = "Bearer " + this.bearerToken.get();
        } else if (this.getAppSecret().isPresent()) {
            auth = "Basic " + BaseEncoding.base64().encode((this.getAppKey() + ":" + this.getAppSecret().get()).getBytes());
        } else if (this.bearerToken.isPresent() && request.canUseBearerTokenAuth()) {
            auth = "Bearer " + this.bearerToken.get();
        } else if (this.getOAuthCredentials().isPresent()) {
            this.ensureValidToken(this.oAuthBaseUri);
            auth = "Bearer " + this.oAuthTokenResponse.getAccessToken();
        } else {
            throw new IllegalArgumentException("No valid authentication method found for this request: " + request);
        }
        headers.put("Authorization", auth);
        headers.put("X-UA-Appkey", this.getAppKey());
        return headers;
    }

    @VisibleForTesting
    public String getUserAgent(String appKey) {
        String userAgent = "UNKNOWN";
        InputStream stream = this.getClass().getResourceAsStream("/client.properties");
        if (stream != null) {
            Properties props = new Properties();
            try {
                props.load(stream);
                stream.close();
                userAgent = "UAJavaLib/" + props.get("client.version") + " " + appKey;
            }
            catch (IOException e) {
                log.error("Failed to retrieve client user agent due to IOException - setting to \"UNKNOWN\"", (Throwable)e);
            }
        }
        return userAgent;
    }

    @Override
    public void close() throws IOException {
        log.info("Closing client");
        this.client.close();
    }

    public Optional<String> getBaseUri() {
        return this.baseUri;
    }

    public Optional<Boolean> getUseEuropeanSite() {
        return this.useEuropeanSite;
    }

    public String getAppKey() {
        return this.key;
    }

    public Optional<String> getAppSecret() {
        return this.secret;
    }

    public Optional<String> getBearerToken() {
        return this.bearerToken;
    }

    public Optional<OAuthCredentials> getOAuthCredentials() {
        return this.oAuthCredentials;
    }

    public RequestClient getRequestClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureValidToken(String oAuthBaseUri) {
        if (this.oAuthCredentials.isPresent()) {
            Optional<OAuthCredentials> optional = this.oAuthCredentials;
            synchronized (optional) {
                OAuthCredentials credentials = this.oAuthCredentials.get();
                if (this.oAuthTokenResponse == null || this.oAuthTokenResponse.isTokenExpired()) {
                    try {
                        OAuthTokenFetcher tokenFetcher = new OAuthTokenFetcher();
                        this.oAuthTokenResponse = tokenFetcher.fetchToken(credentials, oAuthBaseUri);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to fetch OAuth access token", e);
                    }
                }
            }
        }
    }

    public static class Builder {
        private String key;
        private String secret;
        private String bearerToken;
        private OAuthCredentials oAuthCredentials;
        private Optional<String> baseUri = Optional.empty();
        private Optional<Boolean> useEuropeanSite = Optional.empty();
        private String oAuthBaseUri;
        private RequestClient client;

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        public Builder setUseEuropeanSite(boolean useEuropeanSite) {
            this.useEuropeanSite = Optional.of(useEuropeanSite);
            return this;
        }

        public Builder setSecret(String appSecret) {
            this.secret = appSecret;
            return this;
        }

        public Builder setBaseUri(String baseUri) {
            this.baseUri = Optional.of(baseUri);
            return this;
        }

        public Builder setBearerToken(String bearerToken) {
            this.bearerToken = bearerToken;
            return this;
        }

        public Builder setOAuthCredentials(OAuthCredentials oAuthCredentials) {
            this.oAuthCredentials = oAuthCredentials;
            return this;
        }

        public Builder setOAuthBaseUri(String oAuthBaseUri) {
            this.oAuthBaseUri = oAuthBaseUri;
            return this;
        }

        public Builder setClient(RequestClient client) {
            this.client = client;
            return this;
        }

        public UrbanAirshipClient build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"App key is required to build UrbanAirshipClient");
            if (this.secret == null && this.bearerToken == null && this.oAuthCredentials == null) {
                throw new NullPointerException("Secret, bearer token, or OAuth credentials must be set");
            }
            if (!this.baseUri.isPresent()) {
                this.baseUri = Optional.of(this.useEuropeanSite.orElse(false) != false ? UrbanAirshipClient.EU_URI : UrbanAirshipClient.US_URI);
            }
            if (this.client == null) {
                this.client = AsyncRequestClient.newBuilder().setBaseUri(this.baseUri.get()).build();
            }
            if (this.oAuthCredentials != null && this.oAuthBaseUri == null) {
                this.oAuthBaseUri = this.baseUri.get().equals(UrbanAirshipClient.EU_URI) ? UrbanAirshipClient.EU_OAUTH_URI : UrbanAirshipClient.US_OAUTH_URI;
            }
            return new UrbanAirshipClient(this);
        }
    }
}

