/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.urbanairship.api.client.OAuthCredentials;
import com.urbanairship.api.client.parse.OAuthTokenResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class OAuthTokenFetcher {
    private final HttpClient httpClient = HttpClients.createDefault();
    private final ObjectMapper objectMapper = new ObjectMapper();

    public OAuthTokenResponse fetchToken(OAuthCredentials credentials, String baseOAuthURL) throws IOException {
        int maxRetries = 3;
        int retryCount = 0;
        boolean success = false;
        String accessToken = null;
        long expiresIn = 0L;
        while (!success && retryCount < maxRetries) {
            if (retryCount > 0) {
                try {
                    Thread.sleep(1000L * (long)Math.pow(2.0, retryCount));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Interrupted while waiting to retry token fetch", e);
                }
            }
            HttpPost post = new HttpPost(baseOAuthURL + "/token");
            post.setHeader("Content-Type", "application/x-www-form-urlencoded");
            post.setHeader("Accept", "application/json");
            if (credentials.getClientSecret().isPresent()) {
                String clientId = credentials.getClientId();
                String clientSecret = credentials.getClientSecret().get();
                String authHeader = BaseEncoding.base64().encode((clientId + ":" + clientSecret).getBytes());
                post.setHeader("Authorization", "Basic " + authHeader);
            }
            List<NameValuePair> params = credentials.toParams();
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, StandardCharsets.UTF_8));
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                String jsonResponse = EntityUtils.toString((HttpEntity)response.getEntity());
                Map responseMap = (Map)this.objectMapper.readValue(jsonResponse, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (responseMap.containsKey("access_token")) {
                    accessToken = (String)responseMap.get("access_token");
                    expiresIn = ((Integer)responseMap.get("expires_in")).intValue();
                    success = true;
                    continue;
                }
                throw new IOException("Failed to obtain access token: " + jsonResponse);
            }
            if (response.getStatusLine().getStatusCode() == 400 || response.getStatusLine().getStatusCode() == 401 || response.getStatusLine().getStatusCode() == 406) {
                throw new IOException("Failed to obtain access token with status code: " + response.getStatusLine().getStatusCode() + ". Response: " + EntityUtils.toString((HttpEntity)response.getEntity()));
            }
            ++retryCount;
        }
        if (!success) {
            throw new IOException("Failed to obtain access token after " + maxRetries + " attempts.");
        }
        return new OAuthTokenResponse(accessToken, expiresIn);
    }
}

