/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;

public class OAuthCredentials {
    private final String clientId;
    private final Optional<String> clientSecret;
    private final Optional<String> assertionJWT;
    private final String grantType = "client_credentials";
    private final List<String> ipAddresses;
    private final List<String> scopes;
    private final Optional<String> sub;

    private OAuthCredentials(Builder builder) {
        this.clientId = builder.clientId;
        this.clientSecret = builder.clientSecret;
        this.assertionJWT = builder.assertionJWT;
        this.ipAddresses = builder.ipAddresses;
        this.scopes = builder.scopes;
        this.sub = builder.sub;
    }

    public static Builder newBuilder(String clientId) {
        return new Builder(clientId);
    }

    public String getClientId() {
        return this.clientId;
    }

    public Optional<String> getClientSecret() {
        return this.clientSecret;
    }

    public Optional<String> getAssertionJWT() {
        return this.assertionJWT;
    }

    public String getGrantType() {
        return "client_credentials";
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public List<String> getScopes() {
        return this.scopes;
    }

    public Optional<String> getSub() {
        return this.sub;
    }

    public List<NameValuePair> toParams() {
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        params.add((NameValuePair)new BasicNameValuePair("grant_type", "client_credentials"));
        this.assertionJWT.ifPresent(a -> params.add((NameValuePair)new BasicNameValuePair("assertion", a)));
        this.ipAddresses.forEach(ipAddress -> params.add((NameValuePair)new BasicNameValuePair("ipaddr", ipAddress)));
        this.scopes.forEach(scope -> params.add((NameValuePair)new BasicNameValuePair("scope", scope)));
        this.sub.ifPresent(s -> params.add((NameValuePair)new BasicNameValuePair("sub", s)));
        return params;
    }

    public static class Builder {
        private final String clientId;
        private Optional<String> clientSecret = Optional.empty();
        private Optional<String> assertionJWT = Optional.empty();
        private List<String> ipAddresses = new ArrayList<String>();
        private List<String> scopes = new ArrayList<String>();
        private Optional<String> sub = Optional.empty();

        public Builder(String clientId) {
            this.clientId = clientId;
        }

        public Builder setClientSecret(String clientSecret) {
            this.clientSecret = Optional.ofNullable(clientSecret);
            return this;
        }

        public Builder setAssertionJWT(String assertionJWT) {
            this.assertionJWT = Optional.ofNullable(assertionJWT);
            return this;
        }

        public Builder setIpAddresses(List<String> ipAddresses) {
            this.ipAddresses = ipAddresses;
            return this;
        }

        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public Builder setSub(String sub) {
            this.sub = Optional.of(sub);
            return this;
        }

        public OAuthCredentials build() {
            if (this.clientId == null) {
                throw new IllegalStateException("clientId must not be null");
            }
            if (!this.clientSecret.isPresent() && !this.assertionJWT.isPresent()) {
                throw new IllegalStateException("Either clientSecret or assertionJWT must be provided");
            }
            if (this.assertionJWT.isPresent() && (this.clientSecret.isPresent() || this.sub.isPresent() || !this.scopes.isEmpty() || !this.ipAddresses.isEmpty())) {
                throw new IllegalStateException("assertionJWT should not be set with clientSecret, sub, scopes, or ipAddresses.");
            }
            if (this.clientSecret.isPresent() && !this.sub.isPresent()) {
                throw new IllegalStateException("sub is required when clientSecret is provided.");
            }
            return new OAuthCredentials(this);
        }
    }
}

