/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import com.urbanairship.api.common.model.GenericResponse;
import com.urbanairship.api.common.parse.APIParsingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class SuppressEmailChannelRequest
implements Request<GenericResponse> {
    private static final String API_EMAIL_CHANNEL_SUPPRESS = "/api/channels/email/suppress";
    private final Map<String, String> payload = new HashMap<String, String>();

    private SuppressEmailChannelRequest(String address, String reason) {
        Preconditions.checkNotNull((Object)address, (Object)"address must not be null to create a SuppressEmailChannel request");
        Preconditions.checkNotNull((Object)reason, (Object)"reason must not be null to create a SuppressEmailChannel request");
        this.payload.put("address", address);
        this.payload.put("reason", reason);
    }

    public static SuppressEmailChannelRequest newRequest(String address, String reason) {
        return new SuppressEmailChannelRequest(address, reason);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        try {
            return ChannelObjectMapper.getInstance().writeValueAsString(this.payload);
        }
        catch (Exception e) {
            throw new APIParsingException(e.getMessage());
        }
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, API_EMAIL_CHANNEL_SUPPRESS);
    }

    @Override
    public ResponseParser<GenericResponse> getResponseParser() {
        return response -> (GenericResponse)ChannelObjectMapper.getInstance().readValue(response, GenericResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

