/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel.model.email;

import com.google.common.base.Preconditions;
import com.urbanairship.api.channel.model.email.EmailChannelResponse;
import com.urbanairship.api.channel.model.email.RegisterEmailChannel;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class ReplaceEmailChannelRequest
implements Request<EmailChannelResponse> {
    private static final String API_REPLACE_EMAIL_CHANNEL = "/api/channels/email/replace/";
    private final String path;
    private final RegisterEmailChannel payload;

    private ReplaceEmailChannelRequest(String path, RegisterEmailChannel payload) {
        this.path = path;
        this.payload = payload;
    }

    public static ReplaceEmailChannelRequest newRequest(String channelId, RegisterEmailChannel payload) {
        Preconditions.checkNotNull((Object)payload, (Object)"Payload must not be null to create a ReplaceEmailChannel request");
        Preconditions.checkNotNull((Object)channelId, (Object)"ChannelId must not be null to create a ReplaceEmailChannel request");
        return new ReplaceEmailChannelRequest(API_REPLACE_EMAIL_CHANNEL + channelId, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) throws URISyntaxException {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<EmailChannelResponse> getResponseParser() {
        return response -> (EmailChannelResponse)ChannelObjectMapper.getInstance().readValue(response, EmailChannelResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

