/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.api.channel;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.urbanairship.api.channel.model.subscriptionlist.SubscriptionListPayload;
import com.urbanairship.api.channel.model.subscriptionlist.SubscriptionListResponse;
import com.urbanairship.api.channel.parse.ChannelObjectMapper;
import com.urbanairship.api.client.Request;
import com.urbanairship.api.client.RequestUtils;
import com.urbanairship.api.client.ResponseParser;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;

public class SubscriptionListRequest
implements Request<SubscriptionListResponse> {
    private final ObjectMapper MAPPER = ChannelObjectMapper.getInstance();
    private static final String API_CHANNELS_SUBSCRIPTION_LIST = "/api/channels/subscription_lists/";
    private final String path;
    private final SubscriptionListPayload payload;

    private SubscriptionListRequest(String path, SubscriptionListPayload payload) {
        this.path = path;
        this.payload = payload;
    }

    public static SubscriptionListRequest newRequest(SubscriptionListPayload payload) {
        return new SubscriptionListRequest(API_CHANNELS_SUBSCRIPTION_LIST, payload);
    }

    @Override
    public Request.HttpMethod getHttpMethod() {
        return Request.HttpMethod.POST;
    }

    @Override
    public String getRequestBody() {
        return this.payload.toJSON();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Map<String, String> getRequestHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Accept", "application/vnd.urbanairship+json; version=3");
        return headers;
    }

    @Override
    public URI getUri(URI baseUri) {
        return RequestUtils.resolveURI(baseUri, this.path);
    }

    @Override
    public ResponseParser<SubscriptionListResponse> getResponseParser() {
        return response -> (SubscriptionListResponse)this.MAPPER.readValue(response, SubscriptionListResponse.class);
    }

    @Override
    public boolean bearerTokenAuthRequired() {
        return false;
    }

    @Override
    public boolean canUseBearerTokenAuth() {
        return true;
    }
}

