/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.controls;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.asn1.ASN1Sequence;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.controls.ControlMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PostReadRequestControl
extends Control {
    @NotNull
    public static final String POST_READ_REQUEST_OID = "1.3.6.1.1.13.2";
    @NotNull
    private static final String[] NO_ATTRIBUTES = StaticUtils.NO_STRINGS;
    private static final long serialVersionUID = -4210061989410209462L;
    @NotNull
    private final String[] attributes;

    public PostReadRequestControl(String ... attributes) {
        this(true, attributes);
    }

    public PostReadRequestControl(boolean isCritical, String ... attributes) {
        super(POST_READ_REQUEST_OID, isCritical, PostReadRequestControl.encodeValue(attributes));
        this.attributes = attributes == null ? NO_ATTRIBUTES : attributes;
    }

    public PostReadRequestControl(@NotNull Control control) throws LDAPException {
        super(control);
        ASN1OctetString value = control.getValue();
        if (value == null) {
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_REQUEST_NO_VALUE.get());
        }
        try {
            ASN1Element valueElement = ASN1Element.decode(value.getValue());
            ASN1Element[] attrElements = ASN1Sequence.decodeAsSequence(valueElement).elements();
            this.attributes = new String[attrElements.length];
            for (int i = 0; i < attrElements.length; ++i) {
                this.attributes[i] = ASN1OctetString.decodeAsOctetString(attrElements[i]).stringValue();
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ControlMessages.ERR_POST_READ_REQUEST_CANNOT_DECODE.get(e), e);
        }
    }

    @NotNull
    private static ASN1OctetString encodeValue(@Nullable String[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return new ASN1OctetString(new ASN1Sequence().encode());
        }
        ASN1Element[] elements = new ASN1OctetString[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            elements[i] = new ASN1OctetString(attributes[i]);
        }
        return new ASN1OctetString(new ASN1Sequence(elements).encode());
    }

    @NotNull
    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public String getControlName() {
        return ControlMessages.INFO_CONTROL_NAME_POST_READ_REQUEST.get();
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append("PostReadRequestControl(attributes={");
        for (int i = 0; i < this.attributes.length; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append('\'');
            buffer.append(this.attributes[i]);
            buffer.append('\'');
        }
        buffer.append("}, isCritical=");
        buffer.append(this.isCritical());
        buffer.append(')');
    }
}

