/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.AndFilter;
import com.unboundid.scim2.common.filters.ComparisonFilter;
import com.unboundid.scim2.common.filters.ComplexValueFilter;
import com.unboundid.scim2.common.filters.ContainsFilter;
import com.unboundid.scim2.common.filters.EndsWithFilter;
import com.unboundid.scim2.common.filters.EqualFilter;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.filters.GreaterThanFilter;
import com.unboundid.scim2.common.filters.GreaterThanOrEqualFilter;
import com.unboundid.scim2.common.filters.LessThanFilter;
import com.unboundid.scim2.common.filters.LessThanOrEqualFilter;
import com.unboundid.scim2.common.filters.NotEqualFilter;
import com.unboundid.scim2.common.filters.NotFilter;
import com.unboundid.scim2.common.filters.OrFilter;
import com.unboundid.scim2.common.filters.PresentFilter;
import com.unboundid.scim2.common.filters.StartsWithFilter;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.SchemaChecker;
import java.util.ArrayList;
import java.util.Set;

public final class SchemaCheckFilterVisitor
implements FilterVisitor<Filter, Object> {
    @Nullable
    private final Path parentPath;
    @NotNull
    private final ResourceTypeDefinition resourceType;
    @NotNull
    private final SchemaChecker schemaChecker;
    @NotNull
    private final SchemaChecker.Results results;

    private SchemaCheckFilterVisitor(@Nullable Path parentPath, @NotNull ResourceTypeDefinition resourceType, @NotNull SchemaChecker schemaChecker, @NotNull SchemaChecker.Results results) {
        this.parentPath = parentPath;
        this.resourceType = resourceType;
        this.schemaChecker = schemaChecker;
        this.results = results;
    }

    static void checkFilter(@NotNull Filter filter, @NotNull ResourceTypeDefinition resourceTypeDefinition, @NotNull SchemaChecker schemaChecker, @NotNull Set<SchemaChecker.Option> enabledOptions, @NotNull SchemaChecker.Results results) throws ScimException {
        if (enabledOptions.contains((Object)SchemaChecker.Option.ALLOW_UNDEFINED_ATTRIBUTES) && enabledOptions.contains((Object)SchemaChecker.Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES)) {
            return;
        }
        SchemaCheckFilterVisitor visitor = new SchemaCheckFilterVisitor(null, resourceTypeDefinition, schemaChecker, results);
        filter.visit((FilterVisitor)visitor, null);
    }

    static void checkValueFilter(@Nullable Path parentPath, @NotNull Filter filter, @NotNull ResourceTypeDefinition resourceTypeDefinition, @NotNull SchemaChecker schemaChecker, @NotNull Set<SchemaChecker.Option> enabledOptions, @NotNull SchemaChecker.Results results) throws ScimException {
        if (enabledOptions.contains((Object)SchemaChecker.Option.ALLOW_UNDEFINED_SUB_ATTRIBUTES)) {
            return;
        }
        SchemaCheckFilterVisitor visitor = new SchemaCheckFilterVisitor(parentPath, resourceTypeDefinition, schemaChecker, results);
        filter.visit((FilterVisitor)visitor, null);
    }

    @NotNull
    public Filter visit(@NotNull EqualFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull NotEqualFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull ContainsFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull StartsWithFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull EndsWithFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull PresentFilter filter, @Nullable Object param) throws ScimException {
        this.checkAttributePath(filter.getAttributePath());
        return filter;
    }

    @NotNull
    public Filter visit(@NotNull GreaterThanFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull GreaterThanOrEqualFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull LessThanFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull LessThanOrEqualFilter filter, @Nullable Object param) throws ScimException {
        return this.visitComparisonFilter((ComparisonFilter)filter, param);
    }

    @NotNull
    public Filter visit(@NotNull AndFilter filter, @Nullable Object param) throws ScimException {
        for (Filter f : filter.getCombinedFilters()) {
            f.visit((FilterVisitor)this, param);
        }
        return filter;
    }

    @NotNull
    public Filter visit(@NotNull OrFilter filter, @Nullable Object param) throws ScimException {
        for (Filter f : filter.getCombinedFilters()) {
            f.visit((FilterVisitor)this, param);
        }
        return filter;
    }

    @NotNull
    public Filter visit(@NotNull NotFilter filter, @Nullable Object param) throws ScimException {
        filter.getInvertedFilter().visit((FilterVisitor)this, param);
        return filter;
    }

    @NotNull
    public Filter visit(@NotNull ComplexValueFilter filter, @Nullable Object param) throws ScimException {
        this.checkAttributePath(filter.getAttributePath());
        return filter;
    }

    @NotNull
    private Filter visitComparisonFilter(@NotNull ComparisonFilter filter, @Nullable Object param) {
        this.checkAttributePath(filter.getAttributePath());
        return filter;
    }

    private void checkAttributePath(@NotNull Path path) {
        if (this.parentPath != null) {
            AttributeDefinition parentAttr;
            Path fullPath = this.parentPath.attribute(path);
            AttributeDefinition attribute = this.resourceType.getAttributeDefinition(fullPath);
            if (path.getElement(0).getAttribute().equalsIgnoreCase("value") && (parentAttr = this.resourceType.getAttributeDefinition(this.parentPath)).isMultiValued() && parentAttr.getSubAttributes() == null) {
                return;
            }
            if (attribute == null) {
                this.results.addFilterIssue("Sub-attribute " + path.getElement(0) + " in value filter for path " + this.parentPath.toString() + " is undefined");
            }
        } else {
            AttributeDefinition attribute = this.resourceType.getAttributeDefinition(path);
            if (attribute == null) {
                ArrayList<String> messages = new ArrayList<String>();
                this.schemaChecker.addMessageForUndefinedAttr(path, "", messages);
                if (!messages.isEmpty()) {
                    for (String m : messages) {
                        this.results.addFilterIssue(m);
                    }
                }
            }
        }
    }
}

