/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.utils.StaticUtils;
import com.unboundid.scim2.server.utils.ResourceTypeDefinition;
import com.unboundid.scim2.server.utils.ScimResourceTrimmer;
import com.unboundid.scim2.server.utils.ServerUtils;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ResourcePreparer<T extends ScimResource> {
    @NotNull
    private final ResourceTypeDefinition resourceType;
    @NotNull
    private final URI baseUri;
    @NotNull
    private final Set<Path> queryAttributes;
    private final boolean excluded;

    public ResourcePreparer(@NotNull ResourceTypeDefinition resourceType, @NotNull UriInfo requestUriInfo) throws BadRequestException {
        this(resourceType, (String)requestUriInfo.getQueryParameters().getFirst((Object)"attributes"), (String)requestUriInfo.getQueryParameters().getFirst((Object)"excludedAttributes"), requestUriInfo.getBaseUriBuilder().path(resourceType.getEndpoint()).buildFromMap(ResourcePreparer.singleValuedMapFromMultivaluedMap((MultivaluedMap<String, String>)requestUriInfo.getPathParameters())));
    }

    @NotNull
    private static Map<String, String> singleValuedMapFromMultivaluedMap(@NotNull MultivaluedMap<String, String> multivaluedMap) {
        LinkedHashMap<String, String> returnMap = new LinkedHashMap<String, String>();
        for (String k : multivaluedMap.keySet()) {
            returnMap.put(k, (String)multivaluedMap.getFirst((Object)k));
        }
        return returnMap;
    }

    ResourcePreparer(@NotNull ResourceTypeDefinition resourceType, @NotNull String attributesString, @Nullable String excludedAttributesString, @NotNull URI baseUri) throws BadRequestException {
        if (attributesString != null && !attributesString.isEmpty()) {
            Set attributeSet = StaticUtils.arrayToSet((Object[])StaticUtils.splitCommaSeparatedString((String)attributesString));
            this.queryAttributes = new LinkedHashSet<Path>(attributeSet.size());
            for (String attribute : attributeSet) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the attributes parameter: " + e.getMessage()));
                }
                this.queryAttributes.add(normalizedPath);
            }
            this.excluded = false;
        } else if (excludedAttributesString != null && !excludedAttributesString.isEmpty()) {
            Set attributeSet = StaticUtils.arrayToSet((Object[])StaticUtils.splitCommaSeparatedString((String)excludedAttributesString));
            this.queryAttributes = new LinkedHashSet<Path>(attributeSet.size());
            for (String attribute : attributeSet) {
                Path normalizedPath;
                try {
                    normalizedPath = resourceType.normalizePath(Path.fromString((String)attribute)).withoutFilters();
                }
                catch (BadRequestException e) {
                    throw BadRequestException.invalidValue((String)("'" + attribute + "' is not a valid value for the excludedAttributes parameter: " + e.getMessage()));
                }
                this.queryAttributes.add(normalizedPath);
            }
            this.excluded = true;
        } else {
            this.queryAttributes = Collections.emptySet();
            this.excluded = true;
        }
        this.resourceType = resourceType;
        this.baseUri = baseUri;
    }

    @NotNull
    public GenericScimResource trimRetrievedResource(@NotNull T returnedResource) {
        return this.trimReturned(returnedResource, null, null);
    }

    @NotNull
    public GenericScimResource trimCreatedResource(@NotNull T returnedResource, @Nullable T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    @NotNull
    public GenericScimResource trimReplacedResource(@NotNull T returnedResource, @Nullable T requestResource) {
        return this.trimReturned(returnedResource, requestResource, null);
    }

    @NotNull
    public GenericScimResource trimModifiedResource(@NotNull T returnedResource, @Nullable Iterable<PatchOperation> patchOperations) {
        return this.trimReturned(returnedResource, null, patchOperations);
    }

    public void setResourceTypeAndLocation(@NotNull T returnedResource) {
        Meta meta = returnedResource.getMeta();
        boolean metaUpdated = false;
        if (meta == null) {
            meta = new Meta();
        }
        if (meta.getResourceType() == null) {
            meta.setResourceType(this.resourceType.getName());
            metaUpdated = true;
        }
        if (meta.getLocation() == null) {
            String id = returnedResource.getId();
            if (id != null) {
                UriBuilder locationBuilder = UriBuilder.fromUri((URI)this.baseUri);
                locationBuilder.segment(new String[]{ServerUtils.encodeTemplateNames(id)});
                meta.setLocation(locationBuilder.build(new Object[0]));
            } else {
                meta.setLocation(this.baseUri);
            }
            metaUpdated = true;
        }
        if (metaUpdated) {
            returnedResource.setMeta(meta);
        }
    }

    @NotNull
    private GenericScimResource trimReturned(@NotNull T returnedResource, @Nullable T requestResource, @Nullable Iterable<PatchOperation> patchOperations) {
        Set<Path> requestAttributes = Collections.emptySet();
        if (requestResource != null) {
            ObjectNode requestObject = requestResource.asGenericScimResource().getObjectNode();
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(Path.root(), requestAttributes, requestObject);
        }
        if (patchOperations != null) {
            requestAttributes = new LinkedHashSet();
            this.collectAttributes(requestAttributes, patchOperations);
        }
        this.setResourceTypeAndLocation(returnedResource);
        GenericScimResource genericReturnedResource = returnedResource.asGenericScimResource();
        ScimResourceTrimmer trimmer = new ScimResourceTrimmer(this.resourceType, requestAttributes, this.queryAttributes, this.excluded);
        GenericScimResource preparedResource = new GenericScimResource(trimmer.trimObjectNode(genericReturnedResource.getObjectNode()));
        return preparedResource;
    }

    private void collectAttributes(@NotNull Path parentPath, @NotNull Set<Path> paths, @NotNull ObjectNode objectNode) {
        Iterator i = objectNode.fields();
        while (i.hasNext()) {
            Map.Entry field = (Map.Entry)i.next();
            Path path = parentPath.attribute((String)field.getKey());
            if (path.size() > 1 || path.getSchemaUrn() == null) {
                paths.add(path);
            }
            if (((JsonNode)field.getValue()).isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)field.getValue());
                continue;
            }
            if (!((JsonNode)field.getValue()).isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)field.getValue());
        }
    }

    private void collectAttributes(@NotNull Path parentPath, @NotNull Set<Path> paths, @NotNull ArrayNode arrayNode) {
        for (JsonNode value : arrayNode) {
            if (value.isArray()) {
                this.collectAttributes(parentPath, paths, (ArrayNode)value);
                continue;
            }
            if (!value.isObject()) continue;
            this.collectAttributes(parentPath, paths, (ObjectNode)value);
        }
    }

    private void collectAttributes(@NotNull Set<Path> paths, @NotNull Iterable<PatchOperation> patchOperations) {
        for (PatchOperation patchOperation : patchOperations) {
            Path path = Path.root();
            if (patchOperation.getPath() != null) {
                path = this.resourceType.normalizePath(patchOperation.getPath()).withoutFilters();
                paths.add(path);
            }
            if (patchOperation.getJsonNode() == null) continue;
            if (patchOperation.getJsonNode().isArray()) {
                this.collectAttributes(path, paths, (ArrayNode)patchOperation.getJsonNode());
                continue;
            }
            if (!patchOperation.getJsonNode().isObject()) continue;
            this.collectAttributes(path, paths, (ObjectNode)patchOperation.getJsonNode());
        }
    }
}

