/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.server.utils;

import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.ResourceTypeResource;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.server.annotations.ResourceType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class ResourceTypeDefinition {
    private final String id;
    private final String name;
    private final String description;
    private final String endpoint;
    private final SchemaResource coreSchema;
    private final Map<SchemaResource, Boolean> schemaExtensions;
    private final Map<Path, AttributeDefinition> attributeNotationMap;
    private final boolean discoverable;

    private ResourceTypeDefinition(String id, String name, String description, String endpoint, SchemaResource coreSchema, Map<SchemaResource, Boolean> schemaExtensions, boolean discoverable) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.endpoint = endpoint;
        this.coreSchema = coreSchema;
        this.schemaExtensions = Collections.unmodifiableMap(schemaExtensions);
        this.discoverable = discoverable;
        this.attributeNotationMap = new HashMap<Path, AttributeDefinition>();
        this.buildAttributeNotationMap(Path.root(), SchemaUtils.COMMON_ATTRIBUTE_DEFINITIONS);
        if (coreSchema != null) {
            this.buildAttributeNotationMap(Path.root(), coreSchema.getAttributes());
        }
        for (SchemaResource schemaExtension : schemaExtensions.keySet()) {
            this.buildAttributeNotationMap(Path.root((String)schemaExtension.getId()), schemaExtension.getAttributes());
        }
    }

    private void buildAttributeNotationMap(Path parentPath, Collection<AttributeDefinition> attributes) {
        for (AttributeDefinition attribute : attributes) {
            Path path = parentPath.attribute(attribute.getName());
            this.attributeNotationMap.put(path, attribute);
            if (attribute.getSubAttributes() == null) continue;
            this.buildAttributeNotationMap(path, attribute.getSubAttributes());
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public SchemaResource getCoreSchema() {
        return this.coreSchema;
    }

    public Map<SchemaResource, Boolean> getSchemaExtensions() {
        return this.schemaExtensions;
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public AttributeDefinition getAttributeDefinition(Path path) {
        return this.attributeNotationMap.get(this.normalizePath(path).withoutFilters());
    }

    public Path normalizePath(Path path) {
        if (path.getSchemaUrn() != null && this.coreSchema != null && path.getSchemaUrn().equalsIgnoreCase(this.coreSchema.getId())) {
            return Path.root().attribute(path);
        }
        return path;
    }

    public ResourceTypeResource toScimResource() {
        try {
            URI coreSchemaUri = null;
            if (this.coreSchema != null) {
                coreSchemaUri = new URI(this.coreSchema.getId());
            }
            ArrayList<ResourceTypeResource.SchemaExtension> schemaExtensionList = null;
            if (this.schemaExtensions.size() > 0) {
                schemaExtensionList = new ArrayList<ResourceTypeResource.SchemaExtension>(this.schemaExtensions.size());
                for (Map.Entry<SchemaResource, Boolean> schemaExtension : this.schemaExtensions.entrySet()) {
                    schemaExtensionList.add(new ResourceTypeResource.SchemaExtension(URI.create(schemaExtension.getKey().getId()), schemaExtension.getValue().booleanValue()));
                }
            }
            return new ResourceTypeResource(this.id == null ? this.name : this.id, this.name, this.description, URI.create(this.endpoint), coreSchemaUri, schemaExtensionList);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static ResourceTypeDefinition fromJaxRsResource(Class<?> resource) {
        javax.ws.rs.Path path;
        ResourceType resourceType;
        Class<?> c = resource;
        do {
            resourceType = c.getAnnotation(ResourceType.class);
        } while ((c = c.getSuperclass()) != null && resourceType == null);
        c = resource;
        do {
            path = c.getAnnotation(javax.ws.rs.Path.class);
        } while ((c = c.getSuperclass()) != null && path == null);
        if (resourceType == null || path == null) {
            return null;
        }
        try {
            Builder builder = new Builder(resourceType.name(), path.value());
            builder.setDescription(resourceType.description());
            builder.setCoreSchema(SchemaUtils.getSchema(resourceType.schema()));
            builder.setDiscoverable(resourceType.discoverable());
            for (Class<?> optionalSchemaExtension : resourceType.optionalSchemaExtensions()) {
                builder.addOptionalSchemaExtension(SchemaUtils.getSchema(optionalSchemaExtension));
            }
            for (Class<?> requiredSchemaExtension : resourceType.requiredSchemaExtensions()) {
                builder.addRequiredSchemaExtension(SchemaUtils.getSchema(requiredSchemaExtension));
            }
            return builder.build();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static class Builder {
        private final String name;
        private final String endpoint;
        private String id;
        private String description;
        private SchemaResource coreSchema;
        private Set<SchemaResource> requiredSchemaExtensions = new HashSet<SchemaResource>();
        private Set<SchemaResource> optionalSchemaExtensions = new HashSet<SchemaResource>();
        private boolean discoverable = true;

        public Builder(String name, String endpoint) {
            if (name == null) {
                throw new IllegalArgumentException("name must not be null");
            }
            if (endpoint == null) {
                throw new IllegalArgumentException("endpoint must not be null");
            }
            this.name = name;
            this.endpoint = endpoint;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCoreSchema(SchemaResource coreSchema) {
            this.coreSchema = coreSchema;
            return this;
        }

        public Builder addRequiredSchemaExtension(SchemaResource schemaExtension) {
            this.requiredSchemaExtensions.add(schemaExtension);
            return this;
        }

        public Builder addOptionalSchemaExtension(SchemaResource schemaExtension) {
            this.optionalSchemaExtensions.add(schemaExtension);
            return this;
        }

        public Builder setDiscoverable(boolean discoverable) {
            this.discoverable = discoverable;
            return this;
        }

        public ResourceTypeDefinition build() {
            HashMap<SchemaResource, Boolean> schemaExtensions = new HashMap<SchemaResource, Boolean>(this.requiredSchemaExtensions.size() + this.optionalSchemaExtensions.size());
            for (SchemaResource schema : this.requiredSchemaExtensions) {
                schemaExtensions.put(schema, true);
            }
            for (SchemaResource schema : this.optionalSchemaExtensions) {
                schemaExtensions.put(schema, false);
            }
            return new ResourceTypeDefinition(this.id, this.name, this.description, this.endpoint, this.coreSchema, schemaExtensions, this.discoverable);
        }
    }
}

