/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.lint;

import com.twitter.util.lint.Category;
import com.twitter.util.lint.Issue;
import com.twitter.util.lint.Rule;
import com.twitter.util.lint.Rule$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class LoggingRules$ {
    public static final LoggingRules$ MODULE$ = new LoggingRules$();
    private static final Regex jarNameRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString(".*/([^/]+\\.jar)!.*"));
    private static final Rule MultipleSlf4jImpls = Rule$.MODULE$.apply((Category)Category.Configuration$.MODULE$, "Multiple Slf4j Implementations", "You should only depend on a single concrete implementation of the slf4j api. See https://www.slf4j.org/codes.html#multiple_bindings", (Function0 & Serializable)() -> {
        Seq paths = ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(ClassLoader.getSystemResources("org/slf4j/impl/StaticLoggerBinder.class")).asScala()).map((Function1 & Serializable)x$1 -> x$1.getFile()).toSeq();
        return MODULE$.issues((Seq<String>)paths);
    });
    private static final Rule NoLoggingHandler = Rule$.MODULE$.apply((Category)Category.Configuration$.MODULE$, "Admin logging handler implementation to dynamically change log levels is not configured", "To configure, please add a dependency on one of the supported TwitterServer logging implementations which will provide the ability to dynamically change the logging levels for that implementation: logback-classic, slf4j-log4j12, or slf4j-jdk14.", (Function0 & Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue("No logging handler implementation configured.")})));

    private Regex jarNameRegex() {
        return jarNameRegex;
    }

    public String jarName(String url) {
        String name;
        Option option;
        String string = url;
        String string2 = string != null && !(option = this.jarNameRegex().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((List)option.get()).lengthCompare(1) == 0 ? (name = (String)((LinearSeqOps)option.get()).apply(0)) : url;
        return string2;
    }

    public Seq<Issue> issues(Seq<String> jarPaths) {
        return jarPaths.length() > 1 ? (Seq)jarPaths.map((Function1 & Serializable)jarPath -> new Issue(MODULE$.jarName((String)jarPath))) : Nil$.MODULE$;
    }

    public Rule MultipleSlf4jImpls() {
        return MultipleSlf4jImpls;
    }

    public Rule NoLoggingHandler() {
        return NoLoggingHandler;
    }

    public Rule multipleLoggingHandlers(Seq<String> names) {
        return Rule$.MODULE$.apply((Category)Category.Configuration$.MODULE$, "Multiple Admin logging handler implementations detected", "To properly configure the ability to dynamically change log levels, please specify only one of the supported TwitterServer logging implementations on your classpath: logback-classic, slf4j-log4j12, or slf4j-jdk14.", (Function0 & Serializable)() -> (Seq)Seq$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Issue[]{new Issue(new StringBuilder(48).append("Multiple logging handler implementations found: ").append(names.mkString(", ")).toString())})));
    }

    private LoggingRules$() {
    }
}

