/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.Addr;
import com.twitter.finagle.Dtab;
import com.twitter.finagle.Service;
import com.twitter.finagle.client.EndpointRegistry$;
import com.twitter.finagle.http.Request;
import com.twitter.finagle.http.Response;
import com.twitter.finagle.http.Status;
import com.twitter.finagle.http.Uri;
import com.twitter.finagle.http.Uri$;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.loadbalancer.Metadata;
import com.twitter.finagle.util.StackRegistry;
import com.twitter.io.Buf;
import com.twitter.server.handler.ClientRegistryHandler$;
import com.twitter.server.handler.LoadBalancersHandler$;
import com.twitter.server.model.ClientProfile;
import com.twitter.server.util.HttpUtils$;
import com.twitter.server.util.MetricSource;
import com.twitter.server.view.BalancerHtmlView;
import com.twitter.server.view.EndpointRegistryView$;
import com.twitter.server.view.StackRegistryView$;
import com.twitter.util.Future;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005us!\u0002\u000b\u0016\u0011\u0013qb!\u0002\u0011\u0016\u0011\u0013\t\u0003\"\u0002\u0015\u0002\t\u0003I\u0003\u0002\u0003\u0016\u0002\u0011\u000b\u0007I\u0011B\u0016\t\u000fe\n!\u0019!C\u0001u!1Q*\u0001Q\u0001\nmBQAT\u0001\u0005\u0002=CQ!X\u0001\u0005\u0002yCQ\u0001Y\u0001\u0005\u0002\u0005Dq![\u0001\u0012\u0002\u0013\u0005!\u000eC\u0004y\u0003E\u0005I\u0011A=\u0007\u000b\u0001*\u0002!!\u0002\t\u0013\u0005\u00052B!A!\u0002\u0013\u0001\u0006\"CA\u0012\u0017\t\u0005\t\u0015!\u0003m\u0011%\t)c\u0003B\u0001B\u0003%1\u0010\u0003\u0004)\u0017\u0011\u0005\u0011q\u0005\u0005\t\u0003cY\u0001\u0015\"\u0003\u00024!A\u0011qH\u0006!\n\u0013\t\t\u0005\u0003\u0005\u0002H-\u0001K\u0011BA%\u0011\u001d\tYe\u0003C\u0001\u0003\u001b\nQc\u00117jK:$(+Z4jgR\u0014\u0018\u0010S1oI2,'O\u0003\u0002\u0017/\u00059\u0001.\u00198eY\u0016\u0014(B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\u0011!dG\u0001\bi^LG\u000f^3s\u0015\u0005a\u0012aA2p[\u000e\u0001\u0001CA\u0010\u0002\u001b\u0005)\"!F\"mS\u0016tGOU3hSN$(/\u001f%b]\u0012dWM]\n\u0003\u0003\t\u0002\"a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001\u001f\u0003))W\u000e\u001d;z\u000b:$(/_\u000b\u0002YA\u00191%L\u0018\n\u00059\"#\u0001B*p[\u0016\u0004\"\u0001\r\u001c\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005M:\u0012\u0001B;uS2L!!\u000e\u001a\u0002\u00195+GO]5d'>,(oY3\n\u0005]B$!B#oiJL(BA\u001b3\u0003=\u0001(o\u001c4jY\u0016|%\u000fZ3sS:<W#A\u001e\u0011\u0007q\"uI\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001)H\u0001\u0007yI|w\u000e\u001e \n\u0003\u0015J!a\u0011\u0013\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\t\u001fJ$WM]5oO*\u00111\t\n\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015^\tQ!\\8eK2L!\u0001T%\u0003\u001b\rc\u0017.\u001a8u!J|g-\u001b7f\u0003A\u0001(o\u001c4jY\u0016|%\u000fZ3sS:<\u0007%\u0001\u0006qe\u0016$H/\u001f*bi\u0016$\"\u0001\u0015-\u0011\u0005E+fB\u0001*T!\tqD%\u0003\u0002UI\u00051\u0001K]3eK\u001aL!AV,\u0003\rM#(/\u001b8h\u0015\t!F\u0005C\u0003Z\r\u0001\u0007!,\u0001\u0002teB\u00111eW\u0005\u00039\u0012\u0012a\u0001R8vE2,\u0017!\u0003:bi\u0016\u001cF/\u001f7f)\t\u0001v\fC\u0003Z\u000f\u0001\u0007!,\u0001\u0004sK:$WM\u001d\u000b\u0004!\n$\u0007\"B2\t\u0001\u0004\u0001\u0016!\u0002;ji2,\u0007\"B3\t\u0001\u00041\u0017\u0001\u00039s_\u001aLG.Z:\u0011\u0007q:w)\u0003\u0002i\r\n\u00191+Z9\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005Y'F\u00017p!\t\tT.\u0003\u0002oe\taQ*\u001a;sS\u000e\u001cv.\u001e:dK.\n\u0001\u000f\u0005\u0002rm6\t!O\u0003\u0002ti\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003k\u0012\n!\"\u00198o_R\fG/[8o\u0013\t9(OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aT#\u0001>+\u0005m|\u0007c\u0001?\u0002\u00025\tQP\u0003\u00024}*\u0011q0G\u0001\bM&t\u0017m\u001a7f\u0013\r\t\u0019! \u0002\u000e'R\f7m\u001b*fO&\u001cHO]=\u0014\u0007-\t9\u0001\u0005\u0005\u0002\n\u0005-\u0011qBA\u000e\u001b\u0005q\u0018bAA\u0007}\n91+\u001a:wS\u000e,\u0007\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005Ua0\u0001\u0003iiR\u0004\u0018\u0002BA\r\u0003'\u0011qAU3rk\u0016\u001cH\u000f\u0005\u0003\u0002\u0012\u0005u\u0011\u0002BA\u0010\u0003'\u0011\u0001BU3ta>t7/Z\u0001\nkJL\u0007K]3gSb\faa]8ve\u000e,\u0017!D:uC\u000e\\'+Z4jgR\u0014\u0018\u0010\u0006\u0005\u0002*\u0005-\u0012QFA\u0018!\ty2\u0002\u0003\u0004\u0002\"=\u0001\r\u0001\u0015\u0005\t\u0003Gy\u0001\u0013!a\u0001Y\"A\u0011QE\b\u0011\u0002\u0003\u000710A\bgS:$7\t\\5f]R\u001c6m\u001c9f)\u0011\t)$a\u000f\u0011\t\r\n9\u0004U\u0005\u0004\u0003s!#AB(qi&|g\u000e\u0003\u0004\u0002>A\u0001\r\u0001U\u0001\u000bG2LWM\u001c;OC6,\u0017\u0001\u00044j]\u0012\u0014V-]*d_B,G\u0003BA\u001b\u0003\u0007Ba!!\u0012\u0012\u0001\u0004\u0001\u0016aC2mS\u0016tGoU2pa\u0016\fab\u00197jK:$\bK]8gS2,7/F\u0001g\u0003\u0015\t\u0007\u000f\u001d7z)\u0011\ty%!\u0017\u0011\r\u0005E\u0013QKA\u000e\u001b\t\t\u0019F\u0003\u000243%!\u0011qKA*\u0005\u00191U\u000f^;sK\"9\u00111L\nA\u0002\u0005=\u0011a\u0001:fc\u0002")
public class ClientRegistryHandler
extends Service<Request, Response> {
    private final String uriPrefix;
    private final MetricSource source;
    private final StackRegistry stackRegistry;

    public static StackRegistry $lessinit$greater$default$3() {
        return ClientRegistryHandler$.MODULE$.$lessinit$greater$default$3();
    }

    public static MetricSource $lessinit$greater$default$2() {
        return ClientRegistryHandler$.MODULE$.$lessinit$greater$default$2();
    }

    public static String render(String string, Seq<ClientProfile> seq) {
        return ClientRegistryHandler$.MODULE$.render(string, seq);
    }

    public static String rateStyle(double d) {
        return ClientRegistryHandler$.MODULE$.rateStyle(d);
    }

    public static String prettyRate(double d) {
        return ClientRegistryHandler$.MODULE$.prettyRate(d);
    }

    public static Ordering<ClientProfile> profileOrdering() {
        return ClientRegistryHandler$.MODULE$.profileOrdering();
    }

    private Option<String> findClientScope(String clientName) {
        String k0 = String.valueOf(clientName);
        String k1 = new StringBuilder(5).append("clnt/").append(clientName).toString();
        return this.source.contains(new StringBuilder(18).append(k0).append("/loadbalancer/adds").toString()) ? new Some((Object)k0) : (this.source.contains(new StringBuilder(18).append(k1).append("/loadbalancer/adds").toString()) ? new Some((Object)k1) : None$.MODULE$);
    }

    private Option<String> findReqScope(String clientScope) {
        String k0 = new StringBuilder(6).append(clientScope).append("/tries").toString();
        String k1 = String.valueOf(clientScope);
        return this.source.contains(new StringBuilder(9).append(k0).append("/requests").toString()) ? new Some((Object)k0) : (this.source.contains(new StringBuilder(9).append(k1).append("/requests").toString()) ? new Some((Object)k1) : None$.MODULE$);
    }

    private Seq<ClientProfile> clientProfiles() {
        return ((IterableOnceOps)this.stackRegistry.registrants().flatMap((Function1 & Serializable)x0$1 -> {
            StackRegistry.Entry entry;
            StackRegistry.Entry entry2 = x0$1;
            Object object = entry2 != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((entry = entry2).name())) ? this.findClientScope(entry.name()).flatMap((Function1 & Serializable)scope -> this.findReqScope((String)scope).flatMap((Function1 & Serializable)reqScope -> $this.source.get(new StringBuilder(18).append((String)scope).append("/loadbalancer/size").toString()).flatMap((Function1 & Serializable)size -> $this.source.get(new StringBuilder(23).append((String)scope).append("/loadbalancer/available").toString()).flatMap((Function1 & Serializable)available -> $this.source.get(new StringBuilder(9).append((String)reqScope).append("/requests").toString()).flatMap((Function1 & Serializable)req -> $this.source.get(new StringBuilder(9).append((String)reqScope).append("/failures").toString()).orElse((Function0 & Serializable)() -> ClientRegistryHandler$.MODULE$.com$twitter$server$handler$ClientRegistryHandler$$emptyEntry()).withFilter((Function1 & Serializable)reqFail -> BoxesRunTime.boxToBoolean((boolean)ClientRegistryHandler.$anonfun$clientProfiles$8(req, size, available, reqFail))).map((Function1 & Serializable)reqFail -> {
                int unavailable = (int)(size.delta() - available.delta());
                double sr = req.value() == 0.0 ? -1.0 : (req.delta() == 0.0 ? 1.0 - reqFail.value() / req.value() : 1.0 - reqFail.delta() / req.delta());
                return new ClientProfile(entry.name(), entry.addr(), (String)scope, sr, unavailable);
            })))))) : Nil$.MODULE$;
            return object;
        })).toSeq();
    }

    public Future<Response> apply(Request req) {
        Future<Response> future;
        Uri uri = Uri$.MODULE$.fromRequest(req);
        String string = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(uri.path()), this.uriPrefix);
        boolean bl = "index.html".equals(string) ? true : ("index.htm".equals(string) ? true : ("index.txt".equals(string) ? true : "clients".equals(string)));
        if (bl) {
            Seq leastPerformant = (Seq)((IterableOps)this.clientProfiles().sorted(ClientRegistryHandler$.MODULE$.profileOrdering())).take(4);
            String html = leastPerformant.isEmpty() ? "" : ClientRegistryHandler$.MODULE$.render("Least Performant Downstream Clients", (Seq<ClientProfile>)leastPerformant);
            String typ = string.endsWith(".txt") ? "text/plain" : "text/html";
            String x$1 = new StringBuilder(14).append(typ).append(";charset=UTF-8").toString();
            Buf x$2 = Buf.Utf8$.MODULE$.apply(html);
            Version x$32 = HttpUtils$.MODULE$.newResponse$default$1();
            Status x$4 = HttpUtils$.MODULE$.newResponse$default$2();
            Iterable<Tuple2<String, Object>> x$5 = HttpUtils$.MODULE$.newResponse$default$3();
            future = HttpUtils$.MODULE$.newResponse(x$32, x$4, x$5, x$1, x$2);
        } else {
            Future<Response> future2;
            String decodedName = URLDecoder.decode(string, StandardCharsets.UTF_8.name());
            Iterable clientEntries = (Iterable)this.stackRegistry.registrants().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClientRegistryHandler.$anonfun$apply$1(decodedName, x$3)));
            if (clientEntries.isEmpty()) {
                future2 = HttpUtils$.MODULE$.new404(new StringBuilder(20).append(string).append(" could not be found.").toString(), HttpUtils$.MODULE$.new404$default$2());
            } else {
                StackRegistry.Entry client = (StackRegistry.Entry)clientEntries.head();
                Option<String> scope = this.findClientScope(client.name());
                String stackHtml = StackRegistryView$.MODULE$.render(client, scope);
                Option<Metadata> loadBalancerData = LoadBalancersHandler$.MODULE$.getBalancer((Option<String>)new Some((Object)string));
                BalancerHtmlView loadBalancerView = new BalancerHtmlView(loadBalancerData, LoadBalancersHandler$.MODULE$.RoutePath());
                String loadBalancerHtml = loadBalancerView.render();
                Map endpointEntry = EndpointRegistry$.MODULE$.registry().endpoints(string);
                String endpointHtml = EndpointRegistryView$.MODULE$.render((Map<Dtab, Map<String, Addr>>)endpointEntry);
                String x$6 = "text/html;charset=UTF-8";
                Buf x$7 = Buf.Utf8$.MODULE$.apply(new StringBuilder(0).append(stackHtml).append(loadBalancerHtml).append(endpointHtml).toString());
                Version x$8 = HttpUtils$.MODULE$.newResponse$default$1();
                Status x$9 = HttpUtils$.MODULE$.newResponse$default$2();
                Iterable<Tuple2<String, Object>> x$10 = HttpUtils$.MODULE$.newResponse$default$3();
                future2 = HttpUtils$.MODULE$.newResponse(x$8, x$9, x$10, "text/html;charset=UTF-8", x$7);
            }
            future = future2;
        }
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$clientProfiles$8(MetricSource.Entry req$1, MetricSource.Entry size$1, MetricSource.Entry available$1, MetricSource.Entry reqFail) {
        return req$1.value() > 0.0 || size$1.delta() - available$1.delta() > 0.0;
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(String decodedName$1, StackRegistry.Entry x$3) {
        String string = x$3.name();
        String string2 = decodedName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public ClientRegistryHandler(String uriPrefix, MetricSource source, StackRegistry stackRegistry) {
        this.uriPrefix = uriPrefix;
        this.source = source;
        this.stackRegistry = stackRegistry;
    }
}

