/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.server.handler;

import com.twitter.finagle.client.ClientRegistry$;
import com.twitter.finagle.util.StackRegistry;
import com.twitter.server.model.ClientProfile;
import com.twitter.server.util.HtmlUtils$;
import com.twitter.server.util.MetricSource;
import com.twitter.server.util.MetricSource$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class ClientRegistryHandler$ {
    public static final ClientRegistryHandler$ MODULE$ = new ClientRegistryHandler$();
    private static Some<MetricSource.Entry> com$twitter$server$handler$ClientRegistryHandler$$emptyEntry;
    private static final Ordering<ClientProfile> profileOrdering;
    private static volatile boolean bitmap$0;

    static {
        profileOrdering = package$.MODULE$.Ordering().by((Function1 & Serializable)x$1 -> BoxesRunTime.boxToDouble((double)x$1.successRate()), (Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$);
    }

    public MetricSource $lessinit$greater$default$2() {
        return new MetricSource(MetricSource$.MODULE$.$lessinit$greater$default$1(), MetricSource$.MODULE$.$lessinit$greater$default$2());
    }

    public StackRegistry $lessinit$greater$default$3() {
        return ClientRegistry$.MODULE$;
    }

    private Some<MetricSource.Entry> emptyEntry$lzycompute() {
        ClientRegistryHandler$ clientRegistryHandler$ = this;
        synchronized (clientRegistryHandler$) {
            if (!bitmap$0) {
                com$twitter$server$handler$ClientRegistryHandler$$emptyEntry = new Some((Object)new MetricSource.Entry("", 0.0, 0.0));
                bitmap$0 = true;
            }
        }
        return com$twitter$server$handler$ClientRegistryHandler$$emptyEntry;
    }

    public Some<MetricSource.Entry> com$twitter$server$handler$ClientRegistryHandler$$emptyEntry() {
        return !bitmap$0 ? this.emptyEntry$lzycompute() : com$twitter$server$handler$ClientRegistryHandler$$emptyEntry;
    }

    public Ordering<ClientProfile> profileOrdering() {
        return profileOrdering;
    }

    public String prettyRate(double sr) {
        String string;
        if (sr < 0.0) {
            string = "N/A";
        } else {
            double arg$macro$1 = sr * 100.0;
            string = StringOps$.MODULE$.format$extension("%2.2f%%", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)arg$macro$1)}));
        }
        return string;
    }

    public String rateStyle(double sr) {
        return sr < 0.0 ? "sr-undefined" : (sr < 0.9 ? "sr-bad" : (sr < 0.99 ? "sr-poor" : "sr-good"));
    }

    public String render(String title, Seq<ClientProfile> profiles) {
        return new StringBuilder(113).append("<h4 class=\"header text-center\">").append(HtmlUtils$.MODULE$.escapeHtml(title)).append("</h4>\n        <hr/>\n        <div id=\"clients\" class=\"row\">\n        ").append(((IterableOnceOps)profiles.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ClientRegistryHandler$.$anonfun$render$1(check$ifrefutable$1))).map((Function1 & Serializable)x$2 -> {
            ClientProfile clientProfile = x$2;
            if (clientProfile == null) {
                throw new MatchError((Object)clientProfile);
            }
            String name = clientProfile.name();
            String addr = clientProfile.addr();
            String scope = clientProfile.scope();
            double sr = clientProfile.successRate();
            int unavailable = clientProfile.unavailable();
            String string = new StringBuilder(471).append("<div class=\"col-md-3\">\n                  <div class=\"client\">\n                    <h4 class=\"name\"><a href=\"/admin/clients/").append(name).append("\">").append(HtmlUtils$.MODULE$.escapeHtml(name)).append("</a></h4>\n                    <p class=\"dest text-muted\">").append(HtmlUtils$.MODULE$.escapeHtml(addr)).append("</p>\n                    ").append((Object)(unavailable == 0 ? "" : new StringBuilder(351).append("<a href=\"/admin/metrics#").append(scope).append("/loadbalancer/available\"\n                            data-toggle=\"tooltip\" data-placement=\"top\"\n                            class=\"conn-trouble btn-xs btn-default\">\n                            <span class=\"glyphicon glyphicon-exclamation-sign\"\n                            aria-hidden=\"true\"></span> ").append(HtmlUtils$.MODULE$.escapeHtml(((Object)BoxesRunTime.boxToInteger((int)unavailable)).toString())).append(" unavailable endpoint(s)</a>").toString())).append("\n                    <hr/>\n                    <div class=\"row\">\n                    <h6 class='sr-header col-xs-6'>success rate</h6>\n                    <h3 class='sr-text col-xs-6 ").append(MODULE$.rateStyle(sr)).append("'>").append(MODULE$.prettyRate(sr)).append("</h3>\n                    </div>\n                  </div>\n                </div>").toString();
            return string;
        })).mkString("\n")).append("\n        </div>").toString();
    }

    public static final /* synthetic */ boolean $anonfun$render$1(ClientProfile check$ifrefutable$1) {
        ClientProfile clientProfile = check$ifrefutable$1;
        boolean bl = clientProfile != null;
        return bl;
    }

    private ClientRegistryHandler$() {
    }
}

