/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.transport;

import com.twitter.finagle.mux.transport.BadMessageException;
import com.twitter.finagle.mux.transport.Message$ReplyStatus$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.mux.transport.Message$Types$;
import com.twitter.finagle.netty4.ByteBufAsBuf;
import com.twitter.finagle.netty4.codec.BufCodec$;
import com.twitter.io.Buf;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;

@ChannelHandler.Sharable
public final class MuxDirectBufferHandler$
extends ChannelDuplexHandler {
    public static MuxDirectBufferHandler$ MODULE$;

    static {
        new MuxDirectBufferHandler$();
    }

    private Buf copyRelease(ByteBuf bb) {
        byte[] res = new byte[bb.readableBytes()];
        bb.readBytes(res);
        bb.release();
        return Buf.ByteArray$.Owned$.MODULE$.apply(res);
    }

    private Buf copyRetain(ByteBuf bb) {
        byte[] res = new byte[bb.readableBytes()];
        bb.readBytes(res);
        return Buf.ByteArray$.Owned$.MODULE$.apply(res);
    }

    private Buf decodeRdispatch(ChannelHandlerContext ctx, int startIdx, ByteBuf bb) {
        ByteBufAsBuf byteBufAsBuf;
        byte by = bb.readByte();
        if (Message$ReplyStatus$.MODULE$.Ok() == by) {
            int nCtxs = bb.readShort();
            for (int idx = 0; idx < nCtxs; ++idx) {
                short k = bb.readShort();
                bb.readerIndex(bb.readerIndex() + k);
                short v = bb.readShort();
                bb.readerIndex(bb.readerIndex() + v);
            }
            Buf headers = this.copyRetain(bb.slice(startIdx, bb.readerIndex() - startIdx));
            Buf payload = this.copyRelease(bb.slice(bb.readerIndex(), bb.readableBytes()));
            byteBufAsBuf = headers.concat(payload);
        } else {
            byteBufAsBuf = new ByteBufAsBuf(bb.readerIndex(startIdx));
        }
        return byteBufAsBuf;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Object object = msg;
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (byteBuf.readableBytes() < 4) {
                byteBuf.release();
                throw new BadMessageException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"saw message with fewer than 4 readable bytes: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg})));
            }
            int savedIdx = byteBuf.readerIndex();
            int header = byteBuf.readInt();
            byte typ = Message$Tags$.MODULE$.extractType(header);
            int tag = Message$Tags$.MODULE$.extractTag(header);
            Buf res = Message$Tags$.MODULE$.isFragment(tag) ? this.copyRelease(byteBuf.readerIndex(savedIdx)) : (Message$Types$.MODULE$.isRefCounted(typ) ? new ByteBufAsBuf(byteBuf.readerIndex(savedIdx)) : (typ == Message$Types$.MODULE$.Rdispatch() ? this.decodeRdispatch(ctx, savedIdx, byteBuf) : this.copyRelease(byteBuf.readerIndex(savedIdx))));
            ctx.fireChannelRead((Object)res);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            ctx.fireChannelRead(msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise p) {
        BufCodec$.MODULE$.write(ctx, msg, p);
    }

    private MuxDirectBufferHandler$() {
        MODULE$ = this;
    }
}

