/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.Service;
import com.twitter.finagle.Stack;
import com.twitter.finagle.Status;
import com.twitter.finagle.Status$;
import com.twitter.finagle.context.Context;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.RemoteInfo;
import com.twitter.finagle.exp.pushsession.PushChannelHandle;
import com.twitter.finagle.exp.pushsession.PushSession;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.ServerDispatcher$State$;
import com.twitter.finagle.mux.exp.pushsession.MessageWriter;
import com.twitter.finagle.mux.exp.pushsession.MuxMessageDecoder;
import com.twitter.finagle.mux.exp.pushsession.MuxServerSession$;
import com.twitter.finagle.mux.exp.pushsession.ServerTracker;
import com.twitter.finagle.mux.gracefulShutdownEnabled$;
import com.twitter.finagle.mux.lease.exp.Lessor;
import com.twitter.finagle.mux.lease.exp.Lessor$Param$;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$PreEncoded$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.param.Label;
import com.twitter.finagle.param.Label$;
import com.twitter.finagle.param.Stats;
import com.twitter.finagle.param.Stats$;
import com.twitter.finagle.param.Timer;
import com.twitter.finagle.param.Timer$;
import com.twitter.finagle.param.Tracer;
import com.twitter.finagle.param.Tracer$;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.finagle.transport.Transport$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Future;
import com.twitter.util.Local$;
import com.twitter.util.Return$;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.TimeoutException;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.concurrent.Executor;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rg!B\u0001\u0003\u0005!q!\u0001E'vqN+'O^3s'\u0016\u001c8/[8o\u0015\t\u0019A!A\u0006qkND7/Z:tS>t'BA\u0003\u0007\u0003\r)\u0007\u0010\u001d\u0006\u0003\u000f!\t1!\\;y\u0015\tI!\"A\u0004gS:\fw\r\\3\u000b\u0005-a\u0011a\u0002;xSR$XM\u001d\u0006\u0002\u001b\u0005\u00191m\\7\u0014\u0005\u0001y\u0001\u0003\u0002\t\u0014+mi\u0011!\u0005\u0006\u0003\u0007IQ!!\u0002\u0005\n\u0005Q\t\"a\u0003)vg\"\u001cVm]:j_:\u0004\"AF\r\u000e\u0003]Q!\u0001\u0007\u0006\u0002\u0005%|\u0017B\u0001\u000e\u0018\u0005)\u0011\u0015\u0010^3SK\u0006$WM\u001d\t\u0003-qI!!H\f\u0003\u0007\t+h\r\u0003\u0005 \u0001\t\u0005\t\u0015!\u0003\"\u0003\u0019\u0001\u0018M]1ng\u000e\u0001\u0001C\u0001\u0012'\u001d\t\u0019C%D\u0001\t\u0013\t)\u0003\"A\u0003Ti\u0006\u001c7.\u0003\u0002(Q\t1\u0001+\u0019:b[NT!!\n\u0005\t\u0011)\u0002!\u0011!Q\u0001\n-\nq\u0001Z3d_\u0012,'\u000f\u0005\u0002-[5\t!!\u0003\u0002/\u0005\t\tR*\u001e=NKN\u001c\u0018mZ3EK\u000e|G-\u001a:\t\u0011A\u0002!\u0011!Q\u0001\nE\nQ\"\\3tg\u0006<Wm\u0016:ji\u0016\u0014\bC\u0001\u00173\u0013\t\u0019$AA\u0007NKN\u001c\u0018mZ3Xe&$XM\u001d\u0005\tk\u0001\u0011\t\u0011)A\u0005m\u00051\u0001.\u00198eY\u0016\u0004B\u0001E\u001c\u00167%\u0011\u0001(\u0005\u0002\u0012!V\u001c\bn\u00115b]:,G\u000eS1oI2,\u0007\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001e\u0002\u000fM,'O^5dKB!1\u0005\u0010 C\u0013\ti\u0004BA\u0004TKJ4\u0018nY3\u0011\u0005}\u0002U\"\u0001\u0004\n\u0005\u00053!a\u0002*fcV,7\u000f\u001e\t\u0003\u007f\rK!\u0001\u0012\u0004\u0003\u0011I+7\u000f]8og\u0016DQA\u0012\u0001\u0005\u0002\u001d\u000ba\u0001P5oSRtDC\u0002%J\u0015.cU\n\u0005\u0002-\u0001!)q$\u0012a\u0001C!)!&\u0012a\u0001W!)\u0001'\u0012a\u0001c!)Q'\u0012a\u0001m!)!(\u0012a\u0001w!1q\n\u0001Q\u0005\nA\u000ba\u0001\\8dC2\u001cX#A)\u0011\u0005ICfBA*W\u001b\u0005!&BA+\u000b\u0003\u0011)H/\u001b7\n\u0005]#\u0016!\u0002'pG\u0006d\u0017BA-[\u0005\u001d\u0019uN\u001c;fqRT!a\u0016+\t\rq\u0003\u0001\u0015!\u0003^\u0003\u0011)\u00070Z2\u0011\u0005y#W\"A0\u000b\u0005\u0001\f\u0017AC2p]\u000e,(O]3oi*\u0011QK\u0019\u0006\u0002G\u0006!!.\u0019<b\u0013\t)wL\u0001\u0005Fq\u0016\u001cW\u000f^8s\u0011\u00199\u0007\u0001)A\u0005Q\u00061A.Z:t_J\u0004\"![7\u000e\u0003)T!!B6\u000b\u000514\u0011!\u00027fCN,\u0017B\u00018k\u0005\u0019aUm]:pe\"1\u0001\u000f\u0001Q\u0001\nE\fQb\u001d;biN\u0014VmY3jm\u0016\u0014\bC\u0001:v\u001b\u0005\u0019(B\u0001;\t\u0003\u0015\u0019H/\u0019;t\u0013\t18OA\u0007Ti\u0006$8OU3dK&4XM\u001d\u0005\u0007q\u0002\u0001\u000b\u0011B=\u0002\u000fQ\u0014\u0018mY6feB\u0011AF_\u0005\u0003w\n\u0011QbU3sm\u0016\u0014HK]1dW\u0016\u0014\bBB?\u0001A\u0003&a0A\u0007eSN\u0004\u0018\r^2i'R\fG/\u001a\t\u0004\u007f\u0006\rb\u0002BA\u0001\u0003;qA!a\u0001\u0002\u001a9!\u0011QAA\f\u001d\u0011\t9!!\u0006\u000f\t\u0005%\u00111\u0003\b\u0005\u0003\u0017\t\t\"\u0004\u0002\u0002\u000e)\u0019\u0011q\u0002\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0019\u00111\u0004\u0004\u0002!M+'O^3s\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018\u0002BA\u0010\u0003C\tQa\u0015;bi\u0016T1!a\u0007\u0007\u0013\u0011\t)#a\n\u0003\u000bY\u000bG.^3\n\t\u0005%\u00121\u0006\u0002\f\u000b:,X.\u001a:bi&|gN\u0003\u0002\u0002.\u0005)1oY1mC\"\u001aA0!\r\u0011\t\u0005M\u0012QG\u0007\u0003\u0003WIA!a\u000e\u0002,\tAao\u001c7bi&dW\rC\u0004\u0002<\u0001!\t!!\u0010\u0002\u000fI,7-Z5wKR!\u0011qHA#!\u0011\t\u0019$!\u0011\n\t\u0005\r\u00131\u0006\u0002\u0005+:LG\u000fC\u0004\u0002H\u0005e\u0002\u0019A\u000b\u0002\rI,\u0017\rZ3s\u0011!\tY\u0005\u0001Q\u0005\n\u00055\u0013A\u00049s_\u000e,7o]'fgN\fw-\u001a\u000b\u0005\u0003\u007f\ty\u0005\u0003\u0005\u0002R\u0005%\u0003\u0019AA*\u0003\u001diWm]:bO\u0016\u0004B!!\u0016\u0002\\5\u0011\u0011q\u000b\u0006\u0004\u000332\u0011!\u0003;sC:\u001c\bo\u001c:u\u0013\u0011\ti&a\u0016\u0003\u000f5+7o]1hK\"9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0014AB:uCR,8/\u0006\u0002\u0002fA\u00191%a\u001a\n\u0007\u0005%\u0004B\u0001\u0004Ti\u0006$Xo\u001d\u0005\b\u0003[\u0002A\u0011AA8\u0003\u0015\u0019Gn\\:f)\u0011\t\t(a\u001e\u0011\u000bM\u000b\u0019(a\u0010\n\u0007\u0005UDK\u0001\u0004GkR,(/\u001a\u0005\t\u0003s\nY\u00071\u0001\u0002|\u0005AA-Z1eY&tW\rE\u0002T\u0003{J1!a U\u0005\u0011!\u0016.\\3\t\u0011\u0005\r\u0005\u0001)C\u0005\u0003\u000b\u000b1\u0002[1oI2,7\t\\8tKR!\u0011qHAD\u0011!\tI(!!A\u0002\u0005m\u0004\u0002CAF\u0001\u0001&I!!$\u0002\u001d!\fg\u000e\u001a7f'\",H\u000fZ8x]R!\u0011qHAH\u0011!\t\t*!#A\u0002\u0005M\u0015A\u0002:fCN|g\u000eE\u0003T\u0003+\u000by$C\u0002\u0002\u0018R\u00131\u0001\u0016:z\u000f\u001d\tYJ\u0001E\u0005\u0003;\u000b\u0001#T;y'\u0016\u0014h/\u001a:TKN\u001c\u0018n\u001c8\u0011\u00071\nyJ\u0002\u0004\u0002\u0005!%\u0011\u0011U\n\u0005\u0003?\u000b\u0019\u000b\u0005\u0003\u00024\u0005\u0015\u0016\u0002BAT\u0003W\u0011a!\u00118z%\u00164\u0007b\u0002$\u0002 \u0012\u0005\u00111\u0016\u000b\u0003\u0003;C!\"a,\u0002 \n\u0007I\u0011BAY\u0003\rawnZ\u000b\u0003\u0003g\u0003B!!.\u0002<6\u0011\u0011q\u0017\u0006\u0004\u0003sS\u0011a\u00027pO\u001eLgnZ\u0005\u0005\u0003{\u000b9L\u0001\u0004M_\u001e<WM\u001d\u0005\n\u0003\u0003\fy\n)A\u0005\u0003g\u000bA\u0001\\8hA\u0001")
public final class MuxServerSession
extends PushSession<ByteReader, Buf> {
    private final Stack.Params params;
    private final MuxMessageDecoder decoder;
    private final MessageWriter messageWriter;
    private final PushChannelHandle<ByteReader, Buf> handle;
    private final Service<Request, Response> service;
    private final Executor exec;
    private final Lessor lessor;
    private final StatsReceiver statsReceiver;
    public final ServerTracker com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker;
    private volatile Enumeration.Value dispatchState;

    private Option<?>[] locals() {
        return (Option[])Local$.MODULE$.letClear((Function0 & Serializable & scala.Serializable)() -> {
            Context.KeyValuePair remoteAddressLocal = new Context.KeyValuePair((Context)Contexts$.MODULE$.local(), (Object)RemoteInfo.Upstream$.MODULE$.AddressCtx(), (Object)$this.handle.remoteAddress());
            Option peerCertLocal = $this.handle.peerCertificate().map((Function1 & Serializable & scala.Serializable)x$1 -> new Context.KeyValuePair((Context)Contexts$.MODULE$.local(), (Object)Transport$.MODULE$.peerCertCtx(), x$1));
            return (Option[])Trace$.MODULE$.letTracer(((Tracer)$this.params.apply(Tracer$.MODULE$.param())).tracer(), (Function0 & Serializable & scala.Serializable)() -> (Option[])Contexts$.MODULE$.local().let((Iterable)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Context.KeyValuePair[]{remoteAddressLocal}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(peerCertLocal), Seq$.MODULE$.canBuildFrom()), (Function0 & Serializable & scala.Serializable)() -> Local$.MODULE$.save()));
        });
    }

    public void receive(ByteReader reader) {
        try {
            Message message = this.decoder.decode(reader);
            if (message != null) {
                this.processMessage(message);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleShutdown((Try<BoxedUnit>)new Throw(t));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processMessage(Message message) {
        Message message2 = message;
        if (message2 instanceof Message.Tdispatch) {
            Message.Tdispatch tdispatch = (Message.Tdispatch)message2;
            this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.dispatch(tdispatch);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message2 instanceof Message.Treq) {
            Message.Treq treq = (Message.Treq)message2;
            this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.dispatch(treq);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message2 instanceof Message.Tping) {
            Message.Tping tping = (Message.Tping)message2;
            int tag = tping.tag();
            Message message3 = tag == Message$Tags$.MODULE$.PingTag() ? Message$PreEncoded$.MODULE$.Rping() : new Message.Rping(tag);
            this.messageWriter.write(message3);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message2 instanceof Message.Tdiscarded) {
            Message.Tdiscarded tdiscarded = (Message.Tdiscarded)message2;
            int tag = tdiscarded.which();
            String why = tdiscarded.why();
            this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.discarded(tag, why);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message2 instanceof Message.Rdrain) {
            Message.Rdrain rdrain = (Message.Rdrain)message2;
            int n = rdrain.tag();
            if (Message$Tags$.MODULE$.ControlTag() == n) {
                Enumeration.Value value = this.dispatchState;
                Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Draining();
                if (!(value != null ? !value.equals(value2) : value2 != null)) {
                    MuxServerSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$log().debug("Received Rdrain", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.drain();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        Message.Rerr rerror = new Message.Rerr(message2.tag(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected mux message type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)message2.typ())})));
        this.messageWriter.write(rerror);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public Status status() {
        Status.Open$ open$;
        Enumeration.Value value = this.dispatchState;
        Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Open();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            open$ = Status.Open$.MODULE$;
        } else {
            Enumeration.Value value4 = ServerDispatcher$State$.MODULE$.Draining();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                open$ = Status.Busy$.MODULE$;
            } else {
                Enumeration.Value value6 = ServerDispatcher$State$.MODULE$.Closed();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    open$ = Status.Closed$.MODULE$;
                } else {
                    throw new MatchError((Object)value);
                }
            }
        }
        Status.Open$ stateStatus = open$;
        return Status$.MODULE$.worst(this.handle.status(), (Status)stateStatus);
    }

    public Future<BoxedUnit> close(Time deadline) {
        this.exec.execute(new Runnable(this, deadline){
            private final /* synthetic */ MuxServerSession $outer;
            private final Time deadline$1;

            public void run() {
                this.$outer.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleClose(this.deadline$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.deadline$1 = deadline$1;
            }
        });
        return this.handle.onClose();
    }

    public void com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleClose(Time deadline) {
        block2: {
            Enumeration.Value value = this.dispatchState;
            Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Open();
            if (value != null ? !value.equals(value2) : value2 != null) break block2;
            this.dispatchState = ServerDispatcher$State$.MODULE$.Draining();
            if (!BoxesRunTime.unboxToBoolean((Object)gracefulShutdownEnabled$.MODULE$.apply())) {
                this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleShutdown((Try<BoxedUnit>)Return$.MODULE$.Unit());
            } else {
                MuxServerSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$log().debug("Draining session", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"draining"})).incr();
                this.messageWriter.write(new Message.Tdrain(Message$Tags$.MODULE$.ControlTag()));
                this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.drained().by(((Timer)this.params.apply(Timer$.MODULE$.param())).timer(), deadline).respond((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    MuxServerSession.$anonfun$handleClose$1(this, deadline, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
        }
    }

    public void com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleShutdown(Try<BoxedUnit> reason) {
        block0: {
            Enumeration.Value value = this.dispatchState;
            Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Closed();
            if (!(value == null ? value2 != null : !value.equals(value2))) break block0;
            this.dispatchState = ServerDispatcher$State$.MODULE$.Closed();
            this.lessor.unregister(this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker);
            this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.interruptOutstandingDispatches();
            Closable$.MODULE$.all((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closable[]{this.handle, this.service})).close();
            reason.onFailure((Function1 & Serializable & scala.Serializable)t -> {
                MuxServerSession.$anonfun$handleShutdown$1(this, t);
                return BoxedUnit.UNIT;
            });
        }
    }

    public static final /* synthetic */ void $anonfun$handleClose$1(MuxServerSession $this, Time deadline$2, Try x0$1) {
        Throw throw_;
        Try try_ = x0$1;
        if (try_ instanceof Throw && (throw_ = (Throw)try_).e() instanceof TimeoutException) {
            $this.exec.execute(new Runnable($this, deadline$2){
                private final /* synthetic */ MuxServerSession $outer;
                private final Time deadline$2;

                public void run() {
                    TimeoutException t = new TimeoutException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to drain within the deadline ", ". Tracker state: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.deadline$2, this.$outer.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.currentState()})));
                    this.$outer.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleShutdown((Try<BoxedUnit>)new Throw((Throwable)t));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.deadline$2 = deadline$2;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$handleShutdown$1(MuxServerSession $this, Throwable t) {
        String name = ((Label)$this.params.apply(Label$.MODULE$.param())).label();
        MuxServerSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$log().info(t, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server session (", ") closed due to error"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public MuxServerSession(Stack.Params params, MuxMessageDecoder decoder, MessageWriter messageWriter, PushChannelHandle<ByteReader, Buf> handle, Service<Request, Response> service) {
        this.params = params;
        this.decoder = decoder;
        this.messageWriter = messageWriter;
        this.handle = handle;
        this.service = service;
        super(handle);
        this.exec = handle.serialExecutor();
        this.lessor = ((Lessor.Param)params.apply((Stack.Param)Lessor$Param$.MODULE$)).lessor();
        this.statsReceiver = ((Stats)params.apply(Stats$.MODULE$.param())).statsReceiver();
        this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker = new ServerTracker(this.exec, this.locals(), service, messageWriter, this.lessor, this.statsReceiver, handle.remoteAddress());
        this.dispatchState = ServerDispatcher$State$.MODULE$.Open();
        this.lessor.register(this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker);
        this.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$tracker.drained().respond((Function1 & Serializable & scala.Serializable)result -> {
            this.exec.execute(new Runnable(this, result){
                private final /* synthetic */ MuxServerSession $outer;
                private final Try result$1;

                public void run() {
                    this.$outer.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleShutdown((Try<BoxedUnit>)this.result$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.result$1 = result$1;
                }
            });
            return BoxedUnit.UNIT;
        });
        handle.onClose().respond((Function1 & Serializable & scala.Serializable)result -> {
            this.exec.execute(new Runnable(this, result){
                private final /* synthetic */ MuxServerSession $outer;
                private final Try result$2;

                public void run() {
                    this.$outer.com$twitter$finagle$mux$exp$pushsession$MuxServerSession$$handleShutdown((Try<BoxedUnit>)this.result$2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.result$2 = result$2;
                }
            });
            return BoxedUnit.UNIT;
        });
    }
}

