/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.Mux$;
import com.twitter.finagle.Service;
import com.twitter.finagle.Status;
import com.twitter.finagle.exp.pushsession.PushChannelHandle;
import com.twitter.finagle.exp.pushsession.PushSession;
import com.twitter.finagle.exp.pushsession.RefPushSession;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.exp.pushsession.MuxChannelHandle;
import com.twitter.finagle.mux.exp.pushsession.MuxServerNegotiator$;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import com.twitter.logging.Level;
import com.twitter.util.Closable;
import com.twitter.util.Closable$;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Timer;
import com.twitter.util.Try;
import java.io.Serializable;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ug!B\u0001\u0003\u0001!q!aE'vqN+'O^3s\u001d\u0016<w\u000e^5bi>\u0014(BA\u0002\u0005\u0003-\u0001Xo\u001d5tKN\u001c\u0018n\u001c8\u000b\u0005\u00151\u0011aA3ya*\u0011q\u0001C\u0001\u0004[VD(BA\u0005\u000b\u0003\u001d1\u0017N\\1hY\u0016T!a\u0003\u0007\u0002\u000fQ<\u0018\u000e\u001e;fe*\tQ\"A\u0002d_6\u001c\"\u0001A\b\u0011\tA\u0019RcG\u0007\u0002#)\u00111A\u0005\u0006\u0003\u000b!I!\u0001F\t\u0003\u0017A+8\u000f[*fgNLwN\u001c\t\u0003-ei\u0011a\u0006\u0006\u00031)\t!![8\n\u0005i9\"A\u0003\"zi\u0016\u0014V-\u00193feB\u0011a\u0003H\u0005\u0003;]\u00111AQ;g\u0011!y\u0002A!A!\u0002\u0013\t\u0013A\u00025b]\u0012dWm\u0001\u0001\u0011\u0005\t\u001aS\"\u0001\u0002\n\u0005\u0011\u0012!\u0001E'vq\u000eC\u0017M\u001c8fY\"\u000bg\u000e\u001a7f\u0011!1\u0003A!A!\u0002\u00139\u0013aB:feZL7-\u001a\t\u0005Q%Zs&D\u0001\t\u0013\tQ\u0003BA\u0004TKJ4\u0018nY3\u0011\u00051jS\"\u0001\u0004\n\u000592!a\u0002*fcV,7\u000f\u001e\t\u0003YAJ!!\r\u0004\u0003\u0011I+7\u000f]8og\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\u0011[\u0006\\W\rT8dC2DU-\u00193feN\u0004B!\u000e\u001d;u5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0005Gk:\u001cG/[8ocA\u00111(\u0013\b\u0003y\u001ds!!\u0010$\u000f\u0005y*eBA E\u001d\t\u00015)D\u0001B\u0015\t\u0011\u0005%\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005!3\u0011!\u0003%b]\u0012\u001c\b.Y6f\u0013\tQ5JA\u0004IK\u0006$WM]:\u000b\u0005!3\u0001\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\u0002\u00139,wm\u001c;jCR,\u0007#B\u001bPOE{\u0011B\u0001)7\u0005%1UO\\2uS>t'\u0007E\u00026%jJ!a\u0015\u001c\u0003\r=\u0003H/[8o\u0011!)\u0006A!A!\u0002\u00131\u0016!\u0002;j[\u0016\u0014\bCA,[\u001b\u0005A&BA-\u000b\u0003\u0011)H/\u001b7\n\u0005mC&!\u0002+j[\u0016\u0014\b\"B/\u0001\t\u0013q\u0016A\u0002\u001fj]&$h\b\u0006\u0004`A\u0006\u00147\r\u001a\t\u0003E\u0001AQa\b/A\u0002\u0005BQA\n/A\u0002\u001dBQa\r/A\u0002QBQ!\u0014/A\u00029CQ!\u0016/A\u0002Y+aA\u001a\u0001!\u0002\u00139'!\u0002)iCN,\u0007\u0003B\u001b9Q:\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0004\u0002\u0013Q\u0014\u0018M\\:q_J$\u0018BA7k\u0005\u001diUm]:bO\u0016\u0004\"!N8\n\u0005A4$\u0001B+oSRDaA\u001d\u0001!\u0002\u0013\u0019\u0018\u0001C:fgNLwN\u001c)\u0011\u0007]#x\"\u0003\u0002v1\n9\u0001K]8nSN,\u0007BB<\u0001A\u0003&\u00010\u0001\biC:$7\u000f[1lKBC\u0017m]3\u0011\u0005e,W\"\u0001\u0001\t\rm\u0004\u0001\u0015)\u0003}\u0003)\u0011XMZ*fgNLwN\u001c\t\u0005!u,2$\u0003\u0002\u007f#\tq!+\u001a4QkND7+Z:tS>t\u0007f\u0001>\u0002\u0002A\u0019Q'a\u0001\n\u0007\u0005\u0015aG\u0001\u0005w_2\fG/\u001b7f\u0011\u001d\tI\u0001\u0001C\u0005\u0003\u0017\tQb]3u%\u001647+Z:tS>tGc\u00018\u0002\u000e!9\u0011qBA\u0004\u0001\u0004a\u0018a\u0001:fM\"9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011aB8o\u00072|7/Z\u000b\u0003\u0003/\u0001BaVA\r]&\u0019\u00111\u0004-\u0003\r\u0019+H/\u001e:f\u0011\u001d\ty\u0002\u0001C\u0001\u0003C\tQa\u00197pg\u0016$B!a\u0006\u0002$!A\u0011QEA\u000f\u0001\u0004\t9#\u0001\u0005eK\u0006$G.\u001b8f!\r9\u0016\u0011F\u0005\u0004\u0003WA&\u0001\u0002+j[\u0016Dq!a\f\u0001\t\u0003\t\t$\u0001\u0004ti\u0006$Xo]\u000b\u0003\u0003g\u00012\u0001KA\u001b\u0013\r\t9\u0004\u0003\u0002\u0007'R\fG/^:\t\u000f\u0005m\u0002\u0001\"\u0001\u0002>\u00059!/Z2fSZ,Gc\u00018\u0002@!9\u0011\u0011IA\u001d\u0001\u0004)\u0012aB7fgN\fw-\u001a\u0005\t\u0003\u000b\u0002\u0001\u0015\"\u0003\u0002H\u0005q1\r[3dWJ+'O\u001d)iCN,W#\u0001=\t\u0011\u0005-\u0003\u0001)C\u0005\u0003\u000f\nAbZ3u\u0013:LG\u000f\u00155bg\u0016D\u0001\"a\u0014\u0001A\u0013%\u0011\u0011K\u0001\u0014e\u0016lw\u000e^3BI\u0012\u0014Xm]:TiJLgnZ\u000b\u0003\u0003'\u0002B!!\u0016\u0002^9!\u0011qKA-!\t\u0001e'C\u0002\u0002\\Y\na\u0001\u0015:fI\u00164\u0017\u0002BA0\u0003C\u0012aa\u0015;sS:<'bAA.m!A\u0011Q\r\u0001!\n\u0013\t9'\u0001\u0004o_&s\u0017\u000e\u001e\u000b\u0004]\u0006%\u0004bBA!\u0003G\u0002\r\u0001\u001b\u0005\t\u0003[\u0002\u0001\u0015\"\u0003\u0002p\u0005\u0011b.Z4pi&\fG/[8o'V\u001c7-Z:t)\rq\u0017\u0011\u000f\u0005\b\u0003g\nY\u00071\u0001\u0010\u0003\u001d\u0019Xm]:j_:D\u0001\"a\u001e\u0001A\u0013%\u0011\u0011P\u0001\u0013]\u0016<w\u000e^5bi&|gNR1jYV\u0014X\rF\u0003o\u0003w\n)\t\u0003\u0005\u0002~\u0005U\u0004\u0019AA@\u0003\r!\u0018m\u001a\t\u0004k\u0005\u0005\u0015bAABm\t\u0019\u0011J\u001c;\t\u0011\u0005\u001d\u0015Q\u000fa\u0001\u0003\u0013\u000b\u0011\u0001\u001e\t\u0005\u0003\u0017\u000b)J\u0004\u0003\u0002\u000e\u0006Eeb\u0001!\u0002\u0010&\tq'C\u0002\u0002\u0014Z\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0018\u0006e%!\u0003+ie><\u0018M\u00197f\u0015\r\t\u0019JN\u0004\b\u0003;\u0013\u0001\u0012BAP\u0003MiU\u000f_*feZ,'OT3h_RL\u0017\r^8s!\r\u0011\u0013\u0011\u0015\u0004\u0007\u0003\tAI!a)\u0014\t\u0005\u0005\u0016Q\u0015\t\u0004k\u0005\u001d\u0016bAAUm\t1\u0011I\\=SK\u001aDq!XAQ\t\u0003\ti\u000b\u0006\u0002\u0002 \"Q\u0011\u0011WAQ\u0005\u0004%I!a-\u0002\u00071|w-\u0006\u0002\u00026B!\u0011qWA_\u001b\t\tILC\u0002\u0002<*\tq\u0001\\8hO&tw-\u0003\u0003\u0002@\u0006e&A\u0002'pO\u001e,'\u000fC\u0005\u0002D\u0006\u0005\u0006\u0015!\u0003\u00026\u0006!An\\4!\u0011!\t9-!)\u0005\u0002\u0005%\u0017!B1qa2LHcC\b\u0002L\u00065\u0017qZAi\u0003'DaaHAc\u0001\u0004\t\u0003B\u0002\u0014\u0002F\u0002\u0007q\u0005\u0003\u00044\u0003\u000b\u0004\r\u0001\u000e\u0005\u0007\u001b\u0006\u0015\u0007\u0019\u0001(\t\rU\u000b)\r1\u0001W\u0001")
public class MuxServerNegotiator
extends PushSession<ByteReader, Buf> {
    private final MuxChannelHandle handle;
    private final Service<Request, Response> service;
    private final Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> makeLocalHeaders;
    private final Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> negotiate;
    private final Timer timer;
    private final Promise<PushSession<ByteReader, Buf>> sessionP;
    private Function1<Message, BoxedUnit> handshakePhase;
    private volatile RefPushSession<ByteReader, Buf> refSession;

    public static PushSession<ByteReader, Buf> apply(MuxChannelHandle muxChannelHandle, Service<Request, Response> service, Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> function1, Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> function2, Timer timer) {
        return MuxServerNegotiator$.MODULE$.apply(muxChannelHandle, service, function1, function2, timer);
    }

    public void com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$setRefSession(RefPushSession<ByteReader, Buf> ref) {
        this.refSession = ref;
    }

    public Future<BoxedUnit> onClose() {
        return this.handle.onClose();
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.sessionP.by(deadline, this.timer).transform((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Return) {
                Return return_ = (Return)try_;
                PushSession session = (PushSession)return_.r();
                future = session.close(deadline);
            } else if (try_ instanceof Throw) {
                future = Closable$.MODULE$.all((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Closable[]{$this.handle, $this.service})).close();
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        });
    }

    public Status status() {
        return this.handle.status();
    }

    public void receive(ByteReader message) {
        try {
            try {
                Message msg = Message$.MODULE$.decode(message);
                this.handshakePhase.apply((Object)msg);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    this.close();
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            message.close();
        }
    }

    private Function1<Message, BoxedUnit> checkRerrPhase() {
        return (Function1 & Serializable & scala.Serializable)x0$2 -> {
            MuxServerNegotiator.$anonfun$checkRerrPhase$1(this, x0$2);
            return BoxedUnit.UNIT;
        };
    }

    private Function1<Message, BoxedUnit> getInitPhase() {
        return (Function1 & Serializable & scala.Serializable)x0$3 -> {
            MuxServerNegotiator.$anonfun$getInitPhase$1(this, x0$3);
            return BoxedUnit.UNIT;
        };
    }

    private String remoteAddressString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"remote: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.handle.remoteAddress()}));
    }

    private void noInit(Message message) {
        try {
            PushSession session = (PushSession)this.negotiate.apply(this.service, (Object)None$.MODULE$);
            this.negotiationSuccess((PushSession<ByteReader, Buf>)session);
            session.receive((Object)ByteReader$.MODULE$.apply(Message$.MODULE$.encode(message)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.negotiationFailure(message.tag(), t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void negotiationSuccess(PushSession<ByteReader, Buf> session) {
        this.refSession.updateRef(session);
        this.sessionP.setValue(session);
        this.handshakePhase = (Function1 & Serializable & scala.Serializable)m -> {
            MuxServerNegotiator.$anonfun$negotiationSuccess$1(this, m);
            return BoxedUnit.UNIT;
        };
    }

    private void negotiationFailure(int tag, Throwable t) {
        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().warning(t, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Negotiation failed. Closing session. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.handshakePhase = (Function1 & Serializable & scala.Serializable)msg -> {
            MuxServerNegotiator.$anonfun$negotiationFailure$1(this, t, msg);
            return BoxedUnit.UNIT;
        };
        this.handle.send(Message$.MODULE$.encode(new Message.Rerr(tag, t.getMessage())), (Function1 & Serializable & scala.Serializable)x$1 -> {
            MuxServerNegotiator.$anonfun$negotiationFailure$2(this, t, x$1);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$checkRerrPhase$1(MuxServerNegotiator $this, Message x0$2) {
        Message message = x0$2;
        if (message instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message;
            int n = rerr.tag();
            String string = rerr.error();
            if (Handshake$.MODULE$.TinitTag() == n) {
                String string2 = Handshake$.MODULE$.CanTinitMsg();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received Rerr prelude to Tinit. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    }
                    $this.handshakePhase = $this.getInitPhase();
                    $this.handle.sendAndForget(Message$.MODULE$.encode(new Message.Rerr(Handshake$.MODULE$.TinitTag(), Handshake$.MODULE$.CanTinitMsg())));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        if (MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Rerr prelude not detected (received ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass().getSimpleName()})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Skipping Init phase. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
        $this.noInit(message);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$getInitPhase$1(MuxServerNegotiator $this, Message x0$3) {
        boolean bl = false;
        Message.Tinit tinit = null;
        Message message = x0$3;
        if (message instanceof Message.Tinit) {
            bl = true;
            tinit = (Message.Tinit)message;
            int tag = tinit.tag();
            short s = tinit.version();
            Seq<Tuple2<Buf, Buf>> headers = tinit.headers();
            if (Mux$.MODULE$.LatestVersion() == s) {
                BoxedUnit boxedUnit;
                try {
                    Seq localHeaders = (Seq)$this.makeLocalHeaders.apply(headers);
                    $this.handle.sendNowAndForget(Message$.MODULE$.encode(new Message.Rinit(tag, Mux$.MODULE$.LatestVersion(), (Seq<Tuple2<Buf, Buf>>)localHeaders)));
                    PushSession session = (PushSession)$this.negotiate.apply($this.service, (Object)new Some(headers));
                    $this.negotiationSuccess((PushSession<ByteReader, Buf>)session);
                    boxedUnit = BoxedUnit.UNIT;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (option.isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option.get();
                    $this.negotiationFailure(tag, t);
                    BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit3 = boxedUnit;
                return;
            }
        }
        if (bl) {
            int tag = tinit.tag();
            short v = tinit.version();
            IllegalStateException ex = new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported Mux version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToShort((short)v)})));
            $this.negotiationFailure(tag, ex);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().warning("Received Rerr init probe but didn't receive a follow up " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Tinit (received a ", "). ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{message.getClass().getSimpleName(), $this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            $this.noInit(message);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$negotiationSuccess$1(MuxServerNegotiator $this, Message m) {
        String msg = "After negotiation success, more messages were sent to the " + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"negotiating session: ", ". ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m.getClass().getSimpleName(), $this.remoteAddressString()}));
        IllegalStateException ex = new IllegalStateException(msg);
        MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().error((Throwable)ex, msg, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        $this.handle.close();
    }

    public static final /* synthetic */ void $anonfun$negotiationFailure$1(MuxServerNegotiator $this, Throwable t$1, Message msg) {
        block0: {
            if (!MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) break block0;
            MuxServerNegotiator$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxServerNegotiator$$log().debug(t$1, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Session negotiation failed. Swallowing message "})).s((Seq)Nil$.MODULE$) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") that raced shutdown. ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{msg.getClass().getSimpleName(), $this.remoteAddressString()})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        }
    }

    public static final /* synthetic */ void $anonfun$negotiationFailure$2(MuxServerNegotiator $this, Throwable t$1, Try x$1) {
        $this.close().ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.sessionP.setException(t$1));
    }

    public MuxServerNegotiator(MuxChannelHandle handle, Service<Request, Response> service, Function1<Seq<Tuple2<Buf, Buf>>, Seq<Tuple2<Buf, Buf>>> makeLocalHeaders, Function2<Service<Request, Response>, Option<Seq<Tuple2<Buf, Buf>>>, PushSession<ByteReader, Buf>> negotiate, Timer timer) {
        this.handle = handle;
        this.service = service;
        this.makeLocalHeaders = makeLocalHeaders;
        this.negotiate = negotiate;
        this.timer = timer;
        super((PushChannelHandle)handle);
        this.sessionP = Promise$.MODULE$.apply();
        this.handshakePhase = this.checkRerrPhase();
        this.refSession = null;
        handle.onClose().ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if ($this.sessionP.isDefined()) break block0;
                this.close();
            }
        });
    }
}

