/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.ChannelClosedException;
import com.twitter.finagle.Failure$;
import com.twitter.finagle.Status;
import com.twitter.finagle.exp.pushsession.PushChannelHandle;
import com.twitter.finagle.exp.pushsession.PushSession;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.exp.pushsession.MuxClientNegotiatingSession$;
import com.twitter.finagle.mux.exp.pushsession.MuxClientSession;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.util.Future;
import com.twitter.util.Promise;
import com.twitter.util.Promise$;
import com.twitter.util.Return;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Try;
import com.twitter.util.Try$;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g!B\u0001\u0003\u0005!q!aG'vq\u000ec\u0017.\u001a8u\u001d\u0016<w\u000e^5bi&twmU3tg&|gN\u0003\u0002\u0004\t\u0005Y\u0001/^:ig\u0016\u001c8/[8o\u0015\t)a!A\u0002fqBT!a\u0002\u0005\u0002\u00075,\bP\u0003\u0002\n\u0015\u00059a-\u001b8bO2,'BA\u0006\r\u0003\u001d!x/\u001b;uKJT\u0011!D\u0001\u0004G>l7C\u0001\u0001\u0010!\u0011\u00012#F\u000e\u000e\u0003EQ!a\u0001\n\u000b\u0005\u0015A\u0011B\u0001\u000b\u0012\u0005-\u0001Vo\u001d5TKN\u001c\u0018n\u001c8\u0011\u0005YIR\"A\f\u000b\u0005aQ\u0011AA5p\u0013\tQrC\u0001\u0006CsR,'+Z1eKJ\u0004\"A\u0006\u000f\n\u0005u9\"a\u0001\"vM\"Aq\u0004\u0001B\u0001B\u0003%\u0011%\u0001\u0004iC:$G.Z\u0002\u0001!\u0011\u0001\"%F\u000e\n\u0005\r\n\"!\u0005)vg\"\u001c\u0005.\u00198oK2D\u0015M\u001c3mK\"AQ\u0005\u0001B\u0001B\u0003%a%A\u0004wKJ\u001c\u0018n\u001c8\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\u000bMCwN\u001d;\t\u00115\u0002!\u0011!Q\u0001\n9\n!B\\3h_RL\u0017\r^8s!\u00119s&\r$\n\u0005AB#!\u0003$v]\u000e$\u0018n\u001c82!\r9#\u0007N\u0005\u0003g!\u0012aa\u00149uS>t\u0007CA\u001bD\u001d\t1\u0014I\u0004\u00028\u0001:\u0011\u0001h\u0010\b\u0003syr!AO\u001f\u000e\u0003mR!\u0001\u0010\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA\u0006\r\u0013\tI!\"\u0003\u0002\b\u0011%\u0011!IB\u0001\n\u0011\u0006tGm\u001d5bW\u0016L!\u0001R#\u0003\u000f!+\u0017\rZ3sg*\u0011!I\u0002\t\u0003\u000f\"k\u0011AA\u0005\u0003\u0013\n\u0011\u0001#T;y\u00072LWM\u001c;TKN\u001c\u0018n\u001c8\t\u0011-\u0003!\u0011!Q\u0001\n1\u000bq\u0001[3bI\u0016\u00148\u000f\u0005\u0002N\u0007:\u0011a*Q\u0007\u0002\r!A\u0001\u000b\u0001B\u0001B\u0003%\u0011+\u0001\u0003oC6,\u0007C\u0001*W\u001d\t\u0019F\u000b\u0005\u0002;Q%\u0011Q\u000bK\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002VQ!)!\f\u0001C\u00017\u00061A(\u001b8jiz\"b\u0001X/_?\u0002\f\u0007CA$\u0001\u0011\u0015y\u0012\f1\u0001\"\u0011\u0015)\u0013\f1\u0001'\u0011\u0015i\u0013\f1\u0001/\u0011\u0015Y\u0015\f1\u0001M\u0011\u0015\u0001\u0016\f1\u0001R\u0011\u0019\u0019\u0007\u0001)A\u0005I\u0006\tb.Z4pi&\fG/\u001a3TKN\u001c\u0018n\u001c8\u0011\u0007\u0015Dg)D\u0001g\u0015\t9'\"\u0001\u0003vi&d\u0017BA5g\u0005\u001d\u0001&o\\7jg\u0016Daa\u001b\u0001!\u0002\u0013a\u0017\u0001E:uCJ$h*Z4pi&\fG/[8o!\tiW/D\u0001o\u0015\ty\u0007/\u0001\u0004bi>l\u0017n\u0019\u0006\u0003cJ\f!bY8oGV\u0014(/\u001a8u\u0015\t97OC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Yt'!D!u_6L7MQ8pY\u0016\fg.\u0002\u0003y\u0001\u0011I(!\u0002)iCN,\u0007#B\u00140u\u0006\u0005\u0001CA>\u007f\u001b\u0005a(BA?\u0007\u0003%!(/\u00198ta>\u0014H/\u0003\u0002\u0000y\n9Q*Z:tC\u001e,\u0007cA\u0014\u0002\u0004%\u0019\u0011Q\u0001\u0015\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0013\u0001\u0001\u0015)\u0003\u0002\f\u0005)\u0001\u000f[1tKB\u0019\u0011QB<\u000e\u0003\u0001Aq!!\u0005\u0001\t\u0003\t\u0019\"A\u0005oK\u001e|G/[1uKR\u0011\u0011Q\u0003\t\u0005K\u0006]a)C\u0002\u0002\u001a\u0019\u0014aAR;ukJ,\u0007bBA\u000f\u0001\u0011\u0005\u0011qD\u0001\b_:\u001cEn\\:f+\t\t\t\u0003E\u0003f\u0003/\t\t\u0001C\u0004\u0002&\u0001!\t!a\n\u0002\u000b\rdwn]3\u0015\t\u0005\u0005\u0012\u0011\u0006\u0005\t\u0003W\t\u0019\u00031\u0001\u0002.\u0005AA-Z1eY&tW\rE\u0002f\u0003_I1!!\rg\u0005\u0011!\u0016.\\3\t\u000f\u0005U\u0002\u0001\"\u0001\u00028\u000511\u000f^1ukN,\"!!\u000f\u0011\t\u0005m\u0012QH\u0007\u0002\u0011%\u0019\u0011q\b\u0005\u0003\rM#\u0018\r^;t\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\nqA]3dK&4X\r\u0006\u0003\u0002\u0002\u0005\u001d\u0003bBA%\u0003\u0003\u0002\r!F\u0001\u0007e\u0016\fG-\u001a:\t\u0011\u00055\u0003\u0001)C\u0005\u0003\u001f\na\u0003\u001d5bg\u0016\u0014VmY3jm\u0016l\u0015M]6feJ+'O\u001d\u000b\u0005\u0003\u0003\t\t\u0006C\u0004\u0002T\u0005-\u0003\u0019\u0001>\u0002\u000f5,7o]1hK\"A\u0011q\u000b\u0001!\n\u0013\tI&A\tqQ\u0006\u001cXMU3dK&4XMU5oSR$B!!\u0001\u0002\\!9\u00111KA+\u0001\u0004Q\b\u0002CA0\u0001\u0001&I!!\u0019\u0002#\u0019Lg.[:i\u001d\u0016<w\u000e^5bi&|g\u000e\u0006\u0003\u0002\u0002\u0005\r\u0004bBA3\u0003;\u0002\r!M\u0001\u000eg\u0016\u0014h/\u001a:IK\u0006$WM]:\t\u0011\u0005%\u0004\u0001)C\u0005\u0003W\nQBZ1jY\"\u000bg\u000eZ:iC.,G\u0003BA\u0001\u0003[B\u0001\"a\u001c\u0002h\u0001\u0007\u0011\u0011O\u0001\u0004Kb\u001c\u0007\u0003BA:\u0003{rA!!\u001e\u0002z9\u0019!(a\u001e\n\u0003%J1!a\u001f)\u0003\u001d\u0001\u0018mY6bO\u0016LA!a \u0002\u0002\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003wBsaBAC\u0005!%\u0011qQ\u0001\u001c\u001bVD8\t\\5f]RtUmZ8uS\u0006$\u0018N\\4TKN\u001c\u0018n\u001c8\u0011\u0007\u001d\u000bII\u0002\u0004\u0002\u0005!%\u00111R\n\u0005\u0003\u0013\u000bi\tE\u0002(\u0003\u001fK1!!%)\u0005\u0019\te.\u001f*fM\"9!,!#\u0005\u0002\u0005UECAAD\u0011)\tI*!#C\u0002\u0013%\u00111T\u0001\u0004Y><WCAAO!\u0011\ty*!*\u000e\u0005\u0005\u0005&bAAR\u0015\u00059An\\4hS:<\u0017\u0002BAT\u0003C\u0013a\u0001T8hO\u0016\u0014\b\"CAV\u0003\u0013\u0003\u000b\u0011BAO\u0003\u0011awn\u001a\u0011\t\u0015\u0005=\u0016\u0011\u0012b\u0001\n\u0013\t\t,\u0001\u0006NCJ\\WM\u001d*feJ,\"!a-\u0011\t\u0005U\u00161\u0018\b\u0004w\u0006]\u0016bAA]y\u00069Q*Z:tC\u001e,\u0017\u0002BA_\u0003\u007f\u0013AAU3se*\u0019\u0011\u0011\u0018?\t\u0013\u0005\r\u0017\u0011\u0012Q\u0001\n\u0005M\u0016aC'be.,'OU3se\u0002\u0002")
public final class MuxClientNegotiatingSession
extends PushSession<ByteReader, Buf> {
    private final PushChannelHandle<ByteReader, Buf> handle;
    private final short version;
    private final Function1<Option<Seq<Tuple2<Buf, Buf>>>, MuxClientSession> negotiator;
    private final Seq<Tuple2<Buf, Buf>> headers;
    private final String name;
    private final Promise<MuxClientSession> negotiatedSession;
    private final AtomicBoolean startNegotiation;
    private Function1<Message, BoxedUnit> phase;

    public Future<MuxClientSession> negotiate() {
        if (this.startNegotiation.compareAndSet(false, true)) {
            MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().debug("Sending Tinit probe to %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name}));
            this.handle.sendAndForget((Object)Message$.MODULE$.encode(MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$MarkerRerr()));
        } else {
            MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning("Attempted to negotiate multiple times with %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name}));
        }
        return this.negotiatedSession;
    }

    public Future<BoxedUnit> onClose() {
        return this.handle.onClose();
    }

    public Future<BoxedUnit> close(Time deadline) {
        return this.handle.close(deadline);
    }

    public Status status() {
        return this.handle.status();
    }

    public void receive(ByteReader reader) {
        block7: {
            try {
                try {
                    Message message = Message$.MODULE$.decode(reader);
                    if (!this.startNegotiation.get()) {
                        MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning("Received a message from %s before negotiation has started: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name, message}));
                    }
                    this.phase.apply((Object)message);
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option = NonFatal$.MODULE$.unapply(throwable2);
                    if (!option.isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        this.failHandshake(t);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    throw throwable;
                }
            }
            finally {
                reader.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void phaseReceiveMarkerRerr(Message message2) {
        Message message3 = message2;
        if (message3 instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message3;
            int n = rerr.tag();
            String string = rerr.error();
            if (Handshake$.MODULE$.TinitTag() == n) {
                String string2 = Handshake$.MODULE$.CanTinitMsg();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.phase = (Function1 & Serializable & scala.Serializable)message -> {
                        this.phaseReceiveRinit(message);
                        return BoxedUnit.UNIT;
                    };
                    this.handle.sendAndForget((Object)Message$.MODULE$.encode(new Message.Tinit(Handshake$.MODULE$.TinitTag(), this.version, this.headers)));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
            }
        }
        this.finishNegotiation((Option<Seq<Tuple2<Buf, Buf>>>)None$.MODULE$);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void phaseReceiveRinit(Message message) {
        Message message2 = message;
        if (message2 instanceof Message.Rinit) {
            Message.Rinit rinit = (Message.Rinit)message2;
            short v = rinit.version();
            Seq<Tuple2<Buf, Buf>> serverHeaders = rinit.headers();
            if (v == this.version) {
                this.finishNegotiation((Option<Seq<Tuple2<Buf, Buf>>>)new Some(serverHeaders));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (message2 instanceof Message.Rerr) {
            Message.Rerr rerr = (Message.Rerr)message2;
            String msg = rerr.error();
            this.failHandshake((Throwable)Failure$.MODULE$.apply(msg));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid Tinit response from ", ": ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name, message}));
        IllegalStateException exc = new IllegalStateException(msg);
        MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning((Throwable)exc, msg, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
        this.failHandshake(exc);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void finishNegotiation(Option<Seq<Tuple2<Buf, Buf>>> serverHeaders) {
        MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().debug("Init result: %s", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{serverHeaders}));
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (MuxClientSession)((Object)((Object)$this.negotiator.apply((Object)serverHeaders))));
        if (try_ instanceof Return) {
            BoxedUnit boxedUnit;
            Return return_ = (Return)try_;
            MuxClientSession clientSession = (MuxClientSession)((Object)return_.r());
            this.handle.registerSession((PushSession)clientSession);
            if (!this.negotiatedSession.updateIfEmpty((Try)new Return((Object)clientSession))) {
                MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().debug("Finished negotiation with %s but handle already closed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.name}));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable exc = throw_.e();
            MuxClientNegotiatingSession$.MODULE$.com$twitter$finagle$mux$exp$pushsession$MuxClientNegotiatingSession$$log().warning(exc, "Mux negotiation failed.", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.failHandshake(exc);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    private void failHandshake(Throwable exc) {
        block0: {
            if (!this.negotiatedSession.updateIfEmpty((Try)new Throw(exc))) break block0;
            this.handle.close();
        }
    }

    public static final /* synthetic */ void $anonfun$new$1(MuxClientNegotiatingSession $this, Try reason) {
        Object object;
        Try try_ = reason;
        if (try_ instanceof Return) {
            object = new ChannelClosedException($this.handle.remoteAddress());
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable t = throw_.e();
            object = t;
        } else {
            throw new MatchError((Object)try_);
        }
        ChannelClosedException exc = object;
        $this.failHandshake((Throwable)exc);
    }

    public MuxClientNegotiatingSession(PushChannelHandle<ByteReader, Buf> handle, short version, Function1<Option<Seq<Tuple2<Buf, Buf>>>, MuxClientSession> negotiator, Seq<Tuple2<Buf, Buf>> headers, String name) {
        this.handle = handle;
        this.version = version;
        this.negotiator = negotiator;
        this.headers = headers;
        this.name = name;
        super(handle);
        this.negotiatedSession = Promise$.MODULE$.apply();
        this.startNegotiation = new AtomicBoolean(false);
        this.phase = (Function1 & Serializable & scala.Serializable)message -> {
            this.phaseReceiveMarkerRerr(message);
            return BoxedUnit.UNIT;
        };
        handle.onClose().respond((Function1 & Serializable & scala.Serializable)reason -> {
            MuxClientNegotiatingSession.$anonfun$new$1(this, reason);
            return BoxedUnit.UNIT;
        });
    }
}

