/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux.exp.pushsession;

import com.twitter.finagle.mux.exp.pushsession.MuxMessageDecoder;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.finagle.mux.transport.Message$Tags$;
import com.twitter.finagle.mux.transport.Message$Types$;
import com.twitter.finagle.stats.Gauge;
import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.stats.Verbosity$;
import com.twitter.io.Buf;
import com.twitter.io.ByteReader;
import com.twitter.io.ByteReader$;
import io.netty.util.collection.IntObjectHashMap;
import java.io.Serializable;
import scala.Function0;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001%4A!\u0001\u0002\u0005\u001f\tyaI]1h[\u0016tG\u000fR3d_\u0012,'O\u0003\u0002\u0004\t\u0005Y\u0001/^:ig\u0016\u001c8/[8o\u0015\t)a!A\u0002fqBT!a\u0002\u0005\u0002\u00075,\bP\u0003\u0002\n\u0015\u00059a-\u001b8bO2,'BA\u0006\r\u0003\u001d!x/\u001b;uKJT\u0011!D\u0001\u0004G>l7\u0001A\n\u0003\u0001A\u0001\"!\u0005\n\u000e\u0003\tI!a\u0005\u0002\u0003#5+\b0T3tg\u0006<W\rR3d_\u0012,'\u000f\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u00035\u0019H/\u0019;t%\u0016\u001cW-\u001b<feB\u0011qCG\u0007\u00021)\u0011\u0011\u0004C\u0001\u0006gR\fGo]\u0005\u00037a\u0011Qb\u0015;biN\u0014VmY3jm\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\b\u0006\u0002 AA\u0011\u0011\u0003\u0001\u0005\u0006+q\u0001\rA\u0006\u0005\u0007E\u0001\u0001\u000b\u0011B\u0012\u0002\u0013\u0019\u0014\u0018mZ7f]R\u001c\bc\u0001\u0013._5\tQE\u0003\u0002'O\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005!J\u0013\u0001B;uS2T!AK\u0016\u0002\u000b9,G\u000f^=\u000b\u00031\n!![8\n\u00059*#\u0001E%oi>\u0013'.Z2u\u0011\u0006\u001c\b.T1q!\t\u0001$'D\u00012\u0015\ta#\"\u0003\u00024c\t\u0019!)\u001e4\t\rU\u0002\u0001\u0015!\u00037\u0003=\u0011X-\u00193TiJ,\u0017-\u001c\"zi\u0016\u001c\bCA\f8\u0013\tA\u0004D\u0001\u0003Ti\u0006$\bB\u0002\u001e\u0001A\u0003%1(\u0001\tsK\u0006$7\u000b\u001e:fC6\u001cx)Y;hKB\u0011q\u0003P\u0005\u0003{a\u0011QaR1vO\u0016DQa\u0010\u0001\u0005\u0012\u0001\u000b\u0001\u0002Z8EK\u000e|G-\u001a\u000b\u0003\u0003\u001e\u0003\"AQ#\u000e\u0003\rS!\u0001\u0012\u0004\u0002\u0013Q\u0014\u0018M\\:q_J$\u0018B\u0001$D\u0005\u001diUm]:bO\u0016DQ\u0001\u0013 A\u0002%\u000baA]3bI\u0016\u0014\bC\u0001\u0019K\u0013\tY\u0015G\u0001\u0006CsR,'+Z1eKJDa!\u0014\u0001!\n\u0013q\u0015!\u00037bgR\u001c\u0005.\u001e8l)\u0011\tuj\u0016/\t\u000bAc\u0005\u0019A)\u0002\u0007Q\fw\r\u0005\u0002S+6\t1KC\u0001U\u0003\u0015\u00198-\u00197b\u0013\t16KA\u0002J]RDQ\u0001\u0017'A\u0002e\u000b1\u0001^=q!\t\u0011&,\u0003\u0002\\'\n!!)\u001f;f\u0011\u0015AE\n1\u0001J\u0011\u0019q\u0006\u0001)C\u0005?\u0006\u0011\u0012mY2v[Vd\u0017\r^3Ge\u0006<W.\u001a8u)\r\u00017\r\u001a\t\u0003%\u0006L!AY*\u0003\tUs\u0017\u000e\u001e\u0005\u0006!v\u0003\r!\u0015\u0005\u0006\u0011v\u0003\r!\u0013\u0005\u0007M\u0002\u0001K\u0011B4\u0002\r\u001d,GoS3z)\t\t\u0006\u000eC\u0003QK\u0002\u0007\u0011\u000b")
public class FragmentDecoder
extends MuxMessageDecoder {
    private final IntObjectHashMap<Buf> fragments = new IntObjectHashMap();
    private final Stat readStreamBytes;
    private final Gauge readStreamsGauge;

    @Override
    public Message doDecode(ByteReader reader) {
        Message message;
        this.readStreamBytes.add((float)reader.remaining());
        int header = reader.readIntBE();
        byte typ = Message$Tags$.MODULE$.extractType(header);
        int tag = Message$Tags$.MODULE$.extractTag(header);
        if (!Message$Tags$.MODULE$.isFragment(tag)) {
            message = this.lastChunk(tag, typ, reader);
        } else {
            this.accumulateFragment(tag, reader);
            message = null;
        }
        return message;
    }

    private Message lastChunk(int tag, byte typ, ByteReader reader) {
        Message message;
        if (Message$Types$.MODULE$.isDiscard(typ)) {
            int n;
            Message msg = Message$.MODULE$.decodeMessageBody(typ, tag, reader);
            Message message2 = msg;
            if (message2 instanceof Message.Tdiscarded) {
                int tagToRemove;
                Message.Tdiscarded tdiscarded = (Message.Tdiscarded)message2;
                n = tagToRemove = tdiscarded.which();
            } else {
                n = tag;
            }
            int tagToRemove = n;
            this.fragments.remove(this.getKey(tagToRemove));
            message = msg;
        } else {
            Buf existing = (Buf)this.fragments.remove(this.getKey(tag));
            ByteReader fullMessageBody = existing == null ? reader : ByteReader$.MODULE$.apply(existing.concat(reader.readAll()));
            message = Message$.MODULE$.decodeMessageBody(typ, tag, fullMessageBody);
        }
        return message;
    }

    private void accumulateFragment(int tag, ByteReader reader) {
        int key = this.getKey(tag);
        Buf tail = reader.readAll();
        Buf head = (Buf)this.fragments.get(key);
        Buf chunk = head != null ? head.concat(tail) : tail;
        this.fragments.put(key, (Object)chunk);
    }

    private int getKey(int tag) {
        return Message$Tags$.MODULE$.setMsb(tag);
    }

    public FragmentDecoder(StatsReceiver statsReceiver) {
        this.readStreamBytes = statsReceiver.stat(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"read_stream_bytes"}));
        this.readStreamsGauge = statsReceiver.addGauge(Verbosity$.MODULE$.Debug(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"pending_read_streams"}), (Function0)(JFunction0.mcF.sp & Serializable & scala.Serializable)() -> $this.fragments.size());
    }
}

