/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.mux;

import com.twitter.finagle.CancelledRequestException;
import com.twitter.finagle.ChannelClosedException;
import com.twitter.finagle.Service;
import com.twitter.finagle.context.Contexts$;
import com.twitter.finagle.context.RemoteInfo;
import com.twitter.finagle.mux.ClientDiscardedRequestException;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.ServerDispatcher$;
import com.twitter.finagle.mux.ServerDispatcher$State$;
import com.twitter.finagle.mux.Tracker;
import com.twitter.finagle.mux.gracefulShutdownEnabled$;
import com.twitter.finagle.mux.lease.exp.Lessee;
import com.twitter.finagle.mux.lease.exp.Lessor;
import com.twitter.finagle.mux.lease.exp.nackOnExpiredLease$;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$Tlease$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.tracing.Trace$;
import com.twitter.finagle.tracing.Tracer;
import com.twitter.finagle.transport.Transport;
import com.twitter.finagle.transport.Transport$;
import com.twitter.finagle.util.DefaultTimer$;
import com.twitter.io.Buf;
import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import com.twitter.util.Future$;
import com.twitter.util.Local$;
import com.twitter.util.Return;
import com.twitter.util.Stopwatch$;
import com.twitter.util.Throw;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import com.twitter.util.TimeLike;
import com.twitter.util.Timer;
import com.twitter.util.Try;
import java.io.Serializable;
import java.security.cert.Certificate;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=xAB\u0001\u0003\u0011\u0003!!\"\u0001\tTKJ4XM\u001d#jgB\fGo\u00195fe*\u00111\u0001B\u0001\u0004[VD(BA\u0003\u0007\u0003\u001d1\u0017N\\1hY\u0016T!a\u0002\u0005\u0002\u000fQ<\u0018\u000e\u001e;fe*\t\u0011\"A\u0002d_6\u0004\"a\u0003\u0007\u000e\u0003\t1a!\u0004\u0002\t\u0002\u0011q!\u0001E*feZ,'\u000fR5ta\u0006$8\r[3s'\taq\u0002\u0005\u0002\u0011'5\t\u0011CC\u0001\u0013\u0003\u0015\u00198-\u00197b\u0013\t!\u0012C\u0001\u0004B]f\u0014VM\u001a\u0005\u0006-1!\t\u0001G\u0001\u0007y%t\u0017\u000e\u001e \u0004\u0001Q\t!\u0002C\u0003\u001b\u0019\u0011\u00051$\u0001\noK^\u0014V-];fgR\u0014Vm\u001d9p]N,Gc\u0003\u000f\u0002P\u0006E\u0017\u0011]Ar\u0003K\u0004\"aC\u000f\u0007\u000b5\u0011\u0001\u0001\u0002\u0010\u0014\tuyq$\n\t\u0003A\rj\u0011!\t\u0006\u0003E\u0019\tA!\u001e;jY&\u0011A%\t\u0002\t\u00072|7/\u00192mKB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0004Kb\u0004(B\u0001\u0016\u0003\u0003\u0015aW-Y:f\u0013\tasE\u0001\u0004MKN\u001cX-\u001a\u0005\t]u\u0011\t\u0011)A\u0005_\u0005)AO]1ogB!\u0001gM\u001b6\u001b\u0005\t$B\u0001\u001a\u0005\u0003%!(/\u00198ta>\u0014H/\u0003\u00025c\tIAK]1ogB|'\u000f\u001e\t\u0003maj\u0011a\u000e\u0006\u0003e\tI!!O\u001c\u0003\u000f5+7o]1hK\"A1(\bB\u0001B\u0003%A(A\u0004tKJ4\u0018nY3\u0011\turT'N\u0007\u0002\t%\u0011q\b\u0002\u0002\b'\u0016\u0014h/[2f\u0011!\tUD!A!\u0002\u0013\u0011\u0015A\u00027fgN|'\u000f\u0005\u0002'\u0007&\u0011Ai\n\u0002\u0007\u0019\u0016\u001c8o\u001c:\t\u0011\u0019k\"\u0011!Q\u0001\n\u001d\u000ba\u0001\u001e:bG\u0016\u0014\bC\u0001%L\u001b\u0005I%B\u0001&\u0005\u0003\u001d!(/Y2j]\u001eL!\u0001T%\u0003\rQ\u0013\u0018mY3s\u0011!qUD!A!\u0002\u0013y\u0015!D:uCR\u001c(+Z2fSZ,'\u000f\u0005\u0002Q'6\t\u0011K\u0003\u0002S\t\u0005)1\u000f^1ug&\u0011A+\u0015\u0002\u000e'R\fGo\u001d*fG\u0016Lg/\u001a:\t\u000bYiB\u0011\u0001,\u0015\rq9\u0006,\u0017.\\\u0011\u0015qS\u000b1\u00010\u0011\u0015YT\u000b1\u0001=\u0011\u0015\tU\u000b1\u0001C\u0011\u00151U\u000b1\u0001H\u0011\u0015qU\u000b1\u0001P\u0011\u0019iV\u0004)A\u0006=\u0006Y\u0011N\u001c6fGR$\u0016.\\3s\u001d\ty\u0016-D\u0001a\u0015\t\u0011C!\u0003\u0002cA\u0006aA)\u001a4bk2$H+[7fe\"1A-\bQ\u0001\n\u0015\fq\u0001\u001e:bG.,'\u000fE\u0002\fMVJ!a\u001a\u0002\u0003\u000fQ\u0013\u0018mY6fe\"1\u0011.\bQ\u0001\n)\f1\u0001\\8h!\tY\u0017/D\u0001m\u0015\tig.A\u0004m_\u001e<\u0017N\\4\u000b\u0005\tz'\"\u00019\u0002\t)\fg/Y\u0005\u0003e2\u0014a\u0001T8hO\u0016\u0014\bB\u0002;\u001eA\u0003%Q/A\nekBd\u0017nY1uKR\u000bwmQ8v]R,'\u000f\u0005\u0002Qm&\u0011q/\u0015\u0002\b\u0007>,h\u000e^3s\u0011\u0019IX\u0004)A\u0005k\u00069rN\u001d9iC:,G\r\u00163jg\u000e\f'\u000fZ\"pk:$XM\u001d\u0005\u0007wv\u0001\u000b\u0011B;\u0002!1,w-Y2z%\u0016\f8i\\;oi\u0016\u0014\bBB?\u001eA\u0003%a0A\u0003ti\u0006$X\rE\u0003\u0000\u0003\u0013\ti!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u0019\tGo\\7jG*\u0019\u0011q\u00018\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002\f\u0005\u0005!aD!u_6L7MU3gKJ,gnY3\u0011\t\u0005=\u0011Q\u0007\b\u0005\u0003#\t\u0019B\u0004\u0002\f\u0001\u001d9\u0011Q\u0003\u0007\t\u0002\u0005]\u0011!B*uCR,\u0007\u0003BA\r\u00037i\u0011\u0001\u0004\u0004\b\u0003;a\u0001\u0012AA\u0010\u0005\u0015\u0019F/\u0019;f'\u0011\tY\"!\t\u0011\u0007A\t\u0019#C\u0002\u0002&E\u00111\"\u00128v[\u0016\u0014\u0018\r^5p]\"9a#a\u0007\u0005\u0002\u0005%BCAA\f\u0011)\ti#a\u0007C\u0002\u0013\u0005\u0011qF\u0001\u0005\u001fB,g.\u0006\u0002\u00022A!\u00111GA\u001b\u001b\t\tY\"\u0003\u0003\u00028\u0005\r\"!\u0002,bYV,\u0007\"CA\u001e\u00037\u0001\u000b\u0011BA\u0019\u0003\u0015y\u0005/\u001a8!\u0011)\ty$a\u0007C\u0002\u0013\u0005\u0011qF\u0001\t\tJ\f\u0017N\\5oO\"I\u00111IA\u000eA\u0003%\u0011\u0011G\u0001\n\tJ\f\u0017N\\5oO\u0002B!\"a\u0012\u0002\u001c\t\u0007I\u0011AA\u0018\u0003\u0019\u0019En\\:fI\"I\u00111JA\u000eA\u0003%\u0011\u0011G\u0001\b\u00072|7/\u001a3!\u0011!\ty%\bQ!\n\u0005E\u0013a\u00047fCN,W\t\u001f9je\u0006$\u0018n\u001c8\u0011\u0007\u0001\n\u0019&C\u0002\u0002V\u0005\u0012A\u0001V5nK\"\"\u0011QJA-!\r\u0001\u00121L\u0005\u0004\u0003;\n\"\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0011\u0005\u0005T\u0004)C\u0005\u0003G\nQa\u001e:ji\u0016$B!!\u001a\u0002rA)\u0001%a\u001a\u0002l%\u0019\u0011\u0011N\u0011\u0003\r\u0019+H/\u001e:f!\r\u0001\u0012QN\u0005\u0004\u0003_\n\"\u0001B+oSRDq!a\u001d\u0002`\u0001\u0007Q'A\u0001n\u0011!\t9(\bQ\u0005\n\u0005e\u0014a\u00058bG.dU-Y:f\u000bb\u0004\u0018N]1uS>tWCAA>!\r\u0001\u0012QP\u0005\u0004\u0003\u007f\n\"a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u0007k\u0002\u0015\"\u0003\u0002z\u0005Q1\u000f[8vY\u0012t\u0015mY6\t\u0011\u0005\u001dU\u0004)C\u0005\u0003\u0013\u000bq\u0001\u001d:pG\u0016\u001c8\u000f\u0006\u0003\u0002l\u0005-\u0005bBA:\u0003\u000b\u0003\r!\u000e\u0005\t\u0003\u001fk\u0002\u0015\"\u0003\u0002\u0012\u0006!An\\8q)\t\tY\u0007\u0003\u0005\u0002\u0016v\u0001K\u0011BAL\u0003\u0019A\u0017M\\4vaR!\u0011QMAM\u0011!\tY*a%A\u0002\u0005E\u0013\u0001\u00033fC\u0012d\u0017N\\3)\t\u0005M\u0015q\u0014\t\u0005\u0003C\u000b9+\u0004\u0002\u0002$*\u0019\u0011QU\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002*\u0006\r&a\u0002;bS2\u0014Xm\u0019\u0005\b\u0003[kB\u0011AAX\u0003\u0015\u0019Gn\\:f)\u0011\t)'!-\t\u0011\u0005m\u00151\u0016a\u0001\u0003#Bq!!.\u001e\t\u0003\t9,A\u0003jgN,X\r\u0006\u0003\u0002l\u0005e\u0006\u0002CA^\u0003g\u0003\r!!0\u0002\u000f!|w\u000f\\8oOB\u0019\u0001%a0\n\u0007\u0005\u0005\u0017E\u0001\u0005EkJ\fG/[8o\u0011\u001d\t)-\bC\u0001\u0003\u000f\f\u0001B\u001c9f]\u0012Lgn\u001a\u000b\u0003\u0003\u0013\u00042\u0001EAf\u0013\r\ti-\u0005\u0002\u0004\u0013:$\b\"\u0002\u0018\u001a\u0001\u0004y\u0003BB\u001e\u001a\u0001\u0004\t\u0019\u000e\u0005\u0004>}\u0005U\u00171\u001c\t\u0004\u0017\u0005]\u0017bAAm\u0005\t9!+Z9vKN$\bcA\u0006\u0002^&\u0019\u0011q\u001c\u0002\u0003\u0011I+7\u000f]8og\u0016DQ!Q\rA\u0002\tCQAR\rA\u0002\u001dCQAT\rA\u0002=CaA\u0007\u0007\u0005\u0002\u0005%H#\u0002\u000f\u0002l\u00065\bB\u0002\u0018\u0002h\u0002\u0007q\u0006C\u0004<\u0003O\u0004\r!a5")
public class ServerDispatcher
implements Closable,
Lessee {
    private final Transport<Message, Message> trans;
    private final Service<Message, Message> service;
    private final Lessor lessor;
    private final Tracer tracer;
    private final StatsReceiver statsReceiver;
    private final DefaultTimer$ injectTimer;
    private final Tracker<Message> tracker;
    private final Logger log;
    private final Counter duplicateTagCounter;
    private final Counter orphanedTdiscardCounter;
    private final Counter legacyReqCounter;
    private final AtomicReference<Enumeration.Value> state;
    private volatile Time leaseExpiration;

    public static ServerDispatcher newRequestResponse(Transport<Message, Message> transport, Service<Request, Response> service) {
        return ServerDispatcher$.MODULE$.newRequestResponse(transport, service);
    }

    public static ServerDispatcher newRequestResponse(Transport<Message, Message> transport, Service<Request, Response> service, Lessor lessor, Tracer tracer, StatsReceiver statsReceiver) {
        return ServerDispatcher$.MODULE$.newRequestResponse(transport, service, lessor, tracer, statsReceiver);
    }

    public final Future<BoxedUnit> close() {
        return Closable.close$((Closable)this);
    }

    public Future<BoxedUnit> close(Duration after) {
        return Closable.close$((Closable)this, (Duration)after);
    }

    private Future<BoxedUnit> write(Message m) {
        return this.trans.write((Object)m);
    }

    private boolean nackLeaseExpiration() {
        return BoxesRunTime.unboxToBoolean((Object)nackOnExpiredLease$.MODULE$.apply()) && this.leaseExpiration.$less$eq((Object)Time$.MODULE$.now());
    }

    private boolean shouldNack() {
        return this.tracker.isDraining() || this.nackLeaseExpiration();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void process(Message m) {
        Message.Rdrain rdrain;
        int n;
        Message message;
        boolean bl;
        if (m instanceof Message.Treq) {
            this.legacyReqCounter.incr();
        }
        if ((bl = (message = m) instanceof Message.Tdispatch ? true : message instanceof Message.Treq) && !this.shouldNack()) {
            BoxedUnit boxedUnit;
            this.lessor.observeArrival();
            Function0 elapsed = Stopwatch$.MODULE$.start();
            Function1 & Serializable & scala.Serializable reply = (Function1 & Serializable & scala.Serializable)x0$1 -> {
                Future<BoxedUnit> future;
                Try try_ = x0$1;
                if (try_ instanceof Return) {
                    Return return_ = (Return)try_;
                    Message rep = (Message)return_.r();
                    $this.lessor.observe((Duration)elapsed.apply());
                    future = this.write(rep);
                } else if (try_ instanceof Throw) {
                    Throw throw_ = (Throw)try_;
                    Throwable exc = throw_.e();
                    $this.log.log(Level.WARNING, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error processing message ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{m})), exc);
                    future = this.write(new Message.Rerr(m.tag(), exc.toString()));
                } else {
                    throw new MatchError((Object)try_);
                }
                return future;
            };
            if (!this.tracker.isTracking(m.tag())) {
                this.tracker.track(m.tag(), (Future<Message>)this.service.apply((Object)m), (Function1<Try<Message>, Future<BoxedUnit>>)reply);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.log.fine(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Received duplicate tag ", " from client ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)m.tag()), this.trans.remoteAddress()})));
                this.duplicateTagCounter.incr();
                this.service.apply((Object)m).transform((Function1)reply);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
            return;
        }
        if (message instanceof Message.Tdispatch) {
            Message.Tdispatch tdispatch = (Message.Tdispatch)message;
            this.write(new Message.RdispatchNack(tdispatch.tag(), (Seq<Tuple2<Buf, Buf>>)Nil$.MODULE$));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message instanceof Message.Treq) {
            Message.Treq treq = (Message.Treq)message;
            this.write(new Message.RreqNack(treq.tag()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message instanceof Message.Tping) {
            this.service.apply((Object)m).respond((Function1 & Serializable & scala.Serializable)x0$2 -> {
                ServerDispatcher.$anonfun$process$2(this, m, x0$2);
                return BoxedUnit.UNIT;
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message instanceof Message.Tdiscarded) {
            Message.Tdiscarded tdiscarded = (Message.Tdiscarded)message;
            int tag = tdiscarded.which();
            String why = tdiscarded.why();
            Option<Future<BoxedUnit>> option = this.tracker.get(tag);
            if (option instanceof Some) {
                Some some = (Some)option;
                Future reply = (Future)some.value();
                reply.raise((Throwable)new ClientDiscardedRequestException(why));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                this.orphanedTdiscardCounter.incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (message instanceof Message.Rdrain && 1 == (n = (rdrain = (Message.Rdrain)message).tag())) {
            Enumeration.Value value = this.state.get();
            Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Draining();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                this.tracker.drain();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (message == null) throw new MatchError((Object)message);
        Message message2 = message;
        Message.Rerr rerr = new Message.Rerr(message2.tag(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected mux message type ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)message2.typ())})));
        this.write(rerr);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void loop() {
        Future$.MODULE$.each((Function0 & Serializable & scala.Serializable)() -> $this.trans.read(), (Function1 & Serializable & scala.Serializable)msg -> {
            ServerDispatcher.$anonfun$loop$2(this, msg);
            return BoxedUnit.UNIT;
        }).ensure((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.hangup(Time$.MODULE$.now()));
    }

    private Future<BoxedUnit> hangup(Time deadline) {
        Future future;
        block4: {
            Enumeration.Value value;
            block5: {
                do {
                    boolean bl;
                    value = this.state.get();
                    Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Closed();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        future = Future$.MODULE$.Done();
                        break block4;
                    }
                    Enumeration.Value value4 = ServerDispatcher$State$.MODULE$.Draining();
                    Enumeration.Value value5 = value;
                    if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                        bl = true;
                    } else {
                        Enumeration.Value value6 = ServerDispatcher$State$.MODULE$.Open();
                        Enumeration.Value value7 = value;
                        bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
                    }
                    if (!bl) break block5;
                } while (!this.state.compareAndSet(value, ServerDispatcher$State$.MODULE$.Closed()));
                future = this.trans.close(deadline);
                break block4;
            }
            throw new MatchError((Object)value);
        }
        return future;
    }

    public Future<BoxedUnit> close(Time deadline) {
        if (!this.state.compareAndSet(ServerDispatcher$State$.MODULE$.Open(), ServerDispatcher$State$.MODULE$.Draining())) {
            return this.trans.onClose().unit();
        }
        if (!BoxesRunTime.unboxToBoolean((Object)gracefulShutdownEnabled$.MODULE$.apply())) {
            return this.hangup(deadline);
        }
        this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"draining"})).incr();
        Future done = this.write(new Message.Tdrain(1)).before((Function0 & Serializable & scala.Serializable)() -> $this.tracker.drained().by(deadline, (Timer)$this.injectTimer), Predef$.MODULE$.$conforms()).before((Function0 & Serializable & scala.Serializable)() -> $this.trans.close(deadline), Predef$.MODULE$.$conforms());
        return done.transform((Function1 & Serializable & scala.Serializable)x0$3 -> {
            boolean bl = false;
            Throw throw_ = null;
            Try try_ = x0$3;
            if (try_ instanceof Return) {
                $this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"drained"})).incr();
                return Future$.MODULE$.Done();
            }
            if (try_ instanceof Throw) {
                bl = true;
                throw_ = (Throw)try_;
                if (throw_.e() instanceof ChannelClosedException) {
                    return Future$.MODULE$.Done();
                }
            }
            if (!bl) throw new MatchError((Object)try_);
            return this.hangup(deadline);
        });
    }

    @Override
    public void issue(Duration howlong) {
        Predef$.MODULE$.require(howlong.$greater$eq((Object)Message$Tlease$.MODULE$.MinLease()));
        ServerDispatcher serverDispatcher = this;
        synchronized (serverDispatcher) {
            this.leaseExpiration = (Time)Time$.MODULE$.now().$plus(howlong);
            this.write(Message$Tlease$.MODULE$.apply((Duration)howlong.min((TimeLike)Message$Tlease$.MODULE$.MaxLease())));
        }
    }

    @Override
    public int npending() {
        return this.tracker.npending();
    }

    public static final /* synthetic */ void $anonfun$process$2(ServerDispatcher $this, Message m$1, Try x0$2) {
        Try try_ = x0$2;
        if (try_ instanceof Return) {
            Return return_ = (Return)try_;
            Message rep = (Message)return_.r();
            $this.write(rep);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Throw) {
            Throw throw_ = (Throw)try_;
            Throwable exc = throw_.e();
            $this.write(new Message.Rerr(m$1.tag(), exc.toString()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ void $anonfun$loop$2(ServerDispatcher $this, Message msg) {
        Option[] save = Local$.MODULE$.save();
        $this.process(msg);
        Local$.MODULE$.restore(save);
    }

    public static final /* synthetic */ void $anonfun$new$5(ServerDispatcher $this, Try res) {
        Throwable throwable;
        Try try_ = res;
        if (try_ instanceof Return) {
            Throwable exc;
            Return return_ = (Return)try_;
            throwable = exc = (Throwable)return_.r();
        } else if (try_ instanceof Throw) {
            Throwable exc;
            Throw throw_ = (Throw)try_;
            throwable = exc = throw_.e();
        } else {
            throw new MatchError((Object)try_);
        }
        Throwable exc = throwable;
        CancelledRequestException cancelledExc = new CancelledRequestException(exc);
        $this.tracker.tags().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tag -> $this.tracker.get(tag).foreach((Function1 & Serializable & scala.Serializable)f -> {
            f.raise((Throwable)cancelledExc);
            return BoxedUnit.UNIT;
        }));
        $this.service.close();
        $this.lessor.unregister($this);
        Enumeration.Value value = $this.state.get();
        Enumeration.Value value2 = ServerDispatcher$State$.MODULE$.Open();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            $this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"clienthangup"})).incr();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl;
            Enumeration.Value value4 = ServerDispatcher$State$.MODULE$.Draining();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = ServerDispatcher$State$.MODULE$.Closed();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
            if (bl) {
                $this.statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"serverhangup"})).incr();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)value);
            }
        }
    }

    public ServerDispatcher(Transport<Message, Message> trans, Service<Message, Message> service, Lessor lessor, Tracer tracer, StatsReceiver statsReceiver) {
        this.trans = trans;
        this.service = service;
        this.lessor = lessor;
        this.tracer = tracer;
        this.statsReceiver = statsReceiver;
        Closable.$init$((Closable)this);
        this.injectTimer = DefaultTimer$.MODULE$;
        this.tracker = new Tracker();
        this.log = Logger.getLogger(this.getClass().getName());
        this.duplicateTagCounter = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"duplicate_tag"}));
        this.orphanedTdiscardCounter = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"orphaned_tdiscard"}));
        this.legacyReqCounter = statsReceiver.counter((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"legacy_req"}));
        this.state = new AtomicReference<Enumeration.Value>(ServerDispatcher$State$.MODULE$.Open());
        this.leaseExpiration = Time$.MODULE$.Top();
        lessor.register(this);
        Local$.MODULE$.letClear((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Trace$.MODULE$.letTracer($this.tracer, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> Contexts$.MODULE$.local().let(RemoteInfo.Upstream$.MODULE$.AddressCtx(), (Object)$this.trans.remoteAddress(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Option option = $this.trans.peerCertificate();
            if (None$.MODULE$.equals(option)) {
                this.loop();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                Some some = (Some)option;
                Certificate cert = (Certificate)some.value();
                BoxedUnit boxedUnit = (BoxedUnit)Contexts$.MODULE$.local().let(Transport$.MODULE$.peerCertCtx(), (Object)cert, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.loop());
            } else {
                throw new MatchError((Object)option);
            }
        })));
        trans.onClose().respond((Function1 & Serializable & scala.Serializable)res -> {
            ServerDispatcher.$anonfun$new$5(this, res);
            return BoxedUnit.UNIT;
        });
    }
}

