/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle;

import com.twitter.finagle.Client;
import com.twitter.finagle.ListeningServer;
import com.twitter.finagle.Mux;
import com.twitter.finagle.Mux$Client$;
import com.twitter.finagle.Mux$Server$;
import com.twitter.finagle.Name;
import com.twitter.finagle.Server;
import com.twitter.finagle.Service;
import com.twitter.finagle.ServiceFactory;
import com.twitter.finagle.mux.Handshake$;
import com.twitter.finagle.mux.Request;
import com.twitter.finagle.mux.Response;
import com.twitter.finagle.mux.transport.IncompatibleNegotiationException;
import com.twitter.finagle.mux.transport.Message;
import com.twitter.finagle.mux.transport.Message$;
import com.twitter.finagle.mux.transport.MuxFramer$;
import com.twitter.finagle.mux.transport.MuxFramer$Header$;
import com.twitter.finagle.mux.transport.OpportunisticTls;
import com.twitter.finagle.mux.transport.OpportunisticTls$;
import com.twitter.finagle.mux.transport.OpportunisticTls$Header$;
import com.twitter.finagle.mux.transport.OpportunisticTls$Off$;
import com.twitter.finagle.stats.Counter;
import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.finagle.transport.Transport;
import com.twitter.io.Buf;
import com.twitter.logging.Level;
import com.twitter.logging.Logger;
import com.twitter.logging.Logger$;
import com.twitter.util.StorageUnit;
import java.io.Serializable;
import java.net.SocketAddress;
import java.util.logging.Level;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Mux$
implements Client<Request, Response>,
Server<Request, Response> {
    public static Mux$ MODULE$;
    private final Logger com$twitter$finagle$Mux$$log;
    private final short LatestVersion;

    static {
        new Mux$();
    }

    public final ListeningServer serve(SocketAddress addr, Service<Request, Response> service) {
        return Server.serve$((Server)this, (SocketAddress)addr, service);
    }

    public final ListeningServer serve(String addr, ServiceFactory<Request, Response> service) {
        return Server.serve$((Server)this, (String)addr, service);
    }

    public final ListeningServer serve(String addr, Service<Request, Response> service) {
        return Server.serve$((Server)this, (String)addr, service);
    }

    public ListeningServer serveAndAnnounce(String name, SocketAddress addr, ServiceFactory<Request, Response> service) {
        return Server.serveAndAnnounce$((Server)this, (String)name, (SocketAddress)addr, service);
    }

    public ListeningServer serveAndAnnounce(String name, SocketAddress addr, Service<Request, Response> service) {
        return Server.serveAndAnnounce$((Server)this, (String)name, (SocketAddress)addr, service);
    }

    public ListeningServer serveAndAnnounce(String name, String addr, ServiceFactory<Request, Response> service) {
        return Server.serveAndAnnounce$((Server)this, (String)name, (String)addr, service);
    }

    public ListeningServer serveAndAnnounce(String name, String addr, Service<Request, Response> service) {
        return Server.serveAndAnnounce$((Server)this, (String)name, (String)addr, service);
    }

    public ListeningServer serveAndAnnounce(String name, ServiceFactory<Request, Response> service) {
        return Server.serveAndAnnounce$((Server)this, (String)name, service);
    }

    public ListeningServer serveAndAnnounce(String name, Service<Request, Response> service) {
        return Server.serveAndAnnounce$((Server)this, (String)name, service);
    }

    public final Service<Request, Response> newService(String dest) {
        return Client.newService$((Client)this, (String)dest);
    }

    public final Service<Request, Response> newService(String dest, String label) {
        return Client.newService$((Client)this, (String)dest, (String)label);
    }

    public final ServiceFactory<Request, Response> newClient(String dest) {
        return Client.newClient$((Client)this, (String)dest);
    }

    public final ServiceFactory<Request, Response> newClient(String dest, String label) {
        return Client.newClient$((Client)this, (String)dest, (String)label);
    }

    public Logger com$twitter$finagle$Mux$$log() {
        return this.com$twitter$finagle$Mux$$log;
    }

    public short LatestVersion() {
        return this.LatestVersion;
    }

    public Function2<Option<Seq<Tuple2<Buf, Buf>>>, Transport<Buf, Buf>, Transport<Message, Message>> negotiate(StorageUnit maxFrameSize, StatsReceiver statsReceiver, OpportunisticTls.Level localEncryptLevel, Function0<BoxedUnit> turnOnTlsFn, Counter upgrades) {
        return (Function2 & Serializable & scala.Serializable)(optionalPeerHeaders, trans) -> {
            Transport transport;
            OpportunisticTls.Level level;
            Seq peerHeaders = (Seq)optionalPeerHeaders.getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty());
            Option<Buf> option = Handshake$.MODULE$.valueOf(OpportunisticTls$Header$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)peerHeaders);
            if (option instanceof Some) {
                Some some = (Some)option;
                Buf buf2 = (Buf)some.value();
                level = OpportunisticTls$Header$.MODULE$.decodeLevel(buf2);
            } else if (None$.MODULE$.equals(option)) {
                level = OpportunisticTls$Off$.MODULE$;
            } else {
                throw new MatchError(option);
            }
            OpportunisticTls$Off$ remoteEncryptLevel = level;
            try {
                boolean useTls = OpportunisticTls$.MODULE$.negotiate(localEncryptLevel, remoteEncryptLevel);
                if (MODULE$.com$twitter$finagle$Mux$$log().isLoggable((Level)Level.DEBUG$.MODULE$)) {
                    MODULE$.com$twitter$finagle$Mux$$log().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully negotiated TLS with remote peer. Using TLS: ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)useTls)})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"local level: ", ", remote level: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{localEncryptLevel, remoteEncryptLevel})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                }
                if (useTls) {
                    upgrades.incr();
                    turnOnTlsFn.apply$mcV$sp();
                }
            }
            catch (IncompatibleNegotiationException exn) {
                MODULE$.com$twitter$finagle$Mux$$log().fatal((Throwable)exn, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The local peer wanted ", " and the remote peer wanted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{localEncryptLevel})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" ", " which are incompatible."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{remoteEncryptLevel})), (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                throw exn;
            }
            if (optionalPeerHeaders.isEmpty()) {
                transport = trans.map((Function1 & Serializable & scala.Serializable)msg -> Message$.MODULE$.encode((Message)msg), (Function1 & Serializable & scala.Serializable)buf -> Message$.MODULE$.decode((Buf)buf));
            } else {
                StorageUnit local;
                Transport<Message, Message> transport2;
                Some some;
                int remote;
                Option s;
                Option remoteMaxFrameSize = Handshake$.MODULE$.valueOf(MuxFramer$Header$.MODULE$.KeyBuf(), (Seq<Tuple2<Buf, Buf>>)peerHeaders).map((Function1 & Serializable & scala.Serializable)buf -> BoxesRunTime.boxToInteger((int)MuxFramer$Header$.MODULE$.decodeFrameSize(buf)));
                StatsReceiver framerStats = statsReceiver.scope("framer");
                Tuple2 tuple2 = new Tuple2((Object)maxFrameSize, (Object)remoteMaxFrameSize);
                if (tuple2 != null && (s = (Option)tuple2._2()) instanceof Some && (remote = BoxesRunTime.unboxToInt((Object)(some = (Some)s).value())) < Integer.MAX_VALUE) {
                    transport2 = MuxFramer$.MODULE$.apply((Transport<Buf, Buf>)trans, (Option<Object>)some, framerStats);
                } else if (tuple2 != null && (local = (StorageUnit)tuple2._1()).inBytes() < Integer.MAX_VALUE) {
                    transport2 = MuxFramer$.MODULE$.apply((Transport<Buf, Buf>)trans, (Option<Object>)None$.MODULE$, framerStats);
                } else if (tuple2 != null) {
                    transport2 = trans.map((Function1 & Serializable & scala.Serializable)msg -> Message$.MODULE$.encode((Message)msg), (Function1 & Serializable & scala.Serializable)buf -> Message$.MODULE$.decode((Buf)buf));
                } else {
                    throw new MatchError((Object)tuple2);
                }
                transport = transport2;
            }
            return transport;
        };
    }

    public Mux.Client client() {
        return new Mux.Client(Mux$Client$.MODULE$.apply$default$1(), Mux$Client$.MODULE$.apply$default$2());
    }

    public Service<Request, Response> newService(Name dest, String label) {
        return this.client().newService(dest, label);
    }

    public ServiceFactory<Request, Response> newClient(Name dest, String label) {
        return this.client().newClient(dest, label);
    }

    public Mux.Server server() {
        return new Mux.Server(Mux$Server$.MODULE$.apply$default$1(), Mux$Server$.MODULE$.apply$default$2());
    }

    public ListeningServer serve(SocketAddress addr, ServiceFactory<Request, Response> service) {
        return this.server().serve(addr, service);
    }

    private Mux$() {
        MODULE$ = this;
        Client.$init$((Client)this);
        Server.$init$((Server)this);
        this.com$twitter$finagle$Mux$$log = Logger$.MODULE$.get();
        this.LatestVersion = 1;
    }
}

