/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.svg;

import com.twelvemonkeys.imageio.plugins.svg.SVGImageReader;
import com.twelvemonkeys.imageio.spi.ProviderInfo;
import com.twelvemonkeys.imageio.util.IIOUtil;
import com.twelvemonkeys.lang.SystemUtil;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIOServiceProvider;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SVGImageReaderSpi
extends ImageReaderSpi {
    private static final boolean SVG_READER_AVAILABLE = SystemUtil.isClassAvailable((String)"com.twelvemonkeys.imageio.plugins.svg.SVGImageReader");

    public SVGImageReaderSpi() {
        this(IIOUtil.getProviderInfo(SVGImageReaderSpi.class));
    }

    private SVGImageReaderSpi(ProviderInfo providerInfo) {
        String[] stringArray;
        String[] stringArray2;
        String[] stringArray3;
        String string = providerInfo.getVendorName();
        String string2 = providerInfo.getVersion();
        if (SVG_READER_AVAILABLE) {
            String[] stringArray4 = new String[2];
            stringArray4[0] = "svg";
            stringArray3 = stringArray4;
            stringArray4[1] = "SVG";
        } else {
            String[] stringArray5 = new String[1];
            stringArray3 = stringArray5;
            stringArray5[0] = "";
        }
        if (SVG_READER_AVAILABLE) {
            String[] stringArray6 = new String[1];
            stringArray2 = stringArray6;
            stringArray6[0] = "svg";
        } else {
            stringArray2 = null;
        }
        if (SVG_READER_AVAILABLE) {
            String[] stringArray7 = new String[4];
            stringArray7[0] = "image/svg";
            stringArray7[1] = "image/x-svg";
            stringArray7[2] = "image/svg+xml";
            stringArray = stringArray7;
            stringArray7[3] = "image/svg-xml";
        } else {
            stringArray = null;
        }
        super(string, string2, stringArray3, stringArray2, stringArray, "com.twelvemonkeys.imageio.plugins.svg.SVGImageReader", new Class[]{ImageInputStream.class}, null, true, null, null, null, null, true, null, null, null, null);
    }

    @Override
    public boolean canDecodeInput(Object object) throws IOException {
        return object instanceof ImageInputStream && SVG_READER_AVAILABLE && SVGImageReaderSpi.canDecode((ImageInputStream)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean canDecode(ImageInputStream imageInputStream) throws IOException {
        try {
            int n;
            imageInputStream.mark();
            while (Character.isWhitespace((char)(n = imageInputStream.read()))) {
            }
            if (n != 60 || imageInputStream.read() != 63 || imageInputStream.read() != 120 || imageInputStream.read() != 109 || imageInputStream.read() != 108) {
                boolean bl = false;
                return bl;
            }
            boolean bl = false;
            while (!bl) {
                while (imageInputStream.read() != 60) {
                }
                if (imageInputStream.read() != 33) {
                    boolean bl2 = false;
                    return bl2;
                }
                n = imageInputStream.read();
                if (n == 45 && imageInputStream.read() == 45) {
                    while (imageInputStream.read() != 45 || imageInputStream.read() != 45 || imageInputStream.read() != 62) {
                    }
                }
                if (n != 68 || imageInputStream.read() != 79 || imageInputStream.read() != 67 || imageInputStream.read() != 84 || imageInputStream.read() != 89 || imageInputStream.read() != 80 || imageInputStream.read() != 69) continue;
                bl = true;
                while (Character.isWhitespace((char)(n = imageInputStream.read()))) {
                }
                if (n != 115 || imageInputStream.read() != 118 || imageInputStream.read() != 103) continue;
                boolean bl3 = true;
                return bl3;
            }
            boolean bl4 = false;
            return bl4;
        }
        finally {
            imageInputStream.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object object) throws IOException {
        return new SVGImageReader(this);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Scaleable Vector Graphics (SVG) format image reader";
    }

    @Override
    public void onRegistration(ServiceRegistry serviceRegistry, Class<?> clazz) {
        if (!SVG_READER_AVAILABLE) {
            try {
                new SVGImageReader(this);
            }
            catch (Throwable throwable) {
                System.err.println("Could not instantiate SVGImageReader (missing support classes).");
                throwable.printStackTrace();
            }
            IIOUtil.deregisterProvider((ServiceRegistry)serviceRegistry, (IIOServiceProvider)this, clazz);
        }
    }
}

