/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.jsonrpc2.server;

import java.net.InetAddress;
import java.net.URLConnection;
import java.security.Principal;
import java.security.cert.X509Certificate;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletRequest;

public class MessageContext {
    private String clientHostName = null;
    private String clientInetAddress = null;
    private boolean secure = false;
    private Principal[] principals = null;

    public MessageContext(String clientHostName, String clientInetAddress, boolean secure, String principalName) {
        this.clientHostName = clientHostName;
        this.clientInetAddress = clientInetAddress;
        this.secure = secure;
        if (principalName != null) {
            this.principals = new Principal[1];
            this.principals[0] = new BasicPrincipal(principalName);
        }
    }

    public MessageContext(String clientHostName, String clientInetAddress, boolean secure, String[] principalNames) {
        this.clientHostName = clientHostName;
        this.clientInetAddress = clientInetAddress;
        this.secure = secure;
        if (principalNames != null) {
            this.principals = new Principal[principalNames.length];
            for (int i = 0; i < this.principals.length; ++i) {
                this.principals[0] = new BasicPrincipal(principalNames[i]);
            }
        }
    }

    public MessageContext(String clientHostName, String clientInetAddress, boolean secure) {
        this.clientHostName = clientHostName;
        this.clientInetAddress = clientInetAddress;
        this.secure = secure;
    }

    public MessageContext(String clientHostName, String clientInetAddress) {
        this.clientHostName = clientHostName;
        this.clientInetAddress = clientInetAddress;
        this.secure = false;
    }

    public MessageContext() {
        this.secure = false;
    }

    public MessageContext(HttpServletRequest httpRequest) {
        this.clientInetAddress = httpRequest.getRemoteAddr();
        this.clientHostName = httpRequest.getRemoteHost();
        if (this.clientHostName != null && this.clientHostName.equals(this.clientInetAddress)) {
            this.clientHostName = null;
        }
        this.secure = httpRequest.isSecure();
        X509Certificate[] certs = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate");
        if (certs != null && certs.length > 0) {
            this.principals = new Principal[certs.length];
            for (int i = 0; i < this.principals.length; ++i) {
                this.principals[i] = certs[i].getSubjectX500Principal();
            }
        }
    }

    public MessageContext(URLConnection connection) {
        this.clientHostName = connection.getURL().getHost();
        InetAddress ip = null;
        if (ip != null) {
            try {
                ip = InetAddress.getByName(this.clientHostName);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (ip != null) {
            this.clientInetAddress = ip.getHostAddress();
        }
        if (connection instanceof HttpsURLConnection) {
            this.secure = true;
            HttpsURLConnection httpsConnection = (HttpsURLConnection)connection;
            Principal prn = null;
            try {
                prn = httpsConnection.getPeerPrincipal();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (prn != null) {
                this.principals = new Principal[1];
                this.principals[0] = prn;
            }
        }
    }

    public String getClientHostName() {
        return this.clientHostName;
    }

    public String getClientInetAddress() {
        return this.clientInetAddress;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Principal getPrincipal() {
        if (this.principals != null) {
            return this.principals[0];
        }
        return null;
    }

    public Principal[] getPrincipals() {
        return this.principals;
    }

    public String getPrincipalName() {
        if (this.principals != null) {
            return this.principals[0].getName();
        }
        return null;
    }

    public String[] getPrincipalNames() {
        String[] names = new String[this.principals.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.principals[i].getName();
        }
        return names;
    }

    public String toString() {
        String s = "[host=" + this.clientHostName + " hostIP=" + this.clientInetAddress + " secure=" + this.secure;
        if (this.principals != null) {
            int i = 0;
            for (Principal p : this.principals) {
                s = s + " principal[" + i++ + "]=" + p;
            }
        }
        return s + "]";
    }

    public class BasicPrincipal
    implements Principal {
        private String name;

        public BasicPrincipal(String name) {
            if (name == null || name.trim().isEmpty()) {
                throw new IllegalArgumentException("The principal name must be defined");
            }
            this.name = name;
        }

        @Override
        public boolean equals(Object another) {
            return another != null && another instanceof Principal && ((Principal)another).getName().equals(this.getName());
        }

        @Override
        public int hashCode() {
            return this.getName().hashCode();
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

