/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.ByteString$;
import com.google.protobuf.CodedInputStream$;
import com.google.protobuf.Internal$;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.InvalidProtocolBufferException$;
import com.google.protobuf.WireFormat$;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import scala.Function1;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\r-s!\u0002.\\\u0011\u0003\u0011g!\u00023\\\u0011\u0003)\u0007\"\u00027\u0002\t\u0003i\u0007\"\u00028\u0002\t\u0003y\u0007B\u00028\u0002\t\u0003\u0019Y\u0001\u0003\u0004o\u0003\u0011\u00051\u0011\u0003\u0005\b\u0003\u0017\fA\u0011AB\u000e\u0011\u001d\tY-\u0001C\u0001\u0007WAqaa\r\u0002\t\u0003\u0019)\u0004C\u0004\u0004:\u0005!\taa\u000f\t\u0013\r}\u0012A1A\u0005\n\u00055\u0001\u0002CB!\u0003\u0001\u0006I!a\u0004\t\u0013\r\r\u0013A1A\u0005\n\u00055\u0001\u0002CB#\u0003\u0001\u0006I!a\u0004\t\u0013\r\u001d\u0013A1A\u0005\n\u00055\u0001\u0002CB%\u0003\u0001\u0006I!a\u0004\u0007\t\u0011\\\u0006!\u001d\u0005\teB\u0011\t\u0011)A\u0005g\"A\u0011\u0010\u0005B\u0001B\u0003%!\u0010\u0003\u0004m!\u0011%\u0011Q\u0001\u0005\n\u0003\u0017\u0001\u0002\u0019!C\u0005\u0003\u001bA\u0011\"!\u0006\u0011\u0001\u0004%I!a\u0006\t\u0011\u0005\r\u0002\u0003)Q\u0005\u0003\u001fA\u0011\"!\n\u0011\u0001\u0004%I!!\u0004\t\u0013\u0005\u001d\u0002\u00031A\u0005\n\u0005%\u0002\u0002CA\u0017!\u0001\u0006K!a\u0004\t\u0013\u0005=\u0002\u00031A\u0005\n\u00055\u0001\"CA\u0019!\u0001\u0007I\u0011BA\u001a\u0011!\t9\u0004\u0005Q!\n\u0005=\u0001\"CA\u001d!\u0001\u0007I\u0011BA\u0007\u0011%\tY\u0004\u0005a\u0001\n\u0013\ti\u0004\u0003\u0005\u0002BA\u0001\u000b\u0015BA\b\u0011%\t\u0019\u0005\u0005a\u0001\n\u0013\ti\u0001C\u0005\u0002FA\u0001\r\u0011\"\u0003\u0002H!A\u00111\n\t!B\u0013\ty\u0001C\u0005\u0002NA\u0001\r\u0011\"\u0003\u0002\u000e!I\u0011q\n\tA\u0002\u0013%\u0011\u0011\u000b\u0005\t\u0003+\u0002\u0002\u0015)\u0003\u0002\u0010!I\u0011q\u000b\tA\u0002\u0013%\u0011Q\u0002\u0005\n\u00033\u0002\u0002\u0019!C\u0005\u00037B\u0001\"a\u0018\u0011A\u0003&\u0011q\u0002\u0005\u0007YB!\t!!\u0019\t\r1\u0004B\u0011AA7\u0011\u001d\t\u0019\b\u0005C\u0005\u0003kBq!a\u001f\u0011\t\u0013\ti\bC\u0004\u0002\u0002B!I!a!\t\u000f\u00055\u0005\u0003\"\u0003\u0002\u0010\"9\u0011\u0011\u0013\t\u0005\u0002\u0005M\u0005bBAK!\u0011\u0005\u0011q\u0013\u0005\b\u00033\u0003B\u0011AAN\u0011\u001d\t\t\u000b\u0005C\u0001\u0003GCq!!+\u0011\t\u0003\tY\u000bC\u0004\u0002BB!\t!a$\t\u000f\u0005\r\u0007\u0003\"\u0001\u0002F\"9\u00111\u001a\t\u0005\u0002\u0005]\u0005b\u0002B\u0012!\u0011%\u0011q\u0012\u0005\b\u0005K\u0001B\u0011\u0002B\u0014\u0011\u001d\u0011Y\u0003\u0005C\u0005\u0005[AqA!\r\u0011\t\u0003\t9\nC\u0004\u0003@A!\tA!\u0011\t\u000f\t\r\u0003\u0003\"\u0001\u0003B!9!Q\t\t\u0005\u0002\t\u001d\u0003b\u0002B'!\u0011\u0005\u0011Q\u0002\u0005\b\u0005\u001f\u0002B\u0011\u0001B)\u0011\u001d\u0011I\u0006\u0005C\u0001\u00057BqAa\u0019\u0011\t\u0003\u0011)\u0007C\u0004\u0003nA!\tA!\u001a\t\u000f\t=\u0004\u0003\"\u0001\u0002\u0018\"9!\u0011\u000f\t\u0005\u0002\t\u0015\u0004b\u0002B:!\u0011\u0005\u0011q\u0013\u0005\b\u0005k\u0002B\u0011AAL\u0011\u001d\u00119\b\u0005C\u0001\u0003/CqA!\u001f\u0011\t\u0003\t9\nC\u0004\u0003|A!\tA!\u001a\t\u000f\tu\u0004\u0003\"\u0001\u0002\u0018\"9!q\u0010\t\u0005\u0002\t\u0015\u0004b\u0002BA!\u0011\u0005!1\u0011\u0005\b\u0005\u000b\u0003B\u0011\u0001B3\u0011!\u0011\u0019\n\u0005C\u00017\n\u0015\u0004b\u0002BQ!\u0011\u0005\u0011q\u0013\u0005\b\u0005G\u0003B\u0011\u0001B3\u0011\u001d\u0011)\u000b\u0005C\u0001\u0005OCqA!.\u0011\t\u0003\u00119\fC\u0004\u0003HB!IA!3\t\u000f\t5\u0007\u0003\"\u0001\u0003P\"9!1\u001d\t\u0005\u0002\t\u0015\bb\u0002Bt!\u0011\u0005!\u0011\u001e\u0005\b\u0005o\u0004B\u0011\u0001B}\u0011\u001d\u0011y\u0010\u0005C\u0001\u0007\u0003Aqaa\u0002\u0011\t\u0003\ty)\u0001\tD_\u0012,G-\u00138qkR\u001cFO]3b[*\u0011A,X\u0001\taJ|Go\u001c2vM*\u0011alX\u0001\u0007O>|w\r\\3\u000b\u0003\u0001\f1aY8n\u0007\u0001\u0001\"aY\u0001\u000e\u0003m\u0013\u0001cQ8eK\u0012Le\u000e];u'R\u0014X-Y7\u0014\u0005\u00051\u0007CA4k\u001b\u0005A'\"A5\u0002\u000bM\u001c\u0017\r\\1\n\u0005-D'AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002E\u0006Ya.Z<J]N$\u0018M\\2f)\r\u00018\u0011\u0002\t\u0003GB\u0019\"\u0001\u00054\u0002\r\t,hMZ3s!\r9GO^\u0005\u0003k\"\u0014Q!\u0011:sCf\u0004\"aZ<\n\u0005aD'\u0001\u0002\"zi\u0016\fQ!\u001b8qkR\u00042a_A\u0001\u001b\u0005a(BA?\u007f\u0003\tIwNC\u0001\u0000\u0003\u0011Q\u0017M^1\n\u0007\u0005\rAPA\u0006J]B,Ho\u0015;sK\u0006lG#\u00029\u0002\b\u0005%\u0001\"\u0002:\u0014\u0001\u0004\u0019\b\"B=\u0014\u0001\u0004Q\u0018!\u0005;pi\u0006d')\u001f;fgJ+G/\u001b:fIV\u0011\u0011q\u0002\t\u0004O\u0006E\u0011bAA\nQ\n\u0019\u0011J\u001c;\u0002+Q|G/\u00197CsR,7OU3uSJ,Gm\u0018\u0013fcR!\u0011\u0011DA\u0010!\r9\u00171D\u0005\u0004\u0003;A'\u0001B+oSRD\u0011\"!\t\u0016\u0003\u0003\u0005\r!a\u0004\u0002\u0007a$\u0013'\u0001\nu_R\fGNQ=uKN\u0014V\r^5sK\u0012\u0004\u0013!\u00032vM\u001a,'\u000fU8t\u00035\u0011WO\u001a4feB{7o\u0018\u0013fcR!\u0011\u0011DA\u0016\u0011%\t\t\u0003GA\u0001\u0002\u0004\ty!\u0001\u0006ck\u001a4WM\u001d)pg\u0002\n!BY;gM\u0016\u00148+\u001b>f\u00039\u0011WO\u001a4feNK'0Z0%KF$B!!\u0007\u00026!I\u0011\u0011E\u000e\u0002\u0002\u0003\u0007\u0011qB\u0001\fEV4g-\u001a:TSj,\u0007%\u0001\u0007dkJ\u0014XM\u001c;MS6LG/\u0001\tdkJ\u0014XM\u001c;MS6LGo\u0018\u0013fcR!\u0011\u0011DA \u0011%\t\tCHA\u0001\u0002\u0004\ty!A\u0007dkJ\u0014XM\u001c;MS6LG\u000fI\u0001\ng&TX\rT5nSR\fQb]5{K2KW.\u001b;`I\u0015\fH\u0003BA\r\u0003\u0013B\u0011\"!\t\"\u0003\u0003\u0005\r!a\u0004\u0002\u0015ML'0\u001a'j[&$\b%\u0001\u000bck\u001a4WM]*ju\u0016\fe\r^3s\u0019&l\u0017\u000e^\u0001\u0019EV4g-\u001a:TSj,\u0017I\u001a;fe2KW.\u001b;`I\u0015\fH\u0003BA\r\u0003'B\u0011\"!\t%\u0003\u0003\u0005\r!a\u0004\u0002+\t,hMZ3s'&TX-\u00114uKJd\u0015.\\5uA\u00059A.Y:u)\u0006<\u0017a\u00037bgR$\u0016mZ0%KF$B!!\u0007\u0002^!I\u0011\u0011E\u0014\u0002\u0002\u0003\u0007\u0011qB\u0001\tY\u0006\u001cH\u000fV1hAQ9\u0001/a\u0019\u0002f\u0005%\u0004\"\u0002:*\u0001\u0004\u0019\bbBA4S\u0001\u0007\u0011qB\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005-\u0014\u00061\u0001\u0002\u0010\u0005\u0019A.\u001a8\u0015\u0007A\fy\u0007\u0003\u0004\u0002r)\u0002\rA_\u0001\u0003SN\fq\"\u001a8tkJ,\u0017I^1jY\u0006\u0014G.\u001a\u000b\u0005\u00033\t9\bC\u0004\u0002z-\u0002\r!a\u0004\u0002\u00039\fAB]3gS2d')\u001e4gKJ$B!!\u0007\u0002\u0000!9\u0011\u0011\u0010\u0017A\u0002\u0005=\u0011a\u0004;ssJ+g-\u001b7m\u0005V4g-\u001a:\u0015\t\u0005\u0015\u00151\u0012\t\u0004O\u0006\u001d\u0015bAAEQ\n9!i\\8mK\u0006t\u0007bBA=[\u0001\u0007\u0011qB\u0001\u001ee\u0016\u001cw.\u001c9vi\u0016\u0014UO\u001a4feNK'0Z!gi\u0016\u0014H*[7jiR\u0011\u0011\u0011D\u0001\bSN\fE/\u00128e+\t\t))A\thKR$v\u000e^1m\u0005f$Xm\u001d*fC\u0012$\"!a\u0004\u0002\u0013A,8\u000f\u001b'j[&$H\u0003BA\b\u0003;Cq!a(2\u0001\u0004\ty!\u0001\u0006csR,G*[7jiB\n\u0001\u0002]8q\u0019&l\u0017\u000e\u001e\u000b\u0005\u00033\t)\u000bC\u0004\u0002(J\u0002\r!a\u0004\u0002\u0011=dG\rT5nSR\f\u0011b]6ja\u001aKW\r\u001c3\u0015\t\u0005\u0015\u0015Q\u0016\u0005\b\u0003_\u001b\u0004\u0019AA\b\u0003\r!\u0018m\u001a\u0015\u0006g\u0005M\u0016q\u0018\t\u0006O\u0006U\u0016\u0011X\u0005\u0004\u0003oC'A\u0002;ie><8\u000fE\u0002|\u0003wK1!!0}\u0005-Iu*\u0012=dKB$\u0018n\u001c8$\u0005\u0005e\u0016aC:lSBlUm]:bO\u0016\fAb]6jaJ\u000bwOQ=uKN$B!!\u0007\u0002H\"9\u0011\u0011Z\u001bA\u0002\u0005=\u0011\u0001B:ju\u0016\fqB]3bIJ\u000bwOV1sS:$8G\r\u0015\u0006m\u0005=\u0017q\u001b\t\u0006O\u0006U\u0016\u0011\u001b\t\u0004G\u0006M\u0017bAAk7\nq\u0012J\u001c<bY&$\u0007K]8u_\u000e|GNQ;gM\u0016\u0014X\t_2faRLwN\\\u0019\b=\u0005e\u0017q\u001eB\u0011!\u0011\tY.!;\u000f\t\u0005u\u0017Q\u001d\t\u0004\u0003?DWBAAq\u0015\r\t\u0019/Y\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005\u001d\b.\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\fiO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003OD\u0017'C\u0012\u0002r\u0006e(qCA~+\u0011\t\u00190!>\u0016\u0005\u0005eGaBA|\u0001\t\u0007!\u0011\u0001\u0002\u0002)&!\u00111`A\u007f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011q 5\u0002\rQD'o\\<t#\u0011\u0011\u0019A!\u0003\u0011\u0007\u001d\u0014)!C\u0002\u0003\b!\u0014qAT8uQ&tw\r\u0005\u0003\u0003\f\tEabA4\u0003\u000e%\u0019!q\u00025\u0002\u000fA\f7m[1hK&!!1\u0003B\u000b\u0005%!\u0006N]8xC\ndWMC\u0002\u0003\u0010!\f\u0014b\tB\r\u00057\u0011i\"a@\u000f\u0007\u001d\u0014Y\"C\u0002\u0002\u0000\"\fTAI4i\u0005?\u0011Qa]2bY\u0006\f4AJAi\u00035\u00198.\u001b9SC^4\u0016M]5oi\u0006)2o[5q%\u0006<h+\u0019:j]R\u001cFn\\<QCRDWCAA\rQ\u0015A\u00141WA`\u0003Q\u00198.\u001b9SC^\u0014\u0015\u0010^3t'2|w\u000fU1uQR!\u0011\u0011\u0004B\u0018\u0011\u001d\tI-\u000fa\u0001\u0003\u001f\tqA]3bIR\u000bw\rK\u0003;\u0003\u001f\u0014)$M\u0004\u001f\u00033\u00149D!\u00102\u0013\r\n\t0!?\u0003:\u0005m\u0018'C\u0012\u0003\u001a\tm!1HA\u0000c\u0015\u0011s\r\u001bB\u0010c\r1\u0013\u0011[\u0001\u000be\u0016\fGm\u0015;sS:<GCAAm\u0003U\u0011X-\u00193TiJLgn\u001a*fcVL'/Z+uMb\nqb\u00195fG.d\u0015m\u001d;UC\u001e<\u0016m\u001d\u000b\u0005\u00033\u0011I\u0005C\u0004\u0003Lu\u0002\r!a\u0004\u0002\u000bY\fG.^3\u0002%\u001d,GOQ=uKN,f\u000e^5m\u0019&l\u0017\u000e^\u0001\u000be\u0016\fG\rR8vE2,GC\u0001B*!\r9'QK\u0005\u0004\u0005/B'A\u0002#pk\ndW-A\u0005sK\u0006$g\t\\8biR\u0011!Q\f\t\u0004O\n}\u0013b\u0001B1Q\n)a\t\\8bi\u0006Q!/Z1e+&sGO\u000e\u001b\u0015\u0005\t\u001d\u0004cA4\u0003j%\u0019!1\u000e5\u0003\t1{gnZ\u0001\ne\u0016\fG-\u00138umQ\n\u0011B]3bI&sGo\r\u001a\u0002\u0017I,\u0017\r\u001a$jq\u0016$g\u0007N\u0001\fe\u0016\fGMR5yK\u0012\u001c$'\u0001\u0006sK\u0006$W+\u00138ugI\n\u0001B]3bI\u0016sW/\\\u0001\re\u0016\fGm\u0015$jq\u0016$7GM\u0001\re\u0016\fGm\u0015$jq\u0016$g\u0007N\u0001\u000be\u0016\fGmU%oiN\u0012\u0014A\u0003:fC\u0012\u001c\u0016J\u001c;7i\u0005A!/Z1e\u0005>|G\u000e\u0006\u0002\u0002\u0006\u0006y!/Z1e%\u0006<h+\u0019:j]R4D\u0007K\u0003N\u0003\u001f\u0014I)M\u0004\u001f\u00033\u0014YI!%2\u0013\r\n\t0!?\u0003\u000e\u0006m\u0018'C\u0012\u0003\u001a\tm!qRA\u0000c\u0015\u0011s\r\u001bB\u0010c\r1\u0013\u0011[\u0001\u0018e\u0016\fGMU1x-\u0006\u0014\u0018N\u001c;7iMcwn\u001e)bi\"DSATAh\u0005/\u000btAHAm\u00053\u0013y*M\u0005$\u0003c\fIPa'\u0002|FJ1E!\u0007\u0003\u001c\tu\u0015q`\u0019\u0006E\u001dD'qD\u0019\u0004M\u0005E\u0017!\u0006:fC\u0012\u0014\u0016m\u001e'jiRdW-\u00128eS\u0006t7GM\u0001\u0016e\u0016\fGMU1x\u0019&$H\u000f\\3F]\u0012L\u0017M\u001c\u001c5\u0003-\u0011X-\u00193SC^\u0014\u0015\u0010^3\u0015\u0003YDS!UAh\u0005W\u000btAHAm\u0005[\u0013\u0019,M\u0005$\u0003c\fIPa,\u0002|FJ1E!\u0007\u0003\u001c\tE\u0016q`\u0019\u0006E\u001dD'qD\u0019\u0004M\u0005E\u0017\u0001\u0004:fC\u0012\u0014\u0016m\u001e\"zi\u0016\u001cHcA:\u0003:\"9\u0011\u0011\u001a*A\u0002\u0005=\u0001&\u0002*\u0002P\nu\u0016g\u0002\u0010\u0002Z\n}&QY\u0019\nG\u0005E\u0018\u0011 Ba\u0003w\f\u0014b\tB\r\u00057\u0011\u0019-a@2\u000b\t:\u0007Na\b2\u0007\u0019\n\t.\u0001\u000bsK\u0006$'+Y<CsR,7o\u00157poB\u000bG\u000f\u001b\u000b\u0004g\n-\u0007bBAe'\u0002\u0007\u0011qB\u0001\ne\u0016\fGMQ=uKN$\"A!5\u0011\u0007\r\u0014\u0019.C\u0002\u0003Vn\u0013!BQ=uKN#(/\u001b8hQ\u0015!\u0016q\u001aBmc\u001dq\u0012\u0011\u001cBn\u0005C\f\u0014bIAy\u0003s\u0014i.a?2\u0013\r\u0012IBa\u0007\u0003`\u0006}\u0018'\u0002\u0012hQ\n}\u0011g\u0001\u0014\u0002R\u0006i!/Z1e\u0005f$X-\u0011:sCf$\u0012a]\u0001\u000fe\u0016\fGMQ=uK\n+hMZ3s)\t\u0011Y\u000f\u0005\u0003\u0003n\nMXB\u0001Bx\u0015\r\u0011\tP`\u0001\u0004]&|\u0017\u0002\u0002B{\u0005_\u0014!BQ=uK\n+hMZ3s\u00039)g.\u00192mK\u0006c\u0017.Y:j]\u001e$B!!\u0007\u0003|\"9!Q`,A\u0002\u0005\u0015\u0015\u0001C1mS\u0006\u001c\u0018N\\4\u0002\u0019M,GoU5{K2KW.\u001b;\u0015\t\u0005=11\u0001\u0005\b\u0007\u000bA\u0006\u0019AA\b\u0003\u0015a\u0017.\\5u\u0003A\u0011Xm]3u'&TXmQ8v]R,'\u000fC\u0003z\u0007\u0001\u0007!\u0010F\u0002q\u0007\u001bAaaa\u0004\u0005\u0001\u0004\u0019\u0018a\u00012vMR9\u0001oa\u0005\u0004\u0016\re\u0001BBB\b\u000b\u0001\u00071\u000fC\u0004\u0004\u0018\u0015\u0001\r!a\u0004\u0002\u0007=4g\rC\u0004\u0002l\u0015\u0001\r!a\u0004\u0015\t\u0005=1Q\u0004\u0005\u0006s\u001a\u0001\rA\u001f\u0015\u0006\r\u0005=7\u0011E\u0019\b=\u0005e71EB\u0015c%\u0019\u0013\u0011_A}\u0007K\tY0M\u0005$\u00053\u0011Yba\n\u0002\u0000F*!e\u001a5\u0003 E\u001aa%!5\u0015\r\u0005=1QFB\u0019\u0011\u001d\u0019yc\u0002a\u0001\u0003\u001f\t\u0011BZ5sgR\u0014\u0015\u0010^3\t\u000be<\u0001\u0019\u0001>\u0002\u001d\u0011,7m\u001c3f5&<',Y44eQ!\u0011qBB\u001c\u0011\u001d\tI\b\u0003a\u0001\u0003\u001f\ta\u0002Z3d_\u0012,',[4[C\u001e4D\u0007\u0006\u0003\u0003h\ru\u0002bBA=\u0013\u0001\u0007!qM\u0001\u0018\t\u00163\u0015)\u0016'U?J+5)\u0016*T\u0013>su\fT%N\u0013R\u000b\u0001\u0004R#G\u0003VcEk\u0018*F\u0007V\u00136+S(O?2KU*\u0013+!\u0003I!UIR!V\u0019R{6+\u0013.F?2KU*\u0013+\u0002'\u0011+e)Q+M)~\u001b\u0016JW#`\u0019&k\u0015\n\u0016\u0011\u0002\u0017\t+fIR#S?NK%,R\u0001\r\u0005V3e)\u0012*`'&SV\t\t")
public class CodedInputStream {
    private final byte[] buffer;
    private final InputStream input;
    private int totalBytesRetired;
    private int bufferPos;
    private int bufferSize;
    private int currentLimit;
    private int sizeLimit;
    private int bufferSizeAfterLimit;
    private int lastTag;

    public static long decodeZigZag64(long l) {
        return CodedInputStream$.MODULE$.decodeZigZag64(l);
    }

    public static int decodeZigZag32(int n) {
        return CodedInputStream$.MODULE$.decodeZigZag32(n);
    }

    public static CodedInputStream newInstance(byte[] byArray, int n, int n2) {
        return CodedInputStream$.MODULE$.newInstance(byArray, n, n2);
    }

    public static CodedInputStream newInstance(byte[] byArray) {
        return CodedInputStream$.MODULE$.newInstance(byArray);
    }

    public static CodedInputStream newInstance(InputStream inputStream) {
        return CodedInputStream$.MODULE$.newInstance(inputStream);
    }

    private int totalBytesRetired() {
        return this.totalBytesRetired;
    }

    private void totalBytesRetired_$eq(int x$1) {
        this.totalBytesRetired = x$1;
    }

    private int bufferPos() {
        return this.bufferPos;
    }

    private void bufferPos_$eq(int x$1) {
        this.bufferPos = x$1;
    }

    private int bufferSize() {
        return this.bufferSize;
    }

    private void bufferSize_$eq(int x$1) {
        this.bufferSize = x$1;
    }

    private int currentLimit() {
        return this.currentLimit;
    }

    private void currentLimit_$eq(int x$1) {
        this.currentLimit = x$1;
    }

    private int sizeLimit() {
        return this.sizeLimit;
    }

    private void sizeLimit_$eq(int x$1) {
        this.sizeLimit = x$1;
    }

    private int bufferSizeAfterLimit() {
        return this.bufferSizeAfterLimit;
    }

    private void bufferSizeAfterLimit_$eq(int x$1) {
        this.bufferSizeAfterLimit = x$1;
    }

    private int lastTag() {
        return this.lastTag;
    }

    private void lastTag_$eq(int x$1) {
        this.lastTag = x$1;
    }

    private void ensureAvailable(int n) {
        block0: {
            if (this.bufferSize() - this.bufferPos() >= n) break block0;
            this.refillBuffer(n);
        }
    }

    private void refillBuffer(int n) {
        if (!this.tryRefillBuffer(n)) {
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
    }

    private boolean tryRefillBuffer(int n) {
        Boolean bl;
        if (this.bufferPos() + n <= this.bufferSize()) {
            throw new IllegalStateException(new StringBuilder(66).append("refillBuffer() called when ").append(n).append(" bytes were already available in buffer").toString());
        }
        if (this.totalBytesRetired() + this.bufferPos() + n > this.currentLimit()) {
            bl = BoxesRunTime.boxToBoolean((boolean)false);
        } else {
            if (this.input != null) {
                int bytesRead;
                int pos = this.bufferPos();
                if (pos > 0) {
                    if (this.bufferSize() > pos) {
                        System.arraycopy(this.buffer, pos, this.buffer, 0, this.bufferSize() - pos);
                    }
                    this.totalBytesRetired_$eq(this.totalBytesRetired() + pos);
                    this.bufferSize_$eq(this.bufferSize() - pos);
                    this.bufferPos_$eq(0);
                }
                if ((bytesRead = this.input.read(this.buffer, this.bufferSize(), this.buffer.length - this.bufferSize())) == 0 || bytesRead < -1 || bytesRead > this.buffer.length) {
                    throw new IllegalStateException(new StringBuilder(91).append("InputStream#read(byte[]) returned invalid result: ").append(bytesRead).append("\nThe InputStream implementation is buggy.").toString());
                }
                if (bytesRead > 0) {
                    this.bufferSize_$eq(this.bufferSize() + bytesRead);
                    if (this.totalBytesRetired() + n - this.sizeLimit() > 0) {
                        throw InvalidProtocolBufferException$.MODULE$.sizeLimitExceeded();
                    }
                    this.recomputeBufferSizeAfterLimit();
                    return this.bufferSize() >= n || this.tryRefillBuffer(n);
                }
            }
            bl = BoxedUnit.UNIT;
        }
        return false;
    }

    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize_$eq(this.bufferSize() + this.bufferSizeAfterLimit());
        int bufferEnd = this.totalBytesRetired() + this.bufferSize();
        if (bufferEnd > this.currentLimit()) {
            this.bufferSizeAfterLimit_$eq(bufferEnd - this.currentLimit());
            this.bufferSize_$eq(this.bufferSize() - this.bufferSizeAfterLimit());
        } else {
            this.bufferSizeAfterLimit_$eq(0);
        }
    }

    public boolean isAtEnd() {
        return this.bufferPos() == this.bufferSize() && !this.tryRefillBuffer(1);
    }

    public int getTotalBytesRead() {
        return this.totalBytesRetired() + this.bufferPos();
    }

    /*
     * WARNING - void declaration
     */
    public int pushLimit(int byteLimit0) {
        void var3_3;
        int oldLimit;
        if (byteLimit0 < 0) {
            throw InvalidProtocolBufferException$.MODULE$.negativeSize();
        }
        int byteLimit = byteLimit0 + this.totalBytesRetired() + this.bufferPos();
        if (byteLimit > (oldLimit = this.currentLimit())) {
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
        this.currentLimit_$eq(byteLimit);
        this.recomputeBufferSizeAfterLimit();
        return (int)var3_3;
    }

    public void popLimit(int oldLimit) {
        this.currentLimit_$eq(oldLimit);
        this.recomputeBufferSizeAfterLimit();
    }

    public boolean skipField(int tag) throws IOException {
        boolean bl;
        int n = WireFormat$.MODULE$.getTagWireType(tag);
        if (WireFormat$.MODULE$.WIRETYPE_VARINT() == n) {
            this.skipRawVarint();
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_FIXED64() == n) {
            this.skipRawBytes(8);
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_LENGTH_DELIMITED() == n) {
            this.skipRawBytes(this.readRawVarint32());
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_START_GROUP() == n) {
            this.skipMessage();
            this.checkLastTagWas(WireFormat$.MODULE$.makeTag(WireFormat$.MODULE$.getTagFieldNumber(tag), WireFormat$.MODULE$.WIRETYPE_END_GROUP()));
            bl = true;
        } else if (WireFormat$.MODULE$.WIRETYPE_END_GROUP() == n) {
            bl = false;
        } else if (WireFormat$.MODULE$.WIRETYPE_FIXED32() == n) {
            this.skipRawBytes(4);
            bl = true;
        } else {
            throw InvalidProtocolBufferException$.MODULE$.invalidWireType();
        }
        return bl;
    }

    public void skipMessage() {
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField(tag)) {
        }
    }

    public void skipRawBytes(int size) {
        if (size <= this.bufferSize() - this.bufferPos() && size >= 0) {
            this.bufferPos_$eq(this.bufferPos() + size);
        } else {
            this.skipRawBytesSlowPath(size);
        }
    }

    public int readRawVarint32() throws InvalidProtocolBufferException {
        int pos = this.bufferPos();
        if (this.bufferSize() == pos) {
            return (int)this.readRawVarint64SlowPath();
        }
        byte[] buffer = this.buffer;
        int x = 0;
        if ((x = buffer[++pos - 1]) >= 0) {
            this.bufferPos_$eq(pos);
            return x;
        }
        if (this.bufferSize() - pos < 9) {
            return (int)this.readRawVarint64SlowPath();
        }
        if ((x ^= buffer[++pos - 1] << 7) < 0) {
            x ^= ~0 << 7;
        } else if ((x ^= buffer[++pos - 1] << 14) >= 0) {
            x ^= ~0 << 7 ^ ~0 << 14;
        } else if ((x ^= buffer[++pos - 1] << 21) < 0) {
            x ^= ~0 << 7 ^ ~0 << 14 ^ ~0 << 21;
        } else {
            byte y = buffer[++pos - 1];
            x ^= y << 28;
            x ^= ~0 << 7 ^ ~0 << 14 ^ ~0 << 21 ^ ~0 << 28;
            if (y < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0 && buffer[++pos - 1] < 0) {
                return (int)this.readRawVarint64SlowPath();
            }
        }
        this.bufferPos_$eq(pos);
        return x;
    }

    private void skipRawVarint() {
        if (this.bufferSize() - this.bufferPos() >= 10) {
            byte[] buffer = this.buffer;
            int pos = this.bufferPos();
            int i = 0;
            while (i < 10) {
                if (buffer[++pos - 1] >= 0) {
                    this.bufferPos_$eq(pos);
                    return;
                }
                int cfr_ignored_0 = ++i - 1;
            }
        }
        this.skipRawVarintSlowPath();
    }

    private void skipRawVarintSlowPath() throws IOException {
        int i = 0;
        while (i < 10) {
            if (this.readRawByte() >= 0) {
                return;
            }
            int cfr_ignored_0 = ++i - 1;
        }
        throw InvalidProtocolBufferException$.MODULE$.malformedVarint();
    }

    private void skipRawBytesSlowPath(int size) {
        if (size < 0) {
            throw InvalidProtocolBufferException$.MODULE$.negativeSize();
        }
        if (this.totalBytesRetired() + this.bufferPos() + size > this.currentLimit()) {
            this.skipRawBytes(this.currentLimit() - this.totalBytesRetired() - this.bufferPos());
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
        int pos = this.bufferSize() - this.bufferPos();
        this.bufferPos_$eq(this.bufferSize());
        this.refillBuffer(1);
        while (size - pos > this.bufferSize()) {
            pos += this.bufferSize();
            this.bufferPos_$eq(this.bufferSize());
            this.refillBuffer(1);
        }
        this.bufferPos_$eq(size - pos);
    }

    public int readTag() throws InvalidProtocolBufferException {
        if (this.isAtEnd()) {
            this.lastTag_$eq(0);
            return 0;
        }
        this.lastTag_$eq(this.readRawVarint32());
        if (WireFormat$.MODULE$.getTagFieldNumber(this.lastTag()) == 0) {
            throw InvalidProtocolBufferException$.MODULE$.invalidTag();
        }
        return this.lastTag();
    }

    public String readString() {
        int size = this.readRawVarint32();
        if (size <= this.bufferSize() - this.bufferPos() && size > 0) {
            String result = new String(this.buffer, this.bufferPos(), size, Internal$.MODULE$.UTF_8());
            this.bufferPos_$eq(this.bufferPos() + size);
            return result;
        }
        if (size == 0) {
            return "";
        }
        return new String(this.readRawBytesSlowPath(size), Internal$.MODULE$.UTF_8());
    }

    public String readStringRequireUtf8() {
        return this.readString();
    }

    public void checkLastTagWas(int value) {
        if (this.lastTag() != value) {
            throw InvalidProtocolBufferException$.MODULE$.invalidEndTag();
        }
    }

    public int getBytesUntilLimit() {
        if (this.currentLimit() == Integer.MAX_VALUE) {
            return -1;
        }
        int currentAbsolutePosition = this.totalBytesRetired() + this.bufferPos();
        return this.currentLimit() - currentAbsolutePosition;
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public float readFloat() {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public long readUInt64() {
        return this.readRawVarint64();
    }

    public long readInt64() {
        return this.readRawVarint64();
    }

    public int readInt32() {
        return this.readRawVarint32();
    }

    public long readFixed64() {
        return this.readRawLittleEndian64();
    }

    public int readFixed32() {
        return this.readRawLittleEndian32();
    }

    public int readUInt32() {
        return this.readRawVarint32();
    }

    public int readEnum() {
        return this.readRawVarint32();
    }

    public int readSFixed32() {
        return this.readRawLittleEndian32();
    }

    public long readSFixed64() {
        return this.readRawLittleEndian64();
    }

    public int readSInt32() {
        return CodedInputStream$.MODULE$.decodeZigZag32(this.readRawVarint32());
    }

    public long readSInt64() {
        return CodedInputStream$.MODULE$.decodeZigZag64(this.readRawVarint64());
    }

    public boolean readBool() {
        return this.readRawVarint64() != 0L;
    }

    /*
     * WARNING - void declaration
     */
    public long readRawVarint64() throws InvalidProtocolBufferException {
        void var3_3;
        int pos = this.bufferPos();
        if (this.bufferSize() == pos) {
            return this.readRawVarint64SlowPath();
        }
        byte[] buffer = this.buffer;
        long x = 0L;
        int y = 0;
        if ((y = buffer[++pos - 1]) >= 0) {
            this.bufferPos_$eq(pos);
            return y;
        }
        if (this.bufferSize() - pos < 9) {
            return this.readRawVarint64SlowPath();
        }
        if ((y ^= buffer[++pos - 1] << 7) < 0) {
            x = y ^ ~0 << 7;
        } else if ((y ^= buffer[++pos - 1] << 14) >= 0) {
            x = y ^ (~0 << 7 ^ ~0 << 14);
        } else if ((y ^= buffer[++pos - 1] << 21) < 0) {
            x = y ^ (~0 << 7 ^ ~0 << 14 ^ ~0 << 21);
        } else if ((x = (long)y ^ (long)buffer[++pos - 1] << 28) >= 0L) {
            x ^= (0L ^ 0xFFFFFFFFFFFFFFFFL) << 7 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 14 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 21 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 28;
        } else if ((x ^= (long)buffer[++pos - 1] << 35) < 0L) {
            x ^= (0L ^ 0xFFFFFFFFFFFFFFFFL) << 7 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 14 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 21 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 28 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 35;
        } else if ((x ^= (long)buffer[++pos - 1] << 42) >= 0L) {
            x ^= (0L ^ 0xFFFFFFFFFFFFFFFFL) << 7 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 14 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 21 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 28 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 35 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 42;
        } else if ((x ^= (long)buffer[++pos - 1] << 49) < 0L) {
            x ^= (0L ^ 0xFFFFFFFFFFFFFFFFL) << 7 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 14 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 21 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 28 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 35 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 42 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 49;
        } else {
            x ^= (long)buffer[++pos - 1] << 56;
            if ((x ^= (0L ^ 0xFFFFFFFFFFFFFFFFL) << 7 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 14 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 21 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 28 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 35 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 42 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 49 ^ (0L ^ 0xFFFFFFFFFFFFFFFFL) << 56) < 0L && (long)buffer[++pos - 1] < 0L) {
                return this.readRawVarint64SlowPath();
            }
        }
        this.bufferPos_$eq(pos);
        return (long)var3_3;
    }

    public long readRawVarint64SlowPath() throws InvalidProtocolBufferException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw InvalidProtocolBufferException$.MODULE$.malformedVarint();
    }

    public int readRawLittleEndian32() {
        int pos = this.bufferPos();
        if (this.bufferSize() - pos < 4) {
            this.refillBuffer(4);
            pos = this.bufferPos();
        }
        byte[] buffer = this.buffer;
        this.bufferPos_$eq(pos + 4);
        return buffer[pos] & 0xFF | (buffer[pos + 1] & 0xFF) << 8 | (buffer[pos + 2] & 0xFF) << 16 | (buffer[pos + 3] & 0xFF) << 24;
    }

    public long readRawLittleEndian64() {
        int pos = this.bufferPos();
        if (this.bufferSize() - pos < 8) {
            this.refillBuffer(8);
            pos = this.bufferPos();
        }
        byte[] buffer = this.buffer;
        this.bufferPos_$eq(pos + 8);
        return (long)buffer[pos] & 0xFFL | ((long)buffer[pos + 1] & 0xFFL) << 8 | ((long)buffer[pos + 2] & 0xFFL) << 16 | ((long)buffer[pos + 3] & 0xFFL) << 24 | ((long)buffer[pos + 4] & 0xFFL) << 32 | ((long)buffer[pos + 5] & 0xFFL) << 40 | ((long)buffer[pos + 6] & 0xFFL) << 48 | ((long)buffer[pos + 7] & 0xFFL) << 56;
    }

    public byte readRawByte() throws InvalidProtocolBufferException {
        if (this.bufferPos() == this.bufferSize()) {
            this.refillBuffer(1);
        }
        this.bufferPos_$eq(this.bufferPos() + 1);
        return this.buffer[this.bufferPos() - 1];
    }

    public byte[] readRawBytes(int size) throws InvalidProtocolBufferException {
        byte[] byArray;
        int pos = this.bufferPos();
        if (size <= this.bufferSize() - pos && size > 0) {
            this.bufferPos_$eq(pos + size);
            byArray = Arrays.copyOfRange(this.buffer, pos, pos + size);
        } else {
            byArray = this.readRawBytesSlowPath(size);
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readRawBytesSlowPath(int size) {
        byte[] byArray;
        if (size <= 0) {
            if (size == 0) {
                return Internal$.MODULE$.EMPTY_BYTE_ARRAY();
            }
            throw InvalidProtocolBufferException$.MODULE$.negativeSize();
        }
        if (this.totalBytesRetired() + this.bufferPos() + size > this.currentLimit()) {
            this.skipRawBytes(this.currentLimit() - this.totalBytesRetired() - this.bufferPos());
            throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
        }
        if (size < CodedInputStream$.MODULE$.com$google$protobuf$CodedInputStream$$BUFFER_SIZE()) {
            void var2_2;
            byte[] bytes = new byte[size];
            int pos = this.bufferSize() - this.bufferPos();
            System.arraycopy(this.buffer, this.bufferPos(), bytes, 0, pos);
            this.bufferPos_$eq(this.bufferSize());
            this.ensureAvailable(size - pos);
            System.arraycopy(this.buffer, 0, bytes, pos, size - pos);
            this.bufferPos_$eq(size - pos);
            byArray = var2_2;
        } else {
            byte[] chunk2;
            int originalBufferPos = this.bufferPos();
            int originalBufferSize = this.bufferSize();
            this.totalBytesRetired_$eq(this.totalBytesRetired() + this.bufferSize());
            this.bufferPos_$eq(0);
            this.bufferSize_$eq(0);
            ArrayBuffer chunks = new ArrayBuffer();
            for (int sizeLeft = size - (originalBufferSize - originalBufferPos); sizeLeft > 0; sizeLeft -= chunk2.length) {
                int n;
                chunk2 = new byte[Math.min(sizeLeft, CodedInputStream$.MODULE$.com$google$protobuf$CodedInputStream$$BUFFER_SIZE())];
                for (int pos = 0; pos < chunk2.length; pos += n) {
                    int n2 = n = this.input == null ? -1 : this.input.read(chunk2, pos, chunk2.length - pos);
                    if (n == -1) {
                        throw InvalidProtocolBufferException$.MODULE$.truncatedMessage();
                    }
                    this.totalBytesRetired_$eq(this.totalBytesRetired() + n);
                }
                chunks.$plus$eq((Object)chunk2);
            }
            byte[] bytes = new byte[size];
            IntRef pos = IntRef.create((int)(originalBufferSize - originalBufferPos));
            System.arraycopy(this.buffer, originalBufferPos, bytes, 0, pos.elem);
            chunks.foreach((Function1 & Serializable & scala.Serializable)chunk -> {
                CodedInputStream.$anonfun$readRawBytesSlowPath$1(bytes, pos, chunk);
                return BoxedUnit.UNIT;
            });
            byArray = bytes;
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     */
    public ByteString readBytes() throws InvalidProtocolBufferException {
        ByteString byteString;
        int size = this.readRawVarint32();
        if (size <= this.bufferSize() - this.bufferPos() && size > 0) {
            void var2_2;
            ByteString result = ByteString$.MODULE$.copyFrom(this.buffer, this.bufferPos(), size);
            this.bufferPos_$eq(this.bufferPos() + size);
            byteString = var2_2;
        } else {
            byteString = size == 0 ? ByteString$.MODULE$.EMPTY() : ByteString$.MODULE$.useBuffer(this.readRawBytesSlowPath(size));
        }
        return byteString;
    }

    public byte[] readByteArray() {
        return this.readBytes().toByteArray();
    }

    public ByteBuffer readByteBuffer() {
        return ByteBuffer.wrap(this.readByteArray());
    }

    public void enableAliasing(boolean aliasing) {
    }

    /*
     * WARNING - void declaration
     */
    public int setSizeLimit(int limit) {
        void var2_2;
        if (limit < 0) {
            throw new IllegalArgumentException(new StringBuilder(31).append("Size limit cannot be negative: ").append(limit).toString());
        }
        int oldLimit = this.sizeLimit();
        this.sizeLimit_$eq(limit);
        return (int)var2_2;
    }

    public void resetSizeCounter() {
        this.totalBytesRetired_$eq(-this.bufferPos());
    }

    public static final /* synthetic */ void $anonfun$readRawBytesSlowPath$1(byte[] bytes$1, IntRef pos$1, byte[] chunk) {
        System.arraycopy(chunk, 0, bytes$1, pos$1.elem, chunk.length);
        pos$1.elem += chunk.length;
    }

    private CodedInputStream(byte[] buffer, InputStream input) {
        this.buffer = buffer;
        this.input = input;
        this.totalBytesRetired = 0;
        this.bufferPos = 0;
        this.bufferSize = 0;
        this.currentLimit = Integer.MAX_VALUE;
        this.sizeLimit = CodedInputStream$.MODULE$.com$google$protobuf$CodedInputStream$$DEFAULT_SIZE_LIMIT();
        this.bufferSizeAfterLimit = 0;
        this.lastTag = 0;
    }

    public CodedInputStream(byte[] buffer, int offset, int len) {
        this(buffer, null);
        this.bufferPos_$eq(offset);
        this.bufferSize_$eq(offset + len);
        this.totalBytesRetired_$eq(-offset);
    }

    public CodedInputStream(InputStream is) {
        this(new byte[CodedInputStream$.MODULE$.com$google$protobuf$CodedInputStream$$BUFFER_SIZE()], is);
        this.totalBytesRetired_$eq(0);
    }
}

