/*
 * Decompiled with CFR 0.152.
 */
package shade.polaris.com.google.common.collect;

import java.util.Queue;
import javax.annotation.CheckForNull;
import shade.polaris.com.google.common.annotations.GwtCompatible;
import shade.polaris.com.google.common.base.Preconditions;
import shade.polaris.com.google.common.collect.AbstractIterator;
import shade.polaris.com.google.common.collect.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class ConsumingQueueIterator<T>
extends AbstractIterator<T> {
    private final Queue<T> queue;

    ConsumingQueueIterator(Queue<T> queue) {
        this.queue = Preconditions.checkNotNull(queue);
    }

    @Override
    @CheckForNull
    public T computeNext() {
        if (this.queue.isEmpty()) {
            return this.endOfData();
        }
        return this.queue.remove();
    }
}

